/*
		Endeavour Image Browser Operation Callbacks
 */

#ifndef IMBR_OP_CB_H
#define IMBR_OP_CB_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "edv_types.h"
#include "edv_device.h"
#include "edv_mount_bar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"
#include "imbr.h"


extern void EDVImbrOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVImbrOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVImbrOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern void EDVImbrOPClose(edv_imbr_struct *imbr);
extern void EDVImbrOPExit(edv_imbr_struct *imbr);

extern void EDVImbrOPSyncDisks(edv_imbr_struct *imbr);
extern void EDVImbrOPRun(edv_imbr_struct *imbr);
extern void EDVImbrOPWriteProtect(edv_imbr_struct *imbr);
extern void EDVImbrOPDeleteMethodRecycle(edv_imbr_struct *imbr);
extern void EDVImbrOPDeleteMethodPurge(edv_imbr_struct *imbr);

extern void EDVImbrOPNewObject(
	edv_imbr_struct *imbr, toolbar_item_struct *item
);
extern void EDVImbrOPNewFile(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDirectory(edv_imbr_struct *imbr);
extern void EDVImbrOPNewLink(edv_imbr_struct *imbr);
extern void EDVImbrOPNewFifo(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceBlock(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceCharacter(edv_imbr_struct *imbr);
extern void EDVImbrOPNewSocket(edv_imbr_struct *imbr);

extern void EDVImbrOPOpen(edv_imbr_struct *imbr);
extern void EDVImbrOPOpenWith(edv_imbr_struct *imbr);

extern void EDVImbrOPCopyPath(edv_imbr_struct *imbr);
extern void EDVImbrOPCopyURL(edv_imbr_struct *imbr);
extern void EDVImbrOPPaste(edv_imbr_struct *imbr);

extern void EDVImbrOPMove(edv_imbr_struct *imbr);
extern void EDVImbrOPCopy(edv_imbr_struct *imbr);
extern void EDVImbrOPLink(edv_imbr_struct *imbr);
extern void EDVImbrOPRename(edv_imbr_struct *imbr);
extern void EDVImbrOPChMod(edv_imbr_struct *imbr);
extern void EDVImbrOPChOwn(edv_imbr_struct *imbr);
extern void EDVImbrOPChTime(edv_imbr_struct *imbr);
extern void EDVImbrOPDelete(edv_imbr_struct *imbr);
extern void EDVImbrOPProperties(edv_imbr_struct *imbr);

extern void EDVImbrOPSelectAll(edv_imbr_struct *imbr);
extern void EDVImbrOPUnselectAll(edv_imbr_struct *imbr);
extern void EDVImbrOPInvertSelection(edv_imbr_struct *imbr);

extern void EDVImbrOPDownload(edv_imbr_struct *imbr);

extern void EDVImbrOPRefresh(edv_imbr_struct *imbr);
extern void EDVImbrOPRefreshAll(edv_imbr_struct *imbr);
extern void EDVImbrOPStop(edv_imbr_struct *imbr);
extern void EDVImbrOpContinue(edv_imbr_struct *imbr);
extern void EDVImbrOpPresentationMode(edv_imbr_struct *imbr);

extern void EDVImbrThumbsListFilter(edv_imbr_struct *imbr);

extern void EDVImbrMIMETypes(edv_imbr_struct *imbr);


#endif	/* IMBR_OP_CB_H */
