-----------------------------------------------------------------------------
-- Tab2str: Table to String.
-- Produce a string with Lua code that can rebuild the given table.

-----------------------------------------------------------------------------
-- "Imprime" uma tabela em uma string.
-- Os campos so gerados na ordem que vierem da funo next.
-- Os campos de valores numricos no so separados dos campos "string"
-- e os outros tipos (userdata, funo e tabela) so ignorados.
-- Se o parmetro [[spacing]] for nulo,  considerado como se fosse [[""]].
-- caso contrrio, seu valor  usado na indentao e um [[\n]]  acrescentado
-- entre os elementos.
-- Cada tabela listada ganha um nmero (indicado entre [[<]] e [[>]],
-- logo depois da [[{]] inicial) que serve para referncia cruzada de
-- tabelas j listadas.  Neste caso, as tabelas j listadas so
-- representadas por [[{@]] seguido do nmero da tabela e [[}]].
-- @param t Nmero a ser "impresso".
-- @param spacing String de espaamento entre elementos da tabela.
-- @param indent String com a indentao inicial (este parmetro  utilizado
--	pela prpria funo para acumular a indentao de tabelas internas).
-- @return String com o resultado.

function tab2str (t, spacing, indent)
   local tipo = type (t)
   if tipo == "string" then
      return format ("%q",t)
   elseif tipo == "number" then
      return t
   elseif tipo == "table" then
      if _table_ then
         if _table_[t] then
            return "{@".._table_[t].."}"
         else
            _table_.n = _table_.n + 1
            _table_[t] = _table_.n
         end
      end
      local aux = ""
      local s = "{"
      if _table_ then
         s = s.."<".._table_[t]..">"
      end
      if not indent then
         indent = ""
      end
      if spacing then
         aux = indent .. spacing
      end
      local i,v
      i, v = next (t, nil)
      while i do
         if spacing then
            s = s .. '\n' .. aux
         end
         local t_i = type(i)
         if t_i == "number" or t_i == "string" then
            s = format ("%s[%s] = %s,", s, tab2str (i), tab2str (v, spacing, aux))
         end
         i, v = next (t, i)
      end
      if spacing then
         s = s .. '\n' .. indent
      end
      return s .. "}"
   else
      return "<"..tipo..">"
   end
end

function t2s (t, s, i)
   local old_table = _table_
   _table_ = { n = 0 }
   local result = tab2str (t, s, i)
   _table_ = old_table
   return result
end
