/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: DdtCipher.h,v 1.1 2001/11/24 21:26:16 benoit Exp $
 *
 * Copyright (c) 2001 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DDTCIPHER_H
#define DDTCIPHER_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

extern "C"
{
#include <stddef.h>
#include <gcrypt.h>
}

#include "Logger.h"

class DdtCipher
{
public:
    enum CipherAlgos
    {
        ALGO_NONE = GCRY_CIPHER_NONE,
        ALGO_IDEA = GCRY_CIPHER_IDEA,
        ALGO_3DES = GCRY_CIPHER_3DES,
        ALGO_CAST5 = GCRY_CIPHER_CAST5,
        ALGO_BLOWFISH = GCRY_CIPHER_BLOWFISH,
        ALGO_ROT13 = 666
    };

    enum CipherModes
    {
        MODE_NONE = GCRY_CIPHER_MODE_NONE,
        MODE_ECB = GCRY_CIPHER_MODE_ECB,
        MODE_CFB = GCRY_CIPHER_MODE_CFB,
        MODE_CBC = GCRY_CIPHER_MODE_CBC,
        MODE_STREAM = GCRY_CIPHER_MODE_STREAM
    };

    DdtCipher(CipherAlgos algo, CipherModes mode);
    ~DdtCipher();

    void setKey(unsigned char *key, int size);
    void setIV(unsigned char *iv, int size);
    void decrypt(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength);
    void encrypt(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength);


private:
    GCRY_CIPHER_HD cipherHandle;
    CipherAlgos algo;
    CipherModes mode;

    void strRot13(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength);

};


#endif
