/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * main.cc
 *    Sample program using the thread and mutex classes.
 *
 * $Id: main.cc,v 1.5 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2001 Remi Lefebvre <remi@debian.org>
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

#include <iostream>
#include <stdio.h>
#include <pthread.h>
#include <unistd.h>

#include "Exception.h"
#include "Thread.h"

class ThreadDriver : public Thread
{
public:
    ThreadDriver(void *);
    
    void *run(void *);
    void cleanUp() { };
    
};

ThreadDriver::ThreadDriver(void *i_arg) : Thread(i_arg) { }

void *ThreadDriver::run(void *i_arg)
{
    static Mutex l_protect;
    
    int i;

    try 
    {   
        cout << "Wait for Mutex: " << a_thread << endl;
      
        l_protect.lock();
        for (i = 0; i < 4; i++)
        {
            cout << "Thread " << (int) a_thread << " args: " << *(int *)i_arg << endl;
            sleep(1);
        }
        l_protect.unlock();
        
        cout << "Mutex Freed by " << a_thread << endl;
    }

    catch(DdtException &e) 
    {
        cout << "DdtException occured: " << e.message() << endl;
    }
    catch(...) 
    {
        cout << "Unknown exception" << endl;
    }
    
    return NULL;
}


int main(void)
{
    int t1(1);
    int t2(2);
  
    ThreadDriver l_thread1 (&t1);
    ThreadDriver l_thread2 (&t2);
  
    try 
    {
        l_thread1.start();
        l_thread2.start();      
        Thread::join (&l_thread1);
        Thread::join (&l_thread2);
    }
  
    catch (DdtException &e) 
    {
        cout << "Error: " << e.message() << endl;
    }
    catch (...) 
    {
        cout << "Unknown error" << endl;
    }
  
    return 0;
}

