/*
 * libpam-sfs - Pluggable Authentication Module for SFS
 * 
 * Copyright (C) 2000, 2001 Luca Filipozzi
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

#include <errno.h>
#include <limits.h>
#include <nana.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#define PAM_SM_AUTH
#include <security/pam_modules.h>

#include "handler.h"

int main(int argc, const char **argv)
{
    const char *service = "";
    const char *username;
    const char *password;
    handler     handler;
    int         rval;
    int         flags = 0;

    username = strdup(argv[1]);
    password = strdup(argv[2]);

    rval = handler.pam_sm_authenticate(service, flags, argc, argv,
                                       username, password);

    return rval;
}

