
/* autogenerated from gstbayerorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void bayer_orc_horiz_upsample_unaligned (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void bayer_orc_horiz_upsample (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void bayer_orc_merge_bg_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_gr_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_bg_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_gr_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_bg_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_gr_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_bg_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);
void bayer_orc_merge_gr_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX (orc_uint8) 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX (orc_uint16)65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* bayer_orc_horiz_upsample_unaligned */
#ifdef DISABLE_ORC
void
bayer_orc_horiz_upsample_unaligned (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var37.i;
      var40 = _src.x2[1];
      var41 = _src.x2[0];
    }
    /* 2: loadoffw */
    var42 = ptr4[i + 1];
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var43 = _src.x2[1];
      var44 = _src.x2[0];
    }
    /* 4: avgub */
    var45 = ((orc_uint8) var40 + (orc_uint8) var43 + 1) >> 1;
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var45;
      var38.i = _dest.i;
    }
    /* 6: storew */
    ptr0[i] = var38;
    /* 7: avgub */
    var46 = ((orc_uint8) var41 + (orc_uint8) var44 + 1) >> 1;
    /* 8: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var44;
      var39.i = _dest.i;
    }
    /* 9: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_bayer_orc_horiz_upsample_unaligned (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_int8 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var37.i;
      var40 = _src.x2[1];
      var41 = _src.x2[0];
    }
    /* 2: loadoffw */
    var42 = ptr4[i + 1];
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var43 = _src.x2[1];
      var44 = _src.x2[0];
    }
    /* 4: avgub */
    var45 = ((orc_uint8) var40 + (orc_uint8) var43 + 1) >> 1;
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var45;
      var38.i = _dest.i;
    }
    /* 6: storew */
    ptr0[i] = var38;
    /* 7: avgub */
    var46 = ((orc_uint8) var41 + (orc_uint8) var44 + 1) >> 1;
    /* 8: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var44;
      var39.i = _dest.i;
    }
    /* 9: storew */
    ptr1[i] = var39;
  }

}

void
bayer_orc_horiz_upsample_unaligned (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 104, 111, 114,
        105, 122, 95, 117, 112, 115, 97, 109, 112, 108, 101, 95, 117, 110, 97,
        108,
        105, 103, 110, 101, 100, 11, 2, 2, 11, 2, 2, 12, 2, 2, 14, 4,
        1, 0, 0, 0, 20, 2, 20, 1, 20, 1, 20, 1, 20, 1, 199, 34,
        33, 4, 83, 32, 4, 16, 199, 36, 35, 32, 39, 36, 34, 36, 196, 0,
        34, 36, 39, 33, 33, 35, 196, 1, 33, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_bayer_orc_horiz_upsample_unaligned);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_horiz_upsample_unaligned");
      orc_program_set_backup_function (p,
          _backup_bayer_orc_horiz_upsample_unaligned);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");

      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_horiz_upsample */
#ifdef DISABLE_ORC
void
bayer_orc_horiz_upsample (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union16 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + -1];
    /* 1: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.i;
      var41 = _src.x2[1];
    }
    /* 2: loadw */
    var37 = ptr4[i];
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var37.i;
      var42 = _src.x2[1];
      var43 = _src.x2[0];
    }
    /* 4: loadoffw */
    var44 = ptr4[i + 1];
    /* 5: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var45 = _src.x2[0];
    }
    /* 6: avgub */
    var46 = ((orc_uint8) var43 + (orc_uint8) var45 + 1) >> 1;
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var43;
      _dest.x2[1] = var46;
      var38.i = _dest.i;
    }
    /* 8: storew */
    ptr0[i] = var38;
    /* 9: avgub */
    var47 = ((orc_uint8) var41 + (orc_uint8) var42 + 1) >> 1;
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var42;
      var39.i = _dest.i;
    }
    /* 11: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_bayer_orc_horiz_upsample (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var40 = ptr4[i + -1];
    /* 1: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.i;
      var41 = _src.x2[1];
    }
    /* 2: loadw */
    var37 = ptr4[i];
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var37.i;
      var42 = _src.x2[1];
      var43 = _src.x2[0];
    }
    /* 4: loadoffw */
    var44 = ptr4[i + 1];
    /* 5: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var45 = _src.x2[0];
    }
    /* 6: avgub */
    var46 = ((orc_uint8) var43 + (orc_uint8) var45 + 1) >> 1;
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var43;
      _dest.x2[1] = var46;
      var38.i = _dest.i;
    }
    /* 8: storew */
    ptr0[i] = var38;
    /* 9: avgub */
    var47 = ((orc_uint8) var41 + (orc_uint8) var42 + 1) >> 1;
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var42;
      var39.i = _dest.i;
    }
    /* 11: storew */
    ptr1[i] = var39;
  }

}

void
bayer_orc_horiz_upsample (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 24, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 104, 111, 114,
        105, 122, 95, 117, 112, 115, 97, 109, 112, 108, 101, 11, 2, 2, 11, 2,
        2, 12, 2, 2, 14, 4, 255, 255, 255, 255, 14, 4, 1, 0, 0, 0,
        20, 2, 20, 1, 20, 1, 20, 1, 20, 1, 83, 32, 4, 16, 189, 33,
        32, 199, 35, 34, 4, 83, 32, 4, 17, 188, 36, 32, 39, 36, 34, 36,
        196, 0, 34, 36, 39, 33, 33, 35, 196, 1, 33, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_horiz_upsample);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_horiz_upsample");
      orc_program_set_backup_function (p, _backup_bayer_orc_horiz_upsample);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 4, 0xffffffff, "c1");
      orc_program_add_constant (p, 4, 0x00000001, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_bg_bgra */
#ifdef DISABLE_ORC
void
bayer_orc_merge_bg_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: loadw */
    var44 = ptr6[i];
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_bg_bgra (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: loadw */
    var44 = ptr6[i];
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_bg_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 98, 103, 95, 98, 103, 114, 97, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 255, 0, 0, 0, 14, 2, 0, 255, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 5,
        9, 21, 1, 39, 35, 4, 8, 79, 36, 7, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 33,
        6, 35, 21, 1, 196, 32, 34, 18, 21, 1, 195, 0, 33, 32, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_bgra);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_bg_bgra");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_bgra);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x0000ff00, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_gr_bgra */
#ifdef DISABLE_ORC
void
bayer_orc_merge_gr_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 15: loadw */
    var44 = ptr7[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_gr_bgra (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 15: loadw */
    var44 = ptr7[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_gr_bgra (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 103, 114, 95, 98, 103, 114, 97, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 0, 255, 0, 0, 14, 2, 255, 0, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 4,
        8, 21, 1, 39, 35, 5, 9, 79, 36, 6, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 33,
        34, 35, 21, 1, 196, 32, 7, 18, 21, 1, 195, 0, 33, 32, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_bgra);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_gr_bgra");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_bgra);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x0000ff00, "c1");
      orc_program_add_constant (p, 2, 0x000000ff, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_bg_abgr */
#ifdef DISABLE_ORC
void
bayer_orc_merge_bg_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: loadw */
    var45 = ptr6[i];
    /* 16: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var47.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var47.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_bg_abgr (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: loadw */
    var45 = ptr6[i];
    /* 16: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var47.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var47.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_bg_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 98, 103, 95, 97, 98, 103, 114, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 255, 0, 0, 0, 14, 2, 0, 255, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 5,
        9, 21, 1, 39, 35, 4, 8, 79, 36, 7, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        18, 6, 21, 1, 196, 33, 35, 34, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_abgr);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_bg_abgr");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_abgr);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x0000ff00, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_gr_abgr */
#ifdef DISABLE_ORC
void
bayer_orc_merge_gr_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var47.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var47.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 16: loadw */
    var45 = ptr7[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_gr_abgr (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var47.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var47.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 16: loadw */
    var45 = ptr7[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_gr_abgr (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 103, 114, 95, 97, 98, 103, 114, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 0, 255, 0, 0, 14, 2, 255, 0, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 4,
        8, 21, 1, 39, 35, 5, 9, 79, 36, 6, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        18, 34, 21, 1, 196, 33, 35, 7, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_abgr);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_gr_abgr");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_abgr);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x0000ff00, "c1");
      orc_program_add_constant (p, 2, 0x000000ff, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_bg_rgba */
#ifdef DISABLE_ORC
void
bayer_orc_merge_bg_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 15: loadw */
    var44 = ptr6[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_bg_rgba (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 15: loadw */
    var44 = ptr6[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_bg_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 98, 103, 95, 114, 103, 98, 97, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 255, 0, 0, 0, 14, 2, 0, 255, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 5,
        9, 21, 1, 39, 35, 4, 8, 79, 36, 7, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        34, 35, 21, 1, 196, 33, 6, 18, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_rgba);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_bg_rgba");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_rgba);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x0000ff00, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_gr_rgba */
#ifdef DISABLE_ORC
void
bayer_orc_merge_gr_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: loadw */
    var44 = ptr7[i];
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_gr_rgba (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union16 var44;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var45;
#else
  orc_union16 var45;
#endif
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 16: loadpb */
  var45.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var45.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 14: loadw */
    var44 = ptr7[i];
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var53.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var53.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var47.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_gr_rgba (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 103, 114, 95, 114, 103, 98, 97, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 0, 255, 0, 0, 14, 2, 255, 0, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 4,
        8, 21, 1, 39, 35, 5, 9, 79, 36, 6, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        7, 35, 21, 1, 196, 33, 34, 18, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_rgba);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_gr_rgba");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_rgba);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x0000ff00, "c1");
      orc_program_add_constant (p, 2, 0x000000ff, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_bg_argb */
#ifdef DISABLE_ORC
void
bayer_orc_merge_bg_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var47.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var47.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 16: loadw */
    var45 = ptr6[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_bg_argb (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 11: loadpw */
  var43.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr5[i];
    /* 1: loadw */
    var38 = ptr9[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr4[i];
    /* 4: loadw */
    var40 = ptr8[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr7[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var47.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var47.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 16: loadw */
    var45 = ptr6[i];
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var45.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var45.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_bg_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 98, 103, 95, 97, 114, 103, 98, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 255, 0, 0, 0, 14, 2, 0, 255, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 5,
        9, 21, 1, 39, 35, 4, 8, 79, 36, 7, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        18, 34, 21, 1, 196, 33, 35, 6, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_argb);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_bg_argb");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_bg_argb);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x0000ff00, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif


/* bayer_orc_merge_gr_argb */
#ifdef DISABLE_ORC
void
bayer_orc_merge_gr_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_union16 *) s3;
  ptr7 = (orc_union16 *) s4;
  ptr8 = (orc_union16 *) s5;
  ptr9 = (orc_union16 *) s6;

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: loadw */
    var45 = ptr7[i];
    /* 16: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var47.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var47.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_bayer_orc_merge_gr_argb (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  const orc_union16 *ORC_RESTRICT ptr7;
  const orc_union16 *ORC_RESTRICT ptr8;
  const orc_union16 *ORC_RESTRICT ptr9;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union16 var45;
  orc_union64 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_union16 *) ex->arrays[6];
  ptr7 = (orc_union16 *) ex->arrays[7];
  ptr8 = (orc_union16 *) ex->arrays[8];
  ptr9 = (orc_union16 *) ex->arrays[9];

  /* 9: loadpw */
  var42.i = 0x0000ff00;         /* 65280 or 3.22526e-319f */
  /* 11: loadpw */
  var43.i = 0x000000ff;         /* 255 or 1.25987e-321f */
  /* 14: loadpb */
  var44.x2[0] = 0x000000ff;     /* 255 or 1.25987e-321f */
  var44.x2[1] = 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var37 = ptr4[i];
    /* 1: loadw */
    var38 = ptr8[i];
    /* 2: avgub */
    var47.x2[0] = ((orc_uint8) var37.x2[0] + (orc_uint8) var38.x2[0] + 1) >> 1;
    var47.x2[1] = ((orc_uint8) var37.x2[1] + (orc_uint8) var38.x2[1] + 1) >> 1;
    /* 3: loadw */
    var39 = ptr5[i];
    /* 4: loadw */
    var40 = ptr9[i];
    /* 5: avgub */
    var48.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var40.x2[0] + 1) >> 1;
    var48.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var40.x2[1] + 1) >> 1;
    /* 6: loadw */
    var41 = ptr6[i];
    /* 7: copyw */
    var49.i = var41.i;
    /* 8: avgub */
    var50.x2[0] = ((orc_uint8) var48.x2[0] + (orc_uint8) var49.x2[0] + 1) >> 1;
    var50.x2[1] = ((orc_uint8) var48.x2[1] + (orc_uint8) var49.x2[1] + 1) >> 1;
    /* 10: andw */
    var51.i = var50.i & var42.i;
    /* 12: andw */
    var52.i = var49.i & var43.i;
    /* 13: orw */
    var53.i = var52.i | var51.i;
    /* 15: loadw */
    var45 = ptr7[i];
    /* 16: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var54.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var54.x2[1] = _dest.i;
    }
    /* 17: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[0];
      _dest.x2[1] = var47.x2[0];
      var55.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var53.x2[1];
      _dest.x2[1] = var47.x2[1];
      var55.x2[1] = _dest.i;
    }
    /* 18: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[0];
      _dest.x2[1] = var55.x2[0];
      var46.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var54.x2[1];
      _dest.x2[1] = var55.x2[1];
      var46.x2[1] = _dest.i;
    }
    /* 19: storeq */
    ptr0[i] = var46;
  }

}

void
bayer_orc_merge_gr_argb (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, const guint8 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 98, 97, 121, 101, 114, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 103, 114, 95, 97, 114, 103, 98, 11, 8, 8, 12, 2, 2,
        12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14,
        2, 0, 255, 0, 0, 14, 2, 255, 0, 0, 0, 14, 1, 255, 0, 0,
        0, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 21, 1, 39, 34, 4,
        8, 21, 1, 39, 35, 5, 9, 79, 36, 6, 21, 1, 39, 35, 35, 36,
        73, 35, 35, 16, 73, 36, 36, 17, 92, 35, 36, 35, 21, 1, 196, 32,
        18, 7, 21, 1, 196, 33, 35, 34, 21, 1, 195, 0, 32, 33, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_argb);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "bayer_orc_merge_gr_argb");
      orc_program_set_backup_function (p, _backup_bayer_orc_merge_gr_argb);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_constant (p, 2, 0x0000ff00, "c1");
      orc_program_add_constant (p, 2, 0x000000ff, "c2");
      orc_program_add_constant (p, 1, 0x000000ff, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_S5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_S6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyw", 0, ORC_VAR_T5, ORC_VAR_S3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orw", 0, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;
  ex->arrays[ORC_VAR_S6] = (void *) s6;

  func = c->exec;
  func (ex);
}
#endif
