SET(USE_CCACHE "OFF" CACHE BOOL "Use ccache for building")
SET(CCACHE_EXECUTABLE "" CACHE FILEPATH
    "Path to the ccache executable to use when USE_CCACHE is set")

IF(USE_CCACHE)
    IF(CCACHE_EXECUTABLE STREQUAL "")
        UNSET(CCACHE_EXECUTABLE CACHE)
        FIND_PROGRAM(CCACHE_EXECUTABLE "ccache")
        IF(NOT CCACHE_EXECUTABLE)
            MESSAGE(FATAL_ERROR "USE_CCACHE set, but ccache was not found!")
        ENDIF()
        MESSAGE(STATUS "Using ccache (detected): ${CCACHE_EXECUTABLE}")
    ELSE()
        MESSAGE(STATUS "Using ccache: ${CCACHE_EXECUTABLE}")
    ENDIF()
    SET_PROPERTY(GLOBAL PROPERTY RULE_LAUNCH_COMPILE "${CCACHE_EXECUTABLE}")
    SET_PROPERTY(GLOBAL PROPERTY RULE_LAUNCH_LINK "${CCACHE_EXECUTABLE}")
ENDIF()
