/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef GRID_CELL_SEARCH_H
#define GRID_CELL_SEARCH_H

#include <cstddef>
#include "array.h"

extern "C"
{
#include "lib/yac/grid_cell.h"
}

enum class CellSearchMethod
{
  spherepart,
  latbins
};

struct GridCellSearch
{
  bool in_use = false;

  CellSearchMethod method{CellSearchMethod::spherepart};

  bool is_reg2d = false;
  size_t dims[2] = { 0 };

  // reg2d search
  double gridBoundboxReg2d[4] = { 0 };
  Varray<double> reg2d_corner_lon, reg2d_corner_lat;

  void *yacSrcGrid = nullptr;
  void *yacSearch = nullptr;
};

void gridCellSearchCreateReg2d(GridCellSearch &gcs, size_t dims[2], const Varray<double> &reg2d_corner_lon, const Varray<double> &reg2d_corner_lat);
void gridCellSearchCreate(GridCellSearch &gcs, size_t numCells, size_t numCellCorners, Varray<double> &cellCornerLon, Varray<double> &cellCornerLat);
void gridCellSearchDelete(GridCellSearch &gcs);
size_t doGridCellSearch(GridCellSearch &gcs, bool isLonLatCell, grid_cell &gridCell, size_t *srchAddr);
void setCellSearchMethod(const char *methodstr);

#endif
