/**
 * This file is compiled from several Madwifi header files.
 * Original copyright is:
 *
 * Copyright (c) 2001 Atsushi Onoe
 * Copyright (c) 2002-2005 Sam Leffler, Errno Consulting
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MADWIFI_H
#define MADWIFI_H

#define IEEE80211_ADDR_LEN 6 /* size of 802.11 address */
#define IEEE80211_RATE_VAL 0x7f
#define IEEE80211_RATE_SIZE 8     /* 802.11 standard */
#define IEEE80211_RATE_MAXSIZE 15 /* max rates we'll handle */

/*
 * Per/node (station) statistics available when operating as an AP.
 */
struct ieee80211_nodestats {
  u_int32_t ns_rx_data;      /* rx data frames */
  u_int32_t ns_rx_mgmt;      /* rx management frames */
  u_int32_t ns_rx_ctrl;      /* rx control frames */
  u_int32_t ns_rx_ucast;     /* rx unicast frames */
  u_int32_t ns_rx_mcast;     /* rx multi/broadcast frames */
  u_int64_t ns_rx_bytes;     /* rx data count (bytes) */
  u_int64_t ns_rx_beacons;   /* rx beacon frames */
  u_int32_t ns_rx_proberesp; /* rx probe response frames */

  u_int32_t ns_rx_dup;         /* rx discard because it's a dup */
  u_int32_t ns_rx_noprivacy;   /* rx w/ wep but privacy off */
  u_int32_t ns_rx_wepfail;     /* rx wep processing failed */
  u_int32_t ns_rx_demicfail;   /* rx demic failed */
  u_int32_t ns_rx_decap;       /* rx decapsulation failed */
  u_int32_t ns_rx_defrag;      /* rx defragmentation failed */
  u_int32_t ns_rx_disassoc;    /* rx disassociation */
  u_int32_t ns_rx_deauth;      /* rx deauthentication */
  u_int32_t ns_rx_decryptcrc;  /* rx decrypt failed on crc */
  u_int32_t ns_rx_unauth;      /* rx on unauthorized port */
  u_int32_t ns_rx_unencrypted; /* rx unecrypted w/ privacy */

  u_int32_t ns_tx_data;     /* tx data frames */
  u_int32_t ns_tx_mgmt;     /* tx management frames */
  u_int32_t ns_tx_ucast;    /* tx unicast frames */
  u_int32_t ns_tx_mcast;    /* tx multi/broadcast frames */
  u_int64_t ns_tx_bytes;    /* tx data count (bytes) */
  u_int32_t ns_tx_probereq; /* tx probe request frames */
  u_int32_t ns_tx_uapsd;    /* tx on uapsd queue */

  u_int32_t ns_tx_novlantag;    /* tx discard due to no tag */
  u_int32_t ns_tx_vlanmismatch; /* tx discard due to of bad tag */

  u_int32_t ns_tx_eosplost; /* uapsd EOSP retried out */

  u_int32_t ns_ps_discard; /* ps discard due to of age */

  u_int32_t ns_uapsd_triggers; /* uapsd triggers */

  /* MIB-related state */
  u_int32_t ns_tx_assoc;         /* [re]associations */
  u_int32_t ns_tx_assoc_fail;    /* [re]association failures */
  u_int32_t ns_tx_auth;          /* [re]authentications */
  u_int32_t ns_tx_auth_fail;     /* [re]authentication failures*/
  u_int32_t ns_tx_deauth;        /* deauthentications */
  u_int32_t ns_tx_deauth_code;   /* last deauth reason */
  u_int32_t ns_tx_disassoc;      /* disassociations */
  u_int32_t ns_tx_disassoc_code; /* last disassociation reason */
  u_int32_t ns_psq_drops;        /* power save queue drops */
};

/*
 * Summary statistics.
 */
struct ieee80211_stats {
  u_int32_t is_rx_badversion;           /* rx frame with bad version */
  u_int32_t is_rx_tooshort;             /* rx frame too short */
  u_int32_t is_rx_wrongbss;             /* rx from wrong bssid */
  u_int32_t is_rx_dup;                  /* rx discard due to it's a dup */
  u_int32_t is_rx_wrongdir;             /* rx w/ wrong direction */
  u_int32_t is_rx_mcastecho;            /* rx discard due to of mcast echo */
  u_int32_t is_rx_notassoc;             /* rx discard due to sta !assoc */
  u_int32_t is_rx_noprivacy;            /* rx w/ wep but privacy off */
  u_int32_t is_rx_unencrypted;          /* rx w/o wep and privacy on */
  u_int32_t is_rx_wepfail;              /* rx wep processing failed */
  u_int32_t is_rx_decap;                /* rx decapsulation failed */
  u_int32_t is_rx_mgtdiscard;           /* rx discard mgt frames */
  u_int32_t is_rx_ctl;                  /* rx discard ctrl frames */
  u_int32_t is_rx_beacon;               /* rx beacon frames */
  u_int32_t is_rx_rstoobig;             /* rx rate set truncated */
  u_int32_t is_rx_elem_missing;         /* rx required element missing*/
  u_int32_t is_rx_elem_toobig;          /* rx element too big */
  u_int32_t is_rx_elem_toosmall;        /* rx element too small */
  u_int32_t is_rx_elem_unknown;         /* rx element unknown */
  u_int32_t is_rx_badchan;              /* rx frame w/ invalid chan */
  u_int32_t is_rx_chanmismatch;         /* rx frame chan mismatch */
  u_int32_t is_rx_nodealloc;            /* rx frame dropped */
  u_int32_t is_rx_ssidmismatch;         /* rx frame ssid mismatch  */
  u_int32_t is_rx_auth_unsupported;     /* rx w/ unsupported auth alg */
  u_int32_t is_rx_auth_fail;            /* rx sta auth failure */
  u_int32_t is_rx_auth_countermeasures; /* rx auth discard due to CM */
  u_int32_t is_rx_assoc_bss;            /* rx assoc from wrong bssid */
  u_int32_t is_rx_assoc_notauth;        /* rx assoc w/o auth */
  u_int32_t is_rx_assoc_capmismatch;    /* rx assoc w/ cap mismatch */
  u_int32_t is_rx_assoc_norate;         /* rx assoc w/ no rate match */
  u_int32_t is_rx_assoc_badwpaie;       /* rx assoc w/ bad WPA IE */
  u_int32_t is_rx_deauth;               /* rx deauthentication */
  u_int32_t is_rx_disassoc;             /* rx disassociation */
  u_int32_t is_rx_badsubtype;           /* rx frame w/ unknown subtype*/
  u_int32_t is_rx_nobuf;                /* rx failed for lack of buf */
  u_int32_t is_rx_decryptcrc;           /* rx decrypt failed on crc */
  u_int32_t is_rx_ahdemo_mgt;           /* rx discard ahdemo mgt frame*/
  u_int32_t is_rx_bad_auth;             /* rx bad auth request */
  u_int32_t is_rx_unauth;               /* rx on unauthorized port */
  u_int32_t is_rx_badkeyid;             /* rx w/ incorrect keyid */
  u_int32_t is_rx_ccmpreplay;           /* rx seq# violation (CCMP) */
  u_int32_t is_rx_ccmpformat;           /* rx format bad (CCMP) */
  u_int32_t is_rx_ccmpmic;              /* rx MIC check failed (CCMP) */
  u_int32_t is_rx_tkipreplay;           /* rx seq# violation (TKIP) */
  u_int32_t is_rx_tkipformat;           /* rx format bad (TKIP) */
  u_int32_t is_rx_tkipmic;              /* rx MIC check failed (TKIP) */
  u_int32_t is_rx_tkipicv;              /* rx ICV check failed (TKIP) */
  u_int32_t is_rx_badcipher;            /* rx failed due to of key type */
  u_int32_t is_rx_nocipherctx;          /* rx failed due to key !setup */
  u_int32_t is_rx_acl;                  /* rx discard due to of acl policy */
  u_int32_t is_rx_ffcnt;                /* rx fast frames */
  u_int32_t is_rx_badathtnl;            /* driver key alloc failed */
  u_int32_t is_tx_nobuf;                /* tx failed for lack of buf */
  u_int32_t is_tx_nonode;               /* tx failed for no node */
  u_int32_t is_tx_unknownmgt;           /* tx of unknown mgt frame */
  u_int32_t is_tx_badcipher;            /* tx failed due to of key type */
  u_int32_t is_tx_nodefkey;             /* tx failed due to no defkey */
  u_int32_t is_tx_noheadroom;           /* tx failed due to no space */
  u_int32_t is_tx_ffokcnt;              /* tx fast frames sent success */
  u_int32_t is_tx_fferrcnt;             /* tx fast frames sent success */
  u_int32_t is_scan_active;             /* active scans started */
  u_int32_t is_scan_passive;            /* passive scans started */
  u_int32_t is_node_timeout;            /* nodes timed out inactivity */
  u_int32_t is_crypto_nomem;            /* no memory for crypto ctx */
  u_int32_t is_crypto_tkip;             /* tkip crypto done in s/w */
  u_int32_t is_crypto_tkipenmic;        /* tkip en-MIC done in s/w */
  u_int32_t is_crypto_tkipdemic;        /* tkip de-MIC done in s/w */
  u_int32_t is_crypto_tkipcm;           /* tkip counter measures */
  u_int32_t is_crypto_ccmp;             /* ccmp crypto done in s/w */
  u_int32_t is_crypto_wep;              /* wep crypto done in s/w */
  u_int32_t is_crypto_setkey_cipher;    /* cipher rejected key */
  u_int32_t is_crypto_setkey_nokey;     /* no key index for setkey */
  u_int32_t is_crypto_delkey;           /* driver key delete failed */
  u_int32_t is_crypto_badcipher;        /* unknown cipher */
  u_int32_t is_crypto_nocipher;         /* cipher not available */
  u_int32_t is_crypto_attachfail;       /* cipher attach failed */
  u_int32_t is_crypto_swfallback;       /* cipher fallback to s/w */
  u_int32_t is_crypto_keyfail;          /* driver key alloc failed */
  u_int32_t is_crypto_enmicfail;        /* en-MIC failed */
  u_int32_t is_ibss_capmismatch;        /* merge failed-cap mismatch */
  u_int32_t is_ibss_norate;             /* merge failed-rate mismatch */
  u_int32_t is_ps_unassoc;              /* ps-poll for unassoc. sta */
  u_int32_t is_ps_badaid;               /* ps-poll w/ incorrect aid */
  u_int32_t is_ps_qempty;               /* ps-poll w/ nothing to send */
};

/*
 * Retrieve per-node statistics.
 */
struct ieee80211req_sta_stats {
  union {
    /* NB: explicitly force 64-bit alignment */
    u_int8_t macaddr[IEEE80211_ADDR_LEN];
    u_int64_t pad;
  } is_u;
  struct ieee80211_nodestats is_stats;
};

/*
 * Station information block; the mac address is used
 * to retrieve other data like stats, unicast key, etc.
 */
struct ieee80211req_sta_info {
  u_int16_t isi_len;     /* length (mult of 4) */
  u_int16_t isi_freq;    /* MHz */
  u_int16_t isi_flags;   /* channel flags */
  u_int16_t isi_state;   /* state flags */
  u_int8_t isi_authmode; /* authentication algorithm */
  u_int8_t isi_rssi;
  u_int16_t isi_capinfo; /* capabilities */
  u_int8_t isi_athflags; /* Atheros capabilities */
  u_int8_t isi_erp;      /* ERP element */
  u_int8_t isi_macaddr[IEEE80211_ADDR_LEN];
  u_int8_t isi_nrates; /* negotiated rates */
  u_int8_t isi_rates[IEEE80211_RATE_MAXSIZE];
  u_int8_t isi_txrate;      /* index to isi_rates[] */
  u_int16_t isi_ie_len;     /* IE length */
  u_int16_t isi_associd;    /* assoc response */
  u_int16_t isi_txpower;    /* current tx power */
  u_int16_t isi_vlan;       /* vlan tag */
  u_int16_t isi_txseqs[17]; /* seq to be transmitted */
  u_int16_t isi_rxseqs[17]; /* seq previous for qos frames*/
  u_int16_t isi_inact;      /* inactivity timer */
  u_int8_t isi_uapsd;       /* UAPSD queues */
  u_int8_t isi_opmode;      /* sta operating mode */

  /* XXX frag state? */
  /* variable length IE data */
};

struct ath_stats {
  u_int32_t ast_watchdog;      /* device reset by watchdog */
  u_int32_t ast_hardware;      /* fatal hardware error interrupts */
  u_int32_t ast_bmiss;         /* beacon miss interrupts */
  u_int32_t ast_rxorn;         /* rx overrun interrupts */
  u_int32_t ast_rxeol;         /* rx eol interrupts */
  u_int32_t ast_txurn;         /* tx underrun interrupts */
  u_int32_t ast_mib;           /* mib interrupts */
  u_int32_t ast_tx_packets;    /* packet sent on the interface */
  u_int32_t ast_tx_mgmt;       /* management frames transmitted */
  u_int32_t ast_tx_discard;    /* frames discarded prior to assoc */
  u_int32_t ast_tx_invalid;    /* frames discarded due to is device gone */
  u_int32_t ast_tx_qstop;      /* tx queue stopped because it's full */
  u_int32_t ast_tx_encap;      /* tx encapsulation failed */
  u_int32_t ast_tx_nonode;     /* tx failed due to of no node */
  u_int32_t ast_tx_nobuf;      /* tx failed due to of no tx buffer (data) */
  u_int32_t ast_tx_nobufmgt;   /* tx failed due to of no tx buffer (mgmt)*/
  u_int32_t ast_tx_xretries;   /* tx failed due to of too many retries */
  u_int32_t ast_tx_fifoerr;    /* tx failed due to of FIFO underrun */
  u_int32_t ast_tx_filtered;   /* tx failed due to xmit filtered */
  u_int32_t ast_tx_shortretry; /* tx on-chip retries (short) */
  u_int32_t ast_tx_longretry;  /* tx on-chip retries (long) */
  u_int32_t ast_tx_badrate;    /* tx failed due to of bogus xmit rate */
  u_int32_t ast_tx_noack;      /* tx frames with no ack marked */
  u_int32_t ast_tx_rts;        /* tx frames with rts enabled */
  u_int32_t ast_tx_cts;        /* tx frames with cts enabled */
  u_int32_t ast_tx_shortpre;   /* tx frames with short preamble */
  u_int32_t ast_tx_altrate;    /* tx frames with alternate rate */
  u_int32_t ast_tx_protect;    /* tx frames with protection */
  u_int32_t ast_rx_orn;        /* rx failed due to of desc overrun */
  u_int32_t ast_rx_crcerr;     /* rx failed due to of bad CRC */
  u_int32_t ast_rx_fifoerr;    /* rx failed due to of FIFO overrun */
  u_int32_t ast_rx_badcrypt;   /* rx failed due to of decryption */
  u_int32_t ast_rx_badmic;     /* rx failed due to of MIC failure */
  u_int32_t ast_rx_phyerr;     /* rx PHY error summary count */
  u_int32_t ast_rx_phy[32];    /* rx PHY error per-code counts */
  u_int32_t ast_rx_tooshort;   /* rx discarded due to frame too short */
  u_int32_t ast_rx_toobig;     /* rx discarded due to frame too large */
  u_int32_t ast_rx_nobuf;      /* rx setup failed due to of no skbuff */
  u_int32_t ast_rx_packets;    /* packet recv on the interface */
  u_int32_t ast_rx_mgt;        /* management frames received */
  u_int32_t ast_rx_ctl;        /* control frames received */
  int8_t ast_tx_rssi;          /* tx rssi of last ack */
  int8_t ast_rx_rssi;          /* rx rssi from histogram */
  u_int32_t ast_be_xmit;       /* beacons transmitted */
  u_int32_t ast_be_nobuf;      /* no skbuff available for beacon */
  u_int32_t ast_per_cal;       /* periodic calibration calls */
  u_int32_t ast_per_calfail;   /* periodic calibration failed */
  u_int32_t ast_per_rfgain;    /* periodic calibration rfgain reset */
  u_int32_t ast_rate_calls;    /* rate control checks */
  u_int32_t ast_rate_raise;    /* rate control raised xmit rate */
  u_int32_t ast_rate_drop;     /* rate control dropped xmit rate */
  u_int32_t ast_ant_defswitch; /* rx/default antenna switches */
  u_int32_t ast_ant_txswitch;  /* tx antenna switches */
  u_int32_t ast_ant_rx[8];     /* rx frames with antenna */
  u_int32_t ast_ant_tx[8];     /* tx frames with antenna */
};

#define SIOCGATHSTATS (SIOCDEVPRIVATE + 0)
#define SIOCGATHDIAG (SIOCDEVPRIVATE + 1)
#define SIOCGATHRADARSIG (SIOCDEVPRIVATE + 2)
#define SIOCGATHHALDIAG (SIOCDEVPRIVATE + 3)
#define SIOCG80211STATS (SIOCDEVPRIVATE + 2)
/* NB: require in+out parameters so cannot use wireless extensions, yech */
#define IEEE80211_IOCTL_GETKEY (SIOCDEVPRIVATE + 3)
#define IEEE80211_IOCTL_GETWPAIE (SIOCDEVPRIVATE + 4)
#define IEEE80211_IOCTL_STA_STATS (SIOCDEVPRIVATE + 5)
#define IEEE80211_IOCTL_STA_INFO (SIOCDEVPRIVATE + 6)
#define SIOC80211IFCREATE (SIOCDEVPRIVATE + 7)
#define SIOC80211IFDESTROY (SIOCDEVPRIVATE + 8)
#define IEEE80211_IOCTL_SCAN_RESULTS (SIOCDEVPRIVATE + 9)

#endif
