/*
 * parameters.c
 *
 * Example 1 of the Debian package diploma
 *
 * Copyright (C) 1999 Andreas Franzen
 *
 * See the file copyright for details.
 *
 * This program creates the paramter files which are included in the
 * TeX-text.
 */
#include<stdio.h>
#include"../inc/salt.h"
int main()
{
  FILE *f;
  f=fopen("min2theta.tex","w");
  fprintf(f,"%4.0f^\\circ",min2theta);
  fclose(f); 
  f=fopen("max2theta.tex","w");
  fprintf(f,"%5.1f^\\circ",max2theta);
  fclose(f); 
  f=fopen("stepnumber.tex","w");
  fprintf(f,"%4d",stepnumber);
  fclose(f); 
  f=fopen("stepsize.tex","w");
  fprintf(f,"%4.2f",(max2theta-min2theta)/stepnumber);
  fclose(f); 
  f=fopen("lambdaKalpha1.tex","w");
  fprintf(f,"%9.7f\\,\\mathrm{nm}",lambdaKalpha1*1.0e9);
  fclose(f); 
  f=fopen("lambdaKalpha2.tex","w");
  fprintf(f,"%9.7f\\,\\mathrm{nm}",lambdaKalpha2*1.0e9);
  fclose(f); 
  f=fopen("lambdaKbeta.tex","w");
  fprintf(f,"%8.6f\\,\\mathrm{nm}",lambdaKbeta*1.0e9);
  fclose(f); 
/*
 * return(0) tells the make command that this program was successfully
 * terminated.
 */
  return(0);
}
 