package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2015
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the LogGamma distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 * @since 0.6.0
 */
public class LogGammaAlternateDistributionTest extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_1_1 = { //
  6.32120558865345572030491894111037254333496093750000e-01, // 0.000000
  6.32124237622968987437843679799698293209075927734375e-01, // 0.000010
  6.68845722847090984330975516058970242738723754882812e-01, // 0.100000
  6.77419000750269617583398940041661262512207031250000e-01, // 0.123457
  7.05183679270841912156697617319878190755844116210938e-01, // 0.200000
  7.30816370768268552815527527855010703206062316894531e-01, // 0.271828
  7.40723134009172445857416278158780187368392944335938e-01, // 0.300000
  7.45666217579490364641969790682196617126464843750000e-01, // 0.314159
  7.75038206450081590404010967176873236894607543945312e-01, // 0.400000
  8.07704354452035144795729593170108273625373840332031e-01, // 0.500000
  8.38317185854873470063353124714922159910202026367188e-01, // 0.600000
  8.66513203341916171673631197336362674832344055175781e-01, // 0.700000
  8.91991022303408431781690524076111614704132080078125e-01, // 0.800000
  9.14531134124054068124110017379280179738998413085938e-01, // 0.900000
  9.34011964154687457373427150741918012499809265136719e-01, // 1.000000
  9.50419914304432955631796176021452993154525756835938e-01, // 1.100000
  9.63851395086864459749165234825341030955314636230469e-01, // 1.200000
  9.74505605324275880896323087654309347271919250488281e-01, // 1.300000
  9.82667985991235504172891523921862244606018066406250e-01, // 1.400000
  9.88685713619540385010964200773742049932479858398438e-01, // 1.500000
  9.92938038437790604362476187816355377435684204101562e-01, // 1.600000
  9.95805358458610623273443707148544490337371826171875e-01, // 1.700000
  9.97641306616706802223859540390549227595329284667969e-01, // 1.800000
  9.98751602365355761747878204914741218090057373046875e-01, // 1.900000
  9.99382021010668863958414931403240188956260681152344e-01, // 2.000000
  9.99999737827261037104165097844088450074195861816406e-01, // 2.718282
  9.99999999910849313167204854835290461778640747070312e-01, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_1_1 = { //
  3.67879441171442334024277442949824035167694091796875e-01, // 0.000000
  3.67879441153048325485741543161566369235515594482422e-01, // 0.000010
  3.65982076505757758511094834830146282911300659179688e-01, // 0.100000
  3.64968469589419641785354997409740462899208068847656e-01, // 0.123457
  3.60089467289227027624320953691494651138782501220703e-01, // 0.200000
  3.53266230282285820241128249108442105352878570556641e-01, // 0.271828
  3.49987161158421655748895773285767063498497009277344e-01, // 0.300000
  3.48210357844328799448163636043318547308444976806641e-01, // 0.314159
  3.35603559643444959714742026335443370044231414794922e-01, // 0.400000
  3.17041921077942157047857563156867399811744689941406e-01, // 0.500000
  2.94605295353879415021225440796115435659885406494141e-01, // 0.600000
  2.68809398181777292613503504981053993105888366699219e-01, // 0.700000
  2.40378400508394596268857412724173627793788909912109e-01, // 0.800000
  2.10219488415532618219572214002255350351333618164062e-01, // 0.900000
  1.79374078734017200487116383555985521525144577026367e-01, // 1.000000
  1.48946808910974892725675999827217310667037963867188e-01, // 1.100000
  1.20017594905418772954774908612307626754045486450195e-01, // 1.200000
  9.35464974266043275408222257283341605216264724731445e-02, // 1.300000
  7.02847826336932546276159428089158609509468078613281e-02, // 1.400000
  5.07071136099807306951703367303707636892795562744141e-02, // 1.500000
  3.49781245974551888155978929262346355244517326354980e-02, // 1.600000
  2.29612471247189892098461427849542815238237380981445e-02, // 1.700000
  1.42692634455674535048919082669272029306739568710327e-02, // 1.800000
  8.34665480722261883539392357533870381303131580352783e-03, // 1.900000
  4.56628142012791525539139314560088678263127803802490e-03, // 2.000000
  3.97303443855662314872830703782469186080561485141516e-06, // 2.718282
  2.06300953864877018550080075740774804282651189168973e-09, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_2_1 = { //
  2.64241117693903238006214451161213219165802001953125e-01, // 0.000000
  2.64244796469920995019009524185094051063060760498047e-01, // 0.000010
  3.02863646341333336842183143744478002190589904785156e-01, // 0.100000
  3.12450531160849975798043942631920799612998962402344e-01, // 0.123457
  3.45094211981614884532376663628383539617061614990234e-01, // 0.200000
  3.77550140485982788085550510004395619034767150878906e-01, // 0.271828
  3.90735972850750901130822967388667166233062744140625e-01, // 0.300000
  3.97455859735161454171503692123224027454853057861328e-01, // 0.314159
  4.39434646806636519666966478325775824487209320068359e-01, // 0.400000
  4.90662433374092876725569567497586831450462341308594e-01, // 0.500000
  5.43711890500994221575581377692287787795066833496094e-01, // 0.600000
  5.97703805160138879060127692355308681726455688476562e-01, // 0.700000
  6.51612621795013780001681880094110965728759765625000e-01, // 0.800000
  7.04311645708521449904537803377024829387664794921875e-01, // 0.900000
  7.54637885420670229130735151557018980383872985839844e-01, // 1.000000
  8.01473105393458062906120176194235682487487792968750e-01, // 1.100000
  8.43833800181445714549965941841946914792060852050781e-01, // 1.200000
  8.80959107897671511722137438482604920864105224609375e-01, // 1.300000
  9.12383203357542194034124349855119362473487854003906e-01, // 1.400000
  9.37978600009559682071369479672284796833992004394531e-01, // 1.500000
  9.57959913840335408607984390982892364263534545898438e-01, // 1.600000
  9.72844111333891592430234140920219942927360534667969e-01, // 1.700000
  9.83372043171139353923138060054043307900428771972656e-01, // 1.800000
  9.90404947558133130769419949501752853393554687500000e-01, // 1.900000
  9.94815739590541037173920813074801117181777954101562e-01, // 2.000000
  9.99995764792822483535417177336057648062705993652344e-01, // 2.718282
  9.99999997847839772191491647390648722648620605468750e-01, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_2_1 = { //
  3.67879441208230295590198011268512345850467681884766e-01, // 0.000000
  3.67883119965853877531003490730654448270797729492188e-01, // 0.000010
  4.04472747491100181882472952565876767039299011230469e-01, // 0.100000
  4.12925696504904959915904782974394038319587707519531e-01, // 0.123457
  4.39814268531488139490903677142341621220111846923828e-01, // 0.200000
  4.63612998361142059078332522403798066079616546630859e-01, // 0.271828
  4.72433252028217454121516993836848996579647064208984e-01, // 0.300000
  4.76737506736729155232268340114387683570384979248047e-01, // 0.314159
  5.00661678892416417419042318215360864996910095214844e-01, // 0.400000
  5.22713758984834520049389539053663611412048339843750e-01, // 0.500000
  5.36805847358902354926613043062388896942138671875000e-01, // 0.600000
  5.41315653382063444176708344457438215613365173339844e-01, // 0.700000
  5.34971968656986818224652324715862050652503967285156e-01, // 0.800000
  5.17056507732666426058187880698824301362037658691406e-01, // 0.900000
  4.87589298719261043935091493040090426802635192871094e-01, // 1.000000
  4.47460942705592668033887093770317733287811279296875e-01, // 1.100000
  3.98472447871620394366232176253106445074081420898438e-01, // 1.200000
  3.43249851274891548680301411877735517919063568115234e-01, // 1.300000
  2.85018848205838060128058941700146533548831939697266e-01, // 1.400000
  2.27253516854241194300456641030905302613973617553711e-01, // 1.500000
  1.73247785275727900211606424818455707281827926635742e-01, // 1.600000
  1.25688658809159137241806547535816207528114318847656e-01, // 1.700000
  8.63240134225174982063322204339783638715744018554688e-02, // 1.800000
  5.58048529872332277346202999979141168296337127685547e-02, // 1.900000
  3.37405095768298773917237554087478201836347579956055e-02, // 2.000000
  6.02084057763153639316298926242865263702697120606899e-05, // 2.718282
  4.77394696323629441641945875696856349534868968476076e-08, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_4_1 = { //
  1.89881568822851329314538304515735944733023643493652e-02, // 0.000000
  1.89887700177528255529590950345664168708026409149170e-02, // 0.000010
  2.61253529822300795126821526537241879850625991821289e-02, // 0.100000
  2.81235909655702942533395116697647608816623687744141e-02, // 0.123457
  3.56553509387778355677056651984457857906818389892578e-02, // 0.200000
  4.43389999778885657288896027239388786256313323974609e-02, // 0.271828
  4.82329824629648754030775137380260275676846504211426e-02, // 0.300000
  5.03029355298684754949078978825127705931663513183594e-02, // 0.314159
  6.46205644047200128410324282413057517260313034057617e-02, // 0.400000
  8.56706717273561235703738248048466630280017852783203e-02, // 0.500000
  1.12288295716173991412034638415207155048847198486328e-01, // 0.600000
  1.45366668036726959245541479504026938229799270629883e-01, // 0.700000
  1.85692968826134785498283008564612828195095062255859e-01, // 0.800000
  2.33824425998319124220259368485130835324525833129883e-01, // 0.900000
  2.89942380984430481127844814182026311755180358886719e-01, // 1.000000
  3.53701473854131198670813773787813261151313781738281e-01, // 1.100000
  4.24101723341831882141406140362960286438465118408203e-01, // 1.200000
  4.99419926352932252999750062372186221182346343994141e-01, // 1.300000
  5.77239041955553089380259734753053635358810424804688e-01, // 1.400000
  6.54605241135515658612575862207449972629547119140625e-01, // 1.500000
  7.28319038214917613416332642373163253068923950195312e-01, // 1.600000
  7.95330930919631029496486007701605558395385742187500e-01, // 1.700000
  8.53171728306633569971495489880908280611038208007812e-01, // 1.800000
  9.00318294991257483950164441921515390276908874511719e-01, // 1.900000
  9.36393731790508887513624358689412474632263183593750e-01, // 2.000000
  9.99813591594888362301674078480573371052742004394531e-01, // 2.718282
  9.99999789857372700652149433153681457042694091796875e-01, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_4_1 = { //
  6.13132402136343651610772553794959094375371932983398e-02, // 0.000000
  6.13150796169717390848852289764181477949023246765137e-02, // 0.000010
  8.23373548977086172628858662392303813248872756958008e-02, // 0.100000
  8.80955125640966868472148121327336411923170089721680e-02, // 0.123457
  1.09354298028383978280686505968333221971988677978516e-01, // 0.200000
  1.33079546765686368425818386640457902103662490844727e-01, // 0.271828
  1.43471585075040430901083254866534844040870666503906e-01, // 0.300000
  1.48937253613819708952803466672776266932487487792969e-01, // 0.314159
  1.85707176283804342720173963243723846971988677978516e-01, // 0.400000
  2.36813885422332809360668193221499677747488021850586e-01, // 0.500000
  2.97043029673370651000396946983528323471546173095703e-01, // 0.600000
  3.65857203274574493967463695298647508025169372558594e-01, // 0.700000
  4.41622251150090516791379968708497472107410430908203e-01, // 0.800000
  5.21334931827189818065448889683466404676437377929688e-01, // 0.900000
  6.00470780245812463249421853106468915939331054687500e-01, // 1.000000
  6.73056841397915439628718559106346219778060913085938e-01, // 1.100000
  7.32072012619148004830549325561150908470153808593750e-01, // 1.200000
  7.70237679686405218859590604552067816257476806640625e-01, // 1.300000
  7.81172380308322367170603683916851878166198730468750e-01, // 1.400000
  7.60751483950018791979630350397201254963874816894531e-01, // 1.500000
  7.08367753976518632619274740136461332440376281738281e-01, // 1.600000
  6.27691257896798693316497974592493847012519836425781e-01, // 1.700000
  5.26551080226083545454685008735395967960357666015625e-01, // 1.800000
  4.15757171500640287931105376628693193197250366210938e-01, // 1.900000
  3.07028234011749667775603711561416275799274444580078e-01, // 2.000000
  2.30449342972448420127640211774178169434890151023865e-03, // 2.718282
  4.26068127121804497963591940035144034482073038816452e-06, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_4_10 = { //
  1.89881569374670579330999231615351163782179355621338e-02, // 0.000000
  1.89942891199536868784836229906431981362402439117432e-02, // 0.000010
  2.89942380984430481127844814182026311755180358886719e-01, // 0.100000
  4.49689791586118492450196981735643930733203887939453e-01, // 0.123457
  9.36393731790508887513624358689412474632263183593750e-01, // 0.200000
  9.99813591594888362301674078480573371052742004394531e-01, // 0.271828
  9.99997023008917240716186825011391192674636840820312e-01, // 0.300000
  9.99999789857372700652149433153681457042694091796875e-01, // 0.314159
  1.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_4_10 = { //
  6.13132403791800895120900349866133183240890502929688e-01, // 0.000000
  6.13316366200022833332639038417255505919456481933594e-01, // 0.000010
  6.00470780245812463249421853106468915939331054687500e+00, // 0.100000
  7.47978163723896560810544542619027197360992431640625e+00, // 0.123457
  3.07028234011749656673373465309850871562957763671875e+00, // 0.200000
  2.30449342972449608413221255887037841603159904479980e-02, // 0.271828
  5.13268581343153621615593706906111037824302911758423e-04, // 0.300000
  4.26068127121804497963591940035144034482073038816452e-05, // 0.314159
  2.87663777096353381165139848770654588739438492245738e-17, // 0.400000
  2.83610527480158774910577794815980995977618360070194e-56, // 0.500000
  2.74168439726173051715348577927730977333274164887227e-165, // 0.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_01_10 = { //
  9.75872656312341435480561813164968043565750122070312e-01, // 0.000000
  9.75876523016603880655850389302941039204597473144531e-01, // 0.000010
  9.97771302397556292262947863491717725992202758789062e-01, // 0.100000
  9.99085373345744098827481138869188725948333740234375e-01, // 0.123457
  9.99990322880914939140950536966556683182716369628906e-01, // 0.200000
  9.99999997740172674731695678929099813103675842285156e-01, // 0.271828
  9.99999999987182364158400105225155130028724670410156e-01, // 0.300000
  9.99999999999465538635945449641440063714981079101562e-01, // 0.314159
  1.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_01_10 = { //
  3.86691694055001200513999037866597063839435577392578e-01, // 0.000000
  3.86656891783232925519087075372226536273956298828125e-01, // 0.000010
  7.66573807128762413354294835698965471237897872924805e-02, // 0.100000
  3.82519444836298613821234937404369702562689781188965e-02, // 0.123457
  7.93399517782126173157108972588957840343937277793884e-04, // 0.200000
  3.61659882683325373483495179458002688477336050709710e-07, // 0.271828
  2.68478689210771182002679843229143302751893429558550e-09, // 0.300000
  1.28298578206074916753204354692176596824948475727979e-10, // 0.314159
  3.04580319059060921083886090465841494937109628893572e-24, // 0.400000
  6.07841750487491422247162425697089017615956979567134e-65, // 0.500000
  1.18942526811122497186251097706497282965193428534428e-175, // 0.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_01_20 = { //
  9.75872656351010503428256015467923134565353393554688e-01, // 0.000000
  9.75880389411505455576900658343220129609107971191406e-01, // 0.000010
  9.99990322880914939140950536966556683182716369628906e-01, // 0.100000
  9.99999921146446313358069346577394753694534301757812e-01, // 0.123457
  1.00000000000000000000000000000000000000000000000000e+00, // 0.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.271828
  1.00000000000000000000000000000000000000000000000000e+00, // 0.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.314159
  1.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_01_20 = { //
  7.73383387413957290590360571513883769512176513671875e-01, // 0.000000
  7.73244176858206899716208226891467347741127014160156e-01, // 0.000010
  1.58679903556425234631421794517791568068787455558777e-03, // 0.100000
  1.99500277683705806545944039243067891220562160015106e-05, // 0.123457
  6.09160638118121842167772180931682989874219257787145e-24, // 0.200000
  6.64271790906281664176004049075875506156745355852006e-100, // 0.271828
  2.37885053622244994372502195412994565930386857068856e-175, // 0.300000
  1.08266349311588655483576215872042725531821155344122e-232, // 0.314159
  0.00000000000000000000000000000000000000000000000000e+00, // 0.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_01_4 = { //
  9.75872656289139994711945291783194988965988159179688e-01, // 0.000000
  9.75874203012607965845859325781930238008499145507812e-01, // 0.000010
  9.88521989554807967159888448804849758744239807128906e-01, // 0.100000
  9.90682106581839194703320572443772107362747192382812e-01, // 0.123457
  9.95795137017725928707534421846503391861915588378906e-01, // 0.200000
  9.98367638432702042550204168946947902441024780273438e-01, // 0.271828
  9.98945317922235953567167143773986026644706726074219e-01, // 0.300000
  9.99166739486790800306437176914187148213386535644531e-01, // 0.314159
  9.99848025621776881344260345940710976719856262207031e-01, // 0.400000
  9.99990322880914939140950536966556683182716369628906e-01, // 0.500000
  9.99999816093564919405878299585310742259025573730469e-01, // 0.600000
  9.99999999419964535896099278033943846821784973144531e-01, // 0.700000
  9.99999999999873656619797657185699790716171264648438e-01, // 0.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 0.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.100000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.200000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.300000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.400000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.500000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_01_4 = { //
  1.54676677705525900119454263403895311057567596435547e-01, // 0.000000
  1.54671109377300830534096576229785569012165069580078e-01, // 0.000010
  9.84464052270282996559558341687079519033432006835938e-02, // 0.100000
  8.58108052000031706896265859541017562150955200195312e-02, // 0.123457
  4.91952001039043101959791215449513401836156845092773e-02, // 0.200000
  2.41377289439051283259640712230975623242557048797607e-02, // 0.271828
  1.71366606385362704734198757705598836764693260192871e-02, // 0.300000
  1.42024583125499245794820524224633118137717247009277e-02, // 0.314159
  3.48443031793151504829642028937541908817365765571594e-03, // 0.400000
  3.17359807112850480104865313890627476212102919816971e-04, // 0.500000
  8.72258716114687767772921389575202510968665592372417e-06, // 0.600000
  4.01330737127810106150866157823098312462661851895973e-08, // 0.700000
  1.28336756744997760816790662079631580184263528465749e-11, // 0.800000
  7.68518036611483919318729926999253387631177034870593e-17, // 0.900000
  1.21832127623624368433554436186336597974843851557429e-24, // 1.000000
  2.76150657747027996328471734486001464284084376015250e-36, // 1.100000
  1.15047410120420279456129534473030897392716993393999e-53, // 1.200000
  1.33050980492765102664431323936746771679614454246348e-79, // 1.300000
  2.64379466050064674479079986745942626514867284146420e-118, // 1.400000
  4.75770107244327689646329016597701524441576128422297e-176, // 1.500000
  3.33955712784524322177202771066577131845898338987944e-262, // 1.600000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  0.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  0.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  0.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_CDF_01_1 = { //
  9.75872656277539052283032106061000376939773559570312e-01, // 0.000000
  9.75873042963626202705995638098102062940597534179688e-01, // 0.000010
  9.79564498296314867253897773480275645852088928222656e-01, // 0.100000
  9.80379475959243795735176263406174257397651672363281e-01, // 0.123457
  9.82903290234357296384359869989566504955291748046875e-01, // 0.200000
  9.85082822462057028367610200803028419613838195800781e-01, // 0.271828
  9.85887936645999274354323915758868679404258728027344e-01, // 0.300000
  9.86282063361266780887603999872226268053054809570312e-01, // 0.314159
  9.88521989554807967159888448804849758744239807128906e-01, // 0.400000
  9.90813910099314409940518544317455962300300598144531e-01, // 0.500000
  9.92777145076669365053589899616781622171401977539062e-01, // 0.600000
  9.94429979424373611252008231531362980604171752929688e-01, // 0.700000
  9.95795137017725928707534421846503391861915588378906e-01, // 0.800000
  9.96899120167219043864292871148791164159774780273438e-01, // 0.900000
  9.97771302397556292262947863491717725992202758789062e-01, // 1.000000
  9.98442817593759524008589778532041236758232116699219e-01, // 1.100000
  9.98945317922235953567167143773986026644706726074219e-01, // 1.200000
  9.99309698140446789338398048130329698324203491210938e-01, // 1.300000
  9.99564899282052388151953437045449391007423400878906e-01, // 1.400000
  9.99736904974793616496242520952364429831504821777344e-01, // 1.500000
  9.99848025621776881344260345940710976719856262207031e-01, // 1.600000
  9.99916529849280033559466573933605104684829711914062e-01, // 1.700000
  9.99956634133785438045549653907073661684989929199219e-01, // 1.800000
  9.99978809766067122666299837874248623847961425781250e-01, // 1.900000
  9.99990322880914939140950536966556683182716369628906e-01, // 2.000000
  9.99999997740172674731695678929099813103675842285156e-01, // 2.718282
  9.99999999999465538635945449641440063714981079101562e-01, // 3.141593
  };

  public static final double[] SCIPY_LOGGAMMA_PDF_01_1 = { //
  3.86691694368221511313166161016852129250764846801758e-02, // 0.000000
  3.86688214174100569620051714991859626024961471557617e-02, // 0.000010
  3.51586863187947004649736015835514990612864494323730e-02, // 0.100000
  3.43288903336685033429453994813229655846953392028809e-02, // 0.123457
  3.16152585351597847918014849710743874311447143554688e-02, // 0.200000
  2.90745711878013547713184294707389199174940586090088e-02, // 0.271828
  2.80835450574022579828259438272652914747595787048340e-02, // 0.300000
  2.75871692713388766415860686720407102257013320922852e-02, // 0.314159
  2.46116013067570749139889585421769879758358001708984e-02, // 0.400000
  2.12492448134385600311269115536561002954840660095215e-02, // 0.500000
  1.80459959087036214686605717361089773476123809814453e-02, // 0.600000
  1.50486745835341825111575175810685323085635900497437e-02, // 0.700000
  1.22988000259760775489947803862378350459039211273193e-02, // 0.800000
  9.83000572039229893184231201530565158464014530181885e-03, // 0.900000
  7.66573807128762517437703394307391135953366756439209e-03, // 1.000000
  5.81753483010033056038734500248210679274052381515503e-03, // 1.100000
  4.28416515963406761835496894263997091911733150482178e-03, // 1.200000
  3.05184388261519690468959176143926015356555581092834e-03, // 1.300000
  2.09560576678758086338616450916561007034033536911011e-03, // 1.400000
  1.38175379315578074172765621341341102379374206066132e-03, // 1.500000
  8.71107579482878762074105072343854772043414413928986e-04, // 1.600000
  5.22617853061128857447559248328161629615351557731628e-04, // 1.700000
  2.96827286233691963433789506865423390991054475307465e-04, // 1.800000
  1.58682200637844659282110759690453960502054542303085e-04, // 1.900000
  7.93399517782126200262163284726568690530257299542427e-05, // 2.000000
  3.61659882683322792679984014011657089682216792425606e-08, // 2.718282
  1.28298578206074919984378622477440951791388679126271e-11, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_1_1 = { //
  -9.21029036989272320568034047028049826622009277343750e+00, // 0.000100
  -6.90725507052371678895497097983025014400482177734375e+00, // 0.001000
  -4.60014922677657978056231513619422912597656250000000e+00, // 0.010000
  -2.25036732731244493166400388872716575860977172851562e+00, // 0.100000
  -1.24589932370723799337497439410071820020675659179688e+00, // 0.250000
  -3.66512920581664347619010868584155105054378509521484e-01, // 0.500000
  3.26634259978281105141206808184506371617317199707031e-01, // 0.750000
  8.34032445247955944722662025014869868755340576171875e-01, // 0.900000
  1.52717962580790089788251862046308815479278564453125e+00, // 0.990000
  1.93264473391606528274166976189007982611656188964844e+00, // 0.999000
  2.22032680636785828554025101766455918550491333007812e+00, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_2_1 = { //
  -4.25386298913733185145247261971235275268554687500000e+00, // 0.000100
  -3.09219873066056738508677881327457726001739501953125e+00, // 0.001000
  -1.90680176742938400913374152878532186150550842285156e+00, // 0.010000
  -6.31465971924031865825099885114468634128570556640625e-01, // 0.100000
  -3.94908359938028266644671759877383010461926460266113e-02, // 0.250000
  5.17809374519952236859410277247661724686622619628906e-01, // 0.500000
  9.90520093104668930550360528286546468734741210937500e-01, // 0.750000
  1.35833721927612582902611393365077674388885498046875e+00, // 0.900000
  1.89286375015490904161197249777615070343017578125000e+00, // 0.990000
  2.22282880424761364324126589053776115179061889648438e+00, // 0.999000
  2.46439532533742688968914080760441720485687255859375e+00, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_4_1 = { //
  -1.46189374258889248636705815442837774753570556640625e+00, // 0.000100
  -8.47342229571847793678784910298418253660202026367188e-01, // 0.001000
  -1.94496953420364770970252266124589368700981140136719e-01, // 0.010000
  5.56622491246540618270444156223675236105918884277344e-01, // 0.100000
  9.30319945397308112333689678052905946969985961914062e-01, // 0.250000
  1.30075301642610718921844181750202551484107971191406e+00, // 0.500000
  1.63108735980254726527505226840730756521224975585938e+00, // 0.750000
  1.89923520646495491703831248742062598466873168945312e+00, // 0.900000
  2.30708669703685576024554393370635807514190673828125e+00, // 0.990000
  2.56972568487266350700792827410623431205749511718750e+00, // 0.999000
  2.76718753710466591755334775371011346578598022460938e+00, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_4_10 = { //
  -1.46189374258889254187820938568620476871728897094727e-01, // 0.000100
  -8.47342229571847876945511757185158785432577133178711e-02, // 0.001000
  -1.94496953420364784848040073939046123996376991271973e-02, // 0.010000
  5.56622491246540618270444156223675236105918884277344e-02, // 0.100000
  9.30319945397308223355992140568559989333152770996094e-02, // 0.250000
  1.30075301642610718921844181750202551484107971191406e-01, // 0.500000
  1.63108735980254743180850596218078862875699996948242e-01, // 0.750000
  1.89923520646495508357176618119410704821348190307617e-01, // 0.900000
  2.30708669703685587126784639622201211750507354736328e-01, // 0.990000
  2.56972568487266350700792827410623431205749511718750e-01, // 0.999000
  2.76718753710466613959795267874142155051231384277344e-01, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_01_10 = { //
  Double.NaN, // 0.000100
  Double.NaN, // 0.001000
  Double.NaN, // 0.010000
  -2.35245753424830494893171817238908261060714721679688e+00, // 0.100000
  -1.43616674972779789776211600837996229529380798339844e+00, // 0.250000
  -7.42965684101831946861693722894415259361267089843750e-01, // 0.500000
  -3.34369221586346410113321780954720452427864074707031e-01, // 0.750000
  -1.32367810983911204925078664018656127154827117919922e-01, // 0.900000
  4.62776210468462748104379045344103360548615455627441e-02, // 0.990000
  1.21303472433787085105194591960753314197063446044922e-01, // 0.999000
  1.67076694072213816077976389351533725857734680175781e-01, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_01_20 = { //
  Double.NaN, // 0.000100
  Double.NaN, // 0.001000
  Double.NaN, // 0.010000
  -1.17622876712415247446585908619454130530357360839844e+00, // 0.100000
  -7.18083374863898948881058004189981147646903991699219e-01, // 0.250000
  -3.71482842050915973430846861447207629680633544921875e-01, // 0.500000
  -1.67184610793173205056660890477360226213932037353516e-01, // 0.750000
  -6.61839054919556024625393320093280635774135589599609e-02, // 0.900000
  2.31388105234231374052189522672051680274307727813721e-02, // 0.990000
  6.06517362168935425525972959803766570985317230224609e-02, // 0.999000
  8.35383470361069080389881946757668629288673400878906e-02, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_01_4 = { //
  Double.NaN, // 0.000100
  Double.NaN, // 0.001000
  Double.NaN, // 0.010000
  -5.88114383562076259437390035600401461124420166015625e+00, // 0.100000
  -3.59041687431949441133838263340294361114501953125000e+00, // 0.250000
  -1.85741421025457964510962938220473006367683410644531e+00, // 0.500000
  -8.35923053965865969772153221128974109888076782226562e-01, // 0.750000
  -3.30919527459777984557121044417726807296276092529297e-01, // 0.900000
  1.15694052617115683556647809382411651313304901123047e-01, // 0.990000
  3.03258681084467685007410864272969774901866912841797e-01, // 0.999000
  4.17691735180534484683789742121007293462753295898438e-01, // 0.999900
  };

  public static final double[] SCIPY_LOGGAMMA_QUANT_01_1 = { //
  Double.NaN, // 0.000100
  Double.NaN, // 0.001000
  Double.NaN, // 0.010000
  -2.35245753424830503774956014240160584449768066406250e+01, // 0.100000
  -1.43616674972779776453535305336117744445800781250000e+01, // 0.250000
  -7.42965684101831858043851752881892025470733642578125e+00, // 0.500000
  -3.34369221586346387908861288451589643955230712890625e+00, // 0.750000
  -1.32367810983911193822848417767090722918510437011719e+00, // 0.900000
  4.62776210468462734226591237529646605253219604492188e-01, // 0.990000
  1.21303472433787074002964345709187909960746765136719e+00, // 0.999000
  1.67076694072213793873515896848402917385101318359375e+00, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new LogGammaAlternateDistribution(1., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_1_1, 1e-10);
    checkPDF(new LogGammaAlternateDistribution(2., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_2_1, 1e-12);
    checkPDF(new LogGammaAlternateDistribution(4., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_4_1, 1e-12);
    checkPDF(new LogGammaAlternateDistribution(4., 10, 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_4_10, 1e-10);
    checkPDF(new LogGammaAlternateDistribution(.1, 10, 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_01_10, 1e-11);
    checkPDF(new LogGammaAlternateDistribution(.1, 20, 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_01_20, 1e-14);
    checkPDF(new LogGammaAlternateDistribution(.1, 4., 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_01_4, 1e-12);
    checkPDF(new LogGammaAlternateDistribution(.1, 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_PDF_01_1, 1e-12);
  }

  @Test
  public void testCDF() {
    checkCDF(new LogGammaAlternateDistribution(1., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_1_1, 1e-13);
    checkCDF(new LogGammaAlternateDistribution(2., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_2_1, 1e-12);
    checkCDF(new LogGammaAlternateDistribution(4., 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_4_1, 1e-12);
    checkCDF(new LogGammaAlternateDistribution(4., 10, 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_4_10, 1e-14);
    checkCDF(new LogGammaAlternateDistribution(.1, 10, 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_01_10, 1e-15);
    checkCDF(new LogGammaAlternateDistribution(.1, 20, 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_01_20, 1e-15);
    checkCDF(new LogGammaAlternateDistribution(.1, 4., 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_01_4, 1e-14);
    checkCDF(new LogGammaAlternateDistribution(.1, 1., 0.), P_CDFPDF, SCIPY_LOGGAMMA_CDF_01_1, 1e-14);
  }

  @Test
  public void testProbit() {
    checkQuantile(new LogGammaAlternateDistribution(1., 1., 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_1_1, 1e-14);
    checkQuantile(new LogGammaAlternateDistribution(2., 1., 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_2_1, 1e-13);
    checkQuantile(new LogGammaAlternateDistribution(4., 1., 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_4_1, 1e-13);
    checkQuantile(new LogGammaAlternateDistribution(4., 10, 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_4_10, 1e-13);
    checkQuantile(new LogGammaAlternateDistribution(.1, 10, 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_01_10, 1e-13);
    checkQuantile(new LogGammaAlternateDistribution(.1, 20, 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_01_20, 1e-14);
    checkQuantile(new LogGammaAlternateDistribution(.1, 4., 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_01_4, 1e-13);
    checkQuantile(new LogGammaAlternateDistribution(.1, 1., 0.), P_QUANT, SCIPY_LOGGAMMA_QUANT_01_1, 1e-13);
  }
}
