%%
%% %CopyrightBegin%
%%
%% SPDX-License-Identifier: Apache-2.0
%% 
%% Copyright Ericsson AB 2006-2025. All Rights Reserved.
%% 
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%% 
%% %CopyrightEnd%
%%
%%
%%% Purpose : Test suite for the xmerl application

%% Do NOT edit this file. It is generated by the generate_xsd_suite module
%% For more info read the comments in the header of that file.

-module('xmerl_xsd_Sun2002-01-16_SUITE').

-compile(export_all).

-include_lib("common_test/include/ct.hrl").
-include_lib("xmerl/include/xmerl.hrl").
-include_lib("xmerl/include/xmerl_xsd.hrl").


all() -> 
    ['Sun-idc001.nogen', 'Sun-idc002.e', 'Sun-idc002b.e',
     'Sun-idc003.e', 'Sun-idc004.nogen', 'Sun-idc004a.e',
     'Sun-idc005.nogen', 'Sun-idc006.nogen', 'Sun-xsd001',
     'Sun-xsd002', 'Sun-xsd003-1.e', 'Sun-xsd003-2.e',
     'Sun-xsd003a', 'Sun-xsd003b', 'Sun-xsd004',
     'Sun-xsd005', 'Sun-xsd006', 'Sun-xsd008', 'Sun-xsd011',
     'Sun-xsd012', 'Sun-xsd013.e', 'Sun-xsd014.e',
     'Sun-xsd015.e', 'Sun-xsd016.e', 'Sun-xsd017.e',
     'Sun-xsd018.e', 'Sun-xsd019.e', 'Sun-xsd020.e',
     'Sun-xsd020-2.e', 'Sun-xsd020-3.e', 'Sun-xsd020-4.e',
     'Sun-xsd021', 'Sun-xsd022', 'Sun-xsd023.e',
     'Sun-xsiType1', 'Sun-xsiType-block-1',
     'Sun-xsiType-block-2', 'Sun-xsiType-block-3',
     'Sun-xsiType-block-4', 'Sun-type-and-subst-1'].

suite() ->
    [{timetrap,{minutes,3}}].

%% initialization before the test suite
init_per_suite(Config) ->
    ct:timetrap({minutes,10}),
    xmerl_xsd_lib:unpack(Config,sun),
    {ok,LogFile} = xmerl_xsd_lib:create_error_log_file(Config,sun),
    [{suite,sun},{xmerl_error_log,LogFile}|Config].

end_per_suite(Config) ->
    xmerl_xsd_lib:rmdir(Config,sun),
    xmerl_xsd_lib:close_error_log_file(Config),
    ok.

%% initialization before each testcase
init_per_testcase(TestCase,Config) ->
    [{testcase,TestCase}|Config].

%% clean up after each testcase
end_per_testcase(_Func,_Config) ->
    ok.

%% ID Constraints. Very naive test of identity constraint
'Sun-idc001.nogen'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc001.nogen.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc001.nogen.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc001.nogen.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc001.nogen.v01.xml','./suntest/SunTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList3).

%% ID Constraints. Reference to an undeclared key
'Sun-idc002.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc002.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% ID Constraints. Reference to an undeclared key in an undeclared namespace
'Sun-idc002b.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc002b.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% ID Constraints. Reference to non-key constraint.
'Sun-idc003.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc003.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% ID Constraints.
'Sun-idc004.nogen'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc004.nogen.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc004.nogen.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc004.nogen.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc004.nogen.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc004.nogen.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc004.nogen.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% ID Constraints. Key/keyref field size mismatch.
'Sun-idc004a.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc004a.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% ID Constraints. Very naive test of identity constraint.
'Sun-idc005.nogen'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc005.nogen.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc005.nogen.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc005.nogen.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc005.nogen.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList3).

%% ID Constraints. XPath engine test: ".//a/*/b" and use of "." for both selector and field.
'Sun-idc006.nogen'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/idc006.nogen.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc006.nogen.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc006.nogen.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/idc006.nogen.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList3).

%% - use of elementFormDefault="unqualified" - unusual minOccurs/maxOccurs (3 and 7 respectively) - complexType with simpleContent, and restriction. - simpleType within restriction.
'Sun-xsd001'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd001.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n05.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n06.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.n07.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList8 = [ITRes7|ITResList7],
  ITRes8 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList9 = [ITRes8|ITResList8],
  ITRes9 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.v01.xml','./suntest/SunTestsAll',valid,S0),
  ITResList10 = [ITRes9|ITResList9],
  ITRes10 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.v02.xml','./suntest/SunTestsAll',valid,S0),
  ITResList11 = [ITRes10|ITResList10],
  ITRes11 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd001.v03.xml','./suntest/SunTestsAll',valid,S0),
  ITResList12 = [ITRes11|ITResList11],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList12).

%% - use of elementFormDefault="unqualified" - use of elementFormDefault and form attribute. - implicit use of "ur-type" as the content model of element.
'Sun-xsd002'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd002.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd002.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd002.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd002.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd002.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd002.v01.xml','./suntest/SunTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% Element redefinition. Unable to redefine element.
'Sun-xsd003-1.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd003-1.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Element redefinition. Unable to redefine element.
'Sun-xsd003-2.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd003-2.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Element redefinition. Test without redefinition.
'Sun-xsd003a'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd003a.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd003a.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList1).

%% Element redefinition. Test with redefinition with self-reference.
'Sun-xsd003b'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd003b.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd003b.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd003b.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd003b.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd003b.v01.xml','./suntest/SunTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList4).

%% Use of three different type of any element with different @namespace.
'Sun-xsd004'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd004.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n05.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n06.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n07.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList8 = [ITRes7|ITResList7],
  ITRes8 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n08.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList9 = [ITRes8|ITResList8],
  ITRes9 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n09.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList10 = [ITRes9|ITResList9],
  ITRes10 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n10.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList11 = [ITRes10|ITResList10],
  ITRes11 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n11.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList12 = [ITRes11|ITResList11],
  ITRes12 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.n12.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList13 = [ITRes12|ITResList12],
  ITRes13 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd004.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList14 = [ITRes13|ITResList13],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList14).

%% Complex type derivation.
'Sun-xsd005'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd005.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n05.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.n06.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd005.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList8 = [ITRes7|ITResList7],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList8).

%% minOccurs/maxOccurs. Various combinations.
'Sun-xsd006'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd006.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n05.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n06.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n07.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList8 = [ITRes7|ITResList7],
  ITRes8 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n08.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList9 = [ITRes8|ITResList8],
  ITRes9 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n09.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList10 = [ITRes9|ITResList9],
  ITRes10 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.n10.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList11 = [ITRes10|ITResList10],
  ITRes11 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd006.v00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList12 = [ITRes11|ITResList11],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList12).

%% Abstract element and element substitution group.
'Sun-xsd008'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd008.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd008.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd008.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd008.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd008.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList4).

%% Nillable.
'Sun-xsd011'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd011.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd011.v00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList6).

%% Mixed content model.
'Sun-xsd012'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd012.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd012.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd012.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList2).

%% Reference to undeclared element.
'Sun-xsd013.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd013.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared element.
'Sun-xsd014.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd014.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared type (it may be simple or complex).
'Sun-xsd015.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd015.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared type (it may be simple or complex).
'Sun-xsd016.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd016.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared complex type.
'Sun-xsd017.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd017.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared complex type.
'Sun-xsd018.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd018.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared simple type.
'Sun-xsd019.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd019.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared simple type.
'Sun-xsd020.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd020.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared attribute.
'Sun-xsd020-2.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd020-2.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared model group.
'Sun-xsd020-3.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd020-3.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Reference to undeclared attribute group.
'Sun-xsd020-4.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd020-4.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% anyOtherAttribute.
'Sun-xsd021'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd021.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n01.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n02.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n03.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n04.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n05.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n06.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n07.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList8 = [ITRes7|ITResList7],
  ITRes8 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n08.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList9 = [ITRes8|ITResList8],
  ITRes9 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n09.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList10 = [ITRes9|ITResList9],
  ITRes10 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n10.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList11 = [ITRes10|ITResList10],
  ITRes11 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.n11.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList12 = [ITRes11|ITResList11],
  ITRes12 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd021.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList13 = [ITRes12|ITResList12],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList13).

%% Simple type. Various forms of forward reference to the simple type.
'Sun-xsd022'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd022.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd022.n00.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsd022.v00.xml','./suntest/SunTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList2).

%% Simple type. Recursive definition.
'Sun-xsd023.e'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsd023.e.xsd','./suntest/SunTestsAll',invalid),
  STResList1 = [STRes0|STResList0],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,[]).

%% Simple type.
'Sun-xsiType1'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsiType1.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType1.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType1.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList2).

%% Test block attribute (1) - use block="extension" at the B type. This should exclude all types that uses extension.
'Sun-xsiType-block-1'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsiType-block-1.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-1.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-1.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-1.n2.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-1.n3.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-1.n4.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% Test block attribute (2) - use block="extension" as the blockDefault attribute. This should achieve the same result as the previous test case.
'Sun-xsiType-block-2'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsiType-block-2.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-2.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-2.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-2.n2.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-2.n3.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-2.n4.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% Test block attribute (3) - use block="extension" for the child2 element. child2 has no block constraint. - see if @block for element is working as expected.
'Sun-xsiType-block-3'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsiType-block-3.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-3.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-3.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-3.n2.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-3.n3.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-3.n4.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% Test block attribute (4) - use block="extension" for the child2 element. child2 has no block constraint. - use block="restriction" for the Dr type. - see if @block for element and @block for types interacts as expected.
'Sun-xsiType-block-4'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/xsiType-block-4.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-4.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-4.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-4.n2.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-4.n3.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/xsiType-block-4.n4.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],


  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList5).

%% No block attribute is specified. Just test that the substitution group and the type hierarchy is OK. The substitution group hierarchy mirrors the complex type hierarchy.
'Sun-type-and-subst-1'(Config) when is_list(Config) ->
  STResList0 = [],

  {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./suntest/SunTestsAll/type-and-subst-1.xsd','./suntest/SunTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ITRes0 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.v1.xml','./suntest/SunTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ITRes1 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.v2.xml','./suntest/SunTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ITRes2 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n1.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ITRes3 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n2.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ITRes4 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n3.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList5 = [ITRes4|ITResList4],
  ITRes5 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n4.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList6 = [ITRes5|ITResList5],
  ITRes6 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n5.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList7 = [ITRes6|ITResList6],
  ITRes7 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n6.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList8 = [ITRes7|ITResList7],
  ITRes8 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n7.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList9 = [ITRes8|ITResList8],
  ITRes9 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n8.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList10 = [ITRes9|ITResList9],
  ITRes10 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n9.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList11 = [ITRes10|ITResList10],
  ITRes11 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n10.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList12 = [ITRes11|ITResList11],
  ITRes12 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n11.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList13 = [ITRes12|ITResList12],
  ITRes13 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n12.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList14 = [ITRes13|ITResList13],
  ITRes14 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n13.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList15 = [ITRes14|ITResList14],
  ITRes15 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n14.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList16 = [ITRes15|ITResList15],
  ITRes16 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n15.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList17 = [ITRes16|ITResList16],
  ITRes17 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n16.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList18 = [ITRes17|ITResList17],
  ITRes18 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n17.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList19 = [ITRes18|ITResList18],
  ITRes19 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n18.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList20 = [ITRes19|ITResList19],
  ITRes20 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n19.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList21 = [ITRes20|ITResList20],
  ITRes21 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n20.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList22 = [ITRes21|ITResList21],
  ITRes22 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n21.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList23 = [ITRes22|ITResList22],
  ITRes23 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n22.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList24 = [ITRes23|ITResList23],
  ITRes24 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n23.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList25 = [ITRes24|ITResList24],
  ITRes25 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n24.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList26 = [ITRes25|ITResList25],
  ITRes26 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n25.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList27 = [ITRes26|ITResList26],
  ITRes27 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n26.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList28 = [ITRes27|ITResList27],
  ITRes28 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n27.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList29 = [ITRes28|ITResList28],
  ITRes29 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n28.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList30 = [ITRes29|ITResList29],
  ITRes30 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n29.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList31 = [ITRes30|ITResList30],
  ITRes31 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n30.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList32 = [ITRes31|ITResList31],
  ITRes32 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n31.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList33 = [ITRes32|ITResList32],
  ITRes33 = xmerl_xsd_lib:instance_test(Config,'./suntest/SunTestsAll/type-and-subst-1.n32.xml','./suntest/SunTestsAll',invalid,S0),
  ITResList34 = [ITRes33|ITResList33],

  xmerl_xsd_lib:compare_test_results(Config,STResList1,ITResList34).
