// Code generated by smithy-go-codegen DO NOT EDIT.

package appflow

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appflow/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCancelFlowExecutions struct {
}

func (*validateOpCancelFlowExecutions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelFlowExecutions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelFlowExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelFlowExecutionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateConnectorProfile struct {
}

func (*validateOpCreateConnectorProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateConnectorProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateConnectorProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateConnectorProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFlow struct {
}

func (*validateOpCreateFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConnectorProfile struct {
}

func (*validateOpDeleteConnectorProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConnectorProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConnectorProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConnectorProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFlow struct {
}

func (*validateOpDeleteFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeConnectorEntity struct {
}

func (*validateOpDescribeConnectorEntity) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeConnectorEntity) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeConnectorEntityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeConnectorEntityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeConnector struct {
}

func (*validateOpDescribeConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeFlowExecutionRecords struct {
}

func (*validateOpDescribeFlowExecutionRecords) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeFlowExecutionRecords) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeFlowExecutionRecordsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeFlowExecutionRecordsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeFlow struct {
}

func (*validateOpDescribeFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterConnector struct {
}

func (*validateOpRegisterConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartFlow struct {
}

func (*validateOpStartFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopFlow struct {
}

func (*validateOpStopFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUnregisterConnector struct {
}

func (*validateOpUnregisterConnector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUnregisterConnector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UnregisterConnectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUnregisterConnectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConnectorProfile struct {
}

func (*validateOpUpdateConnectorProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConnectorProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConnectorProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConnectorProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConnectorRegistration struct {
}

func (*validateOpUpdateConnectorRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConnectorRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConnectorRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConnectorRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFlow struct {
}

func (*validateOpUpdateFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCancelFlowExecutionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelFlowExecutions{}, middleware.After)
}

func addOpCreateConnectorProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateConnectorProfile{}, middleware.After)
}

func addOpCreateFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFlow{}, middleware.After)
}

func addOpDeleteConnectorProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConnectorProfile{}, middleware.After)
}

func addOpDeleteFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFlow{}, middleware.After)
}

func addOpDescribeConnectorEntityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeConnectorEntity{}, middleware.After)
}

func addOpDescribeConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeConnector{}, middleware.After)
}

func addOpDescribeFlowExecutionRecordsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeFlowExecutionRecords{}, middleware.After)
}

func addOpDescribeFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeFlow{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRegisterConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterConnector{}, middleware.After)
}

func addOpStartFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartFlow{}, middleware.After)
}

func addOpStopFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopFlow{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUnregisterConnectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUnregisterConnector{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateConnectorProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConnectorProfile{}, middleware.After)
}

func addOpUpdateConnectorRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConnectorRegistration{}, middleware.After)
}

func addOpUpdateFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFlow{}, middleware.After)
}

func validateAmplitudeConnectorProfileCredentials(v *types.AmplitudeConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmplitudeConnectorProfileCredentials"}
	if v.ApiKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiKey"))
	}
	if v.SecretKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAmplitudeSourceProperties(v *types.AmplitudeSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmplitudeSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApiKeyCredentials(v *types.ApiKeyCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApiKeyCredentials"}
	if v.ApiKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBasicAuthCredentials(v *types.BasicAuthCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BasicAuthCredentials"}
	if v.Username == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Username"))
	}
	if v.Password == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Password"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConnectorProfileConfig(v *types.ConnectorProfileConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectorProfileConfig"}
	if v.ConnectorProfileProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileProperties"))
	} else if v.ConnectorProfileProperties != nil {
		if err := validateConnectorProfileProperties(v.ConnectorProfileProperties); err != nil {
			invalidParams.AddNested("ConnectorProfileProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectorProfileCredentials != nil {
		if err := validateConnectorProfileCredentials(v.ConnectorProfileCredentials); err != nil {
			invalidParams.AddNested("ConnectorProfileCredentials", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConnectorProfileCredentials(v *types.ConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectorProfileCredentials"}
	if v.Amplitude != nil {
		if err := validateAmplitudeConnectorProfileCredentials(v.Amplitude); err != nil {
			invalidParams.AddNested("Amplitude", err.(smithy.InvalidParamsError))
		}
	}
	if v.Datadog != nil {
		if err := validateDatadogConnectorProfileCredentials(v.Datadog); err != nil {
			invalidParams.AddNested("Datadog", err.(smithy.InvalidParamsError))
		}
	}
	if v.Dynatrace != nil {
		if err := validateDynatraceConnectorProfileCredentials(v.Dynatrace); err != nil {
			invalidParams.AddNested("Dynatrace", err.(smithy.InvalidParamsError))
		}
	}
	if v.GoogleAnalytics != nil {
		if err := validateGoogleAnalyticsConnectorProfileCredentials(v.GoogleAnalytics); err != nil {
			invalidParams.AddNested("GoogleAnalytics", err.(smithy.InvalidParamsError))
		}
	}
	if v.InforNexus != nil {
		if err := validateInforNexusConnectorProfileCredentials(v.InforNexus); err != nil {
			invalidParams.AddNested("InforNexus", err.(smithy.InvalidParamsError))
		}
	}
	if v.Marketo != nil {
		if err := validateMarketoConnectorProfileCredentials(v.Marketo); err != nil {
			invalidParams.AddNested("Marketo", err.(smithy.InvalidParamsError))
		}
	}
	if v.Singular != nil {
		if err := validateSingularConnectorProfileCredentials(v.Singular); err != nil {
			invalidParams.AddNested("Singular", err.(smithy.InvalidParamsError))
		}
	}
	if v.Slack != nil {
		if err := validateSlackConnectorProfileCredentials(v.Slack); err != nil {
			invalidParams.AddNested("Slack", err.(smithy.InvalidParamsError))
		}
	}
	if v.Snowflake != nil {
		if err := validateSnowflakeConnectorProfileCredentials(v.Snowflake); err != nil {
			invalidParams.AddNested("Snowflake", err.(smithy.InvalidParamsError))
		}
	}
	if v.Trendmicro != nil {
		if err := validateTrendmicroConnectorProfileCredentials(v.Trendmicro); err != nil {
			invalidParams.AddNested("Trendmicro", err.(smithy.InvalidParamsError))
		}
	}
	if v.Veeva != nil {
		if err := validateVeevaConnectorProfileCredentials(v.Veeva); err != nil {
			invalidParams.AddNested("Veeva", err.(smithy.InvalidParamsError))
		}
	}
	if v.Zendesk != nil {
		if err := validateZendeskConnectorProfileCredentials(v.Zendesk); err != nil {
			invalidParams.AddNested("Zendesk", err.(smithy.InvalidParamsError))
		}
	}
	if v.SAPOData != nil {
		if err := validateSAPODataConnectorProfileCredentials(v.SAPOData); err != nil {
			invalidParams.AddNested("SAPOData", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomConnector != nil {
		if err := validateCustomConnectorProfileCredentials(v.CustomConnector); err != nil {
			invalidParams.AddNested("CustomConnector", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConnectorProfileProperties(v *types.ConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectorProfileProperties"}
	if v.Datadog != nil {
		if err := validateDatadogConnectorProfileProperties(v.Datadog); err != nil {
			invalidParams.AddNested("Datadog", err.(smithy.InvalidParamsError))
		}
	}
	if v.Dynatrace != nil {
		if err := validateDynatraceConnectorProfileProperties(v.Dynatrace); err != nil {
			invalidParams.AddNested("Dynatrace", err.(smithy.InvalidParamsError))
		}
	}
	if v.InforNexus != nil {
		if err := validateInforNexusConnectorProfileProperties(v.InforNexus); err != nil {
			invalidParams.AddNested("InforNexus", err.(smithy.InvalidParamsError))
		}
	}
	if v.Marketo != nil {
		if err := validateMarketoConnectorProfileProperties(v.Marketo); err != nil {
			invalidParams.AddNested("Marketo", err.(smithy.InvalidParamsError))
		}
	}
	if v.Redshift != nil {
		if err := validateRedshiftConnectorProfileProperties(v.Redshift); err != nil {
			invalidParams.AddNested("Redshift", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceNow != nil {
		if err := validateServiceNowConnectorProfileProperties(v.ServiceNow); err != nil {
			invalidParams.AddNested("ServiceNow", err.(smithy.InvalidParamsError))
		}
	}
	if v.Slack != nil {
		if err := validateSlackConnectorProfileProperties(v.Slack); err != nil {
			invalidParams.AddNested("Slack", err.(smithy.InvalidParamsError))
		}
	}
	if v.Snowflake != nil {
		if err := validateSnowflakeConnectorProfileProperties(v.Snowflake); err != nil {
			invalidParams.AddNested("Snowflake", err.(smithy.InvalidParamsError))
		}
	}
	if v.Veeva != nil {
		if err := validateVeevaConnectorProfileProperties(v.Veeva); err != nil {
			invalidParams.AddNested("Veeva", err.(smithy.InvalidParamsError))
		}
	}
	if v.Zendesk != nil {
		if err := validateZendeskConnectorProfileProperties(v.Zendesk); err != nil {
			invalidParams.AddNested("Zendesk", err.(smithy.InvalidParamsError))
		}
	}
	if v.SAPOData != nil {
		if err := validateSAPODataConnectorProfileProperties(v.SAPOData); err != nil {
			invalidParams.AddNested("SAPOData", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomConnector != nil {
		if err := validateCustomConnectorProfileProperties(v.CustomConnector); err != nil {
			invalidParams.AddNested("CustomConnector", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConnectorProvisioningConfig(v *types.ConnectorProvisioningConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectorProvisioningConfig"}
	if v.Lambda != nil {
		if err := validateLambdaConnectorProvisioningConfig(v.Lambda); err != nil {
			invalidParams.AddNested("Lambda", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomAuthCredentials(v *types.CustomAuthCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomAuthCredentials"}
	if v.CustomAuthenticationType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomAuthenticationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomConnectorDestinationProperties(v *types.CustomConnectorDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomConnectorDestinationProperties"}
	if v.EntityName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomConnectorProfileCredentials(v *types.CustomConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomConnectorProfileCredentials"}
	if len(v.AuthenticationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationType"))
	}
	if v.Basic != nil {
		if err := validateBasicAuthCredentials(v.Basic); err != nil {
			invalidParams.AddNested("Basic", err.(smithy.InvalidParamsError))
		}
	}
	if v.ApiKey != nil {
		if err := validateApiKeyCredentials(v.ApiKey); err != nil {
			invalidParams.AddNested("ApiKey", err.(smithy.InvalidParamsError))
		}
	}
	if v.Custom != nil {
		if err := validateCustomAuthCredentials(v.Custom); err != nil {
			invalidParams.AddNested("Custom", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomConnectorProfileProperties(v *types.CustomConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomConnectorProfileProperties"}
	if v.OAuth2Properties != nil {
		if err := validateOAuth2Properties(v.OAuth2Properties); err != nil {
			invalidParams.AddNested("OAuth2Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomConnectorSourceProperties(v *types.CustomConnectorSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomConnectorSourceProperties"}
	if v.EntityName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EntityName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomerProfilesDestinationProperties(v *types.CustomerProfilesDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomerProfilesDestinationProperties"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatadogConnectorProfileCredentials(v *types.DatadogConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatadogConnectorProfileCredentials"}
	if v.ApiKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiKey"))
	}
	if v.ApplicationKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatadogConnectorProfileProperties(v *types.DatadogConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatadogConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatadogSourceProperties(v *types.DatadogSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatadogSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationConnectorProperties(v *types.DestinationConnectorProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationConnectorProperties"}
	if v.Redshift != nil {
		if err := validateRedshiftDestinationProperties(v.Redshift); err != nil {
			invalidParams.AddNested("Redshift", err.(smithy.InvalidParamsError))
		}
	}
	if v.S3 != nil {
		if err := validateS3DestinationProperties(v.S3); err != nil {
			invalidParams.AddNested("S3", err.(smithy.InvalidParamsError))
		}
	}
	if v.Salesforce != nil {
		if err := validateSalesforceDestinationProperties(v.Salesforce); err != nil {
			invalidParams.AddNested("Salesforce", err.(smithy.InvalidParamsError))
		}
	}
	if v.Snowflake != nil {
		if err := validateSnowflakeDestinationProperties(v.Snowflake); err != nil {
			invalidParams.AddNested("Snowflake", err.(smithy.InvalidParamsError))
		}
	}
	if v.EventBridge != nil {
		if err := validateEventBridgeDestinationProperties(v.EventBridge); err != nil {
			invalidParams.AddNested("EventBridge", err.(smithy.InvalidParamsError))
		}
	}
	if v.Upsolver != nil {
		if err := validateUpsolverDestinationProperties(v.Upsolver); err != nil {
			invalidParams.AddNested("Upsolver", err.(smithy.InvalidParamsError))
		}
	}
	if v.Honeycode != nil {
		if err := validateHoneycodeDestinationProperties(v.Honeycode); err != nil {
			invalidParams.AddNested("Honeycode", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomerProfiles != nil {
		if err := validateCustomerProfilesDestinationProperties(v.CustomerProfiles); err != nil {
			invalidParams.AddNested("CustomerProfiles", err.(smithy.InvalidParamsError))
		}
	}
	if v.Zendesk != nil {
		if err := validateZendeskDestinationProperties(v.Zendesk); err != nil {
			invalidParams.AddNested("Zendesk", err.(smithy.InvalidParamsError))
		}
	}
	if v.Marketo != nil {
		if err := validateMarketoDestinationProperties(v.Marketo); err != nil {
			invalidParams.AddNested("Marketo", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomConnector != nil {
		if err := validateCustomConnectorDestinationProperties(v.CustomConnector); err != nil {
			invalidParams.AddNested("CustomConnector", err.(smithy.InvalidParamsError))
		}
	}
	if v.SAPOData != nil {
		if err := validateSAPODataDestinationProperties(v.SAPOData); err != nil {
			invalidParams.AddNested("SAPOData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationFlowConfig(v *types.DestinationFlowConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationFlowConfig"}
	if len(v.ConnectorType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorType"))
	}
	if v.DestinationConnectorProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationConnectorProperties"))
	} else if v.DestinationConnectorProperties != nil {
		if err := validateDestinationConnectorProperties(v.DestinationConnectorProperties); err != nil {
			invalidParams.AddNested("DestinationConnectorProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationFlowConfigList(v []types.DestinationFlowConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationFlowConfigList"}
	for i := range v {
		if err := validateDestinationFlowConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynatraceConnectorProfileCredentials(v *types.DynatraceConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynatraceConnectorProfileCredentials"}
	if v.ApiToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynatraceConnectorProfileProperties(v *types.DynatraceConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynatraceConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynatraceSourceProperties(v *types.DynatraceSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynatraceSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEventBridgeDestinationProperties(v *types.EventBridgeDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EventBridgeDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGlueDataCatalogConfig(v *types.GlueDataCatalogConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GlueDataCatalogConfig"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.DatabaseName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatabaseName"))
	}
	if v.TablePrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TablePrefix"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGoogleAnalyticsConnectorProfileCredentials(v *types.GoogleAnalyticsConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GoogleAnalyticsConnectorProfileCredentials"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGoogleAnalyticsSourceProperties(v *types.GoogleAnalyticsSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GoogleAnalyticsSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHoneycodeDestinationProperties(v *types.HoneycodeDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HoneycodeDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInforNexusConnectorProfileCredentials(v *types.InforNexusConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InforNexusConnectorProfileCredentials"}
	if v.AccessKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccessKeyId"))
	}
	if v.UserId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserId"))
	}
	if v.SecretAccessKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretAccessKey"))
	}
	if v.Datakey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Datakey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInforNexusConnectorProfileProperties(v *types.InforNexusConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InforNexusConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInforNexusSourceProperties(v *types.InforNexusSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InforNexusSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaConnectorProvisioningConfig(v *types.LambdaConnectorProvisioningConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaConnectorProvisioningConfig"}
	if v.LambdaArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LambdaArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMarketoConnectorProfileCredentials(v *types.MarketoConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MarketoConnectorProfileCredentials"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMarketoConnectorProfileProperties(v *types.MarketoConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MarketoConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMarketoDestinationProperties(v *types.MarketoDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MarketoDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMarketoSourceProperties(v *types.MarketoSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MarketoSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetadataCatalogConfig(v *types.MetadataCatalogConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetadataCatalogConfig"}
	if v.GlueDataCatalog != nil {
		if err := validateGlueDataCatalogConfig(v.GlueDataCatalog); err != nil {
			invalidParams.AddNested("GlueDataCatalog", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOAuth2Properties(v *types.OAuth2Properties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OAuth2Properties"}
	if v.TokenUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TokenUrl"))
	}
	if len(v.OAuth2GrantType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("OAuth2GrantType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOAuthCredentials(v *types.OAuthCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OAuthCredentials"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOAuthProperties(v *types.OAuthProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OAuthProperties"}
	if v.TokenUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TokenUrl"))
	}
	if v.AuthCodeUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthCodeUrl"))
	}
	if v.OAuthScopes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OAuthScopes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePardotSourceProperties(v *types.PardotSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PardotSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftConnectorProfileProperties(v *types.RedshiftConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftConnectorProfileProperties"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftDestinationProperties(v *types.RedshiftDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if v.IntermediateBucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IntermediateBucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3DestinationProperties(v *types.S3DestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3DestinationProperties"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3SourceProperties(v *types.S3SourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3SourceProperties"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSalesforceDestinationProperties(v *types.SalesforceDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SalesforceDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSalesforceSourceProperties(v *types.SalesforceSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SalesforceSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataConnectorProfileCredentials(v *types.SAPODataConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataConnectorProfileCredentials"}
	if v.BasicAuthCredentials != nil {
		if err := validateBasicAuthCredentials(v.BasicAuthCredentials); err != nil {
			invalidParams.AddNested("BasicAuthCredentials", err.(smithy.InvalidParamsError))
		}
	}
	if v.OAuthCredentials != nil {
		if err := validateOAuthCredentials(v.OAuthCredentials); err != nil {
			invalidParams.AddNested("OAuthCredentials", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataConnectorProfileProperties(v *types.SAPODataConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataConnectorProfileProperties"}
	if v.ApplicationHostUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationHostUrl"))
	}
	if v.ApplicationServicePath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationServicePath"))
	}
	if v.PortNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PortNumber"))
	}
	if v.ClientNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientNumber"))
	}
	if v.OAuthProperties != nil {
		if err := validateOAuthProperties(v.OAuthProperties); err != nil {
			invalidParams.AddNested("OAuthProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataDestinationProperties(v *types.SAPODataDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataDestinationProperties"}
	if v.ObjectPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectPath"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataPaginationConfig(v *types.SAPODataPaginationConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataPaginationConfig"}
	if v.MaxPageSize == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxPageSize"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataParallelismConfig(v *types.SAPODataParallelismConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataParallelismConfig"}
	if v.MaxParallelism == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxParallelism"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSAPODataSourceProperties(v *types.SAPODataSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SAPODataSourceProperties"}
	if v.ParallelismConfig != nil {
		if err := validateSAPODataParallelismConfig(v.ParallelismConfig); err != nil {
			invalidParams.AddNested("ParallelismConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.PaginationConfig != nil {
		if err := validateSAPODataPaginationConfig(v.PaginationConfig); err != nil {
			invalidParams.AddNested("PaginationConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScheduledTriggerProperties(v *types.ScheduledTriggerProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScheduledTriggerProperties"}
	if v.ScheduleExpression == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScheduleExpression"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceNowConnectorProfileProperties(v *types.ServiceNowConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceNowConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceNowSourceProperties(v *types.ServiceNowSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceNowSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSingularConnectorProfileCredentials(v *types.SingularConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SingularConnectorProfileCredentials"}
	if v.ApiKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSingularSourceProperties(v *types.SingularSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SingularSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSlackConnectorProfileCredentials(v *types.SlackConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SlackConnectorProfileCredentials"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSlackConnectorProfileProperties(v *types.SlackConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SlackConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSlackSourceProperties(v *types.SlackSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SlackSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSnowflakeConnectorProfileCredentials(v *types.SnowflakeConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SnowflakeConnectorProfileCredentials"}
	if v.Username == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Username"))
	}
	if v.Password == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Password"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSnowflakeConnectorProfileProperties(v *types.SnowflakeConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SnowflakeConnectorProfileProperties"}
	if v.Warehouse == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Warehouse"))
	}
	if v.Stage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Stage"))
	}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSnowflakeDestinationProperties(v *types.SnowflakeDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SnowflakeDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if v.IntermediateBucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IntermediateBucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceConnectorProperties(v *types.SourceConnectorProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceConnectorProperties"}
	if v.Amplitude != nil {
		if err := validateAmplitudeSourceProperties(v.Amplitude); err != nil {
			invalidParams.AddNested("Amplitude", err.(smithy.InvalidParamsError))
		}
	}
	if v.Datadog != nil {
		if err := validateDatadogSourceProperties(v.Datadog); err != nil {
			invalidParams.AddNested("Datadog", err.(smithy.InvalidParamsError))
		}
	}
	if v.Dynatrace != nil {
		if err := validateDynatraceSourceProperties(v.Dynatrace); err != nil {
			invalidParams.AddNested("Dynatrace", err.(smithy.InvalidParamsError))
		}
	}
	if v.GoogleAnalytics != nil {
		if err := validateGoogleAnalyticsSourceProperties(v.GoogleAnalytics); err != nil {
			invalidParams.AddNested("GoogleAnalytics", err.(smithy.InvalidParamsError))
		}
	}
	if v.InforNexus != nil {
		if err := validateInforNexusSourceProperties(v.InforNexus); err != nil {
			invalidParams.AddNested("InforNexus", err.(smithy.InvalidParamsError))
		}
	}
	if v.Marketo != nil {
		if err := validateMarketoSourceProperties(v.Marketo); err != nil {
			invalidParams.AddNested("Marketo", err.(smithy.InvalidParamsError))
		}
	}
	if v.S3 != nil {
		if err := validateS3SourceProperties(v.S3); err != nil {
			invalidParams.AddNested("S3", err.(smithy.InvalidParamsError))
		}
	}
	if v.Salesforce != nil {
		if err := validateSalesforceSourceProperties(v.Salesforce); err != nil {
			invalidParams.AddNested("Salesforce", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceNow != nil {
		if err := validateServiceNowSourceProperties(v.ServiceNow); err != nil {
			invalidParams.AddNested("ServiceNow", err.(smithy.InvalidParamsError))
		}
	}
	if v.Singular != nil {
		if err := validateSingularSourceProperties(v.Singular); err != nil {
			invalidParams.AddNested("Singular", err.(smithy.InvalidParamsError))
		}
	}
	if v.Slack != nil {
		if err := validateSlackSourceProperties(v.Slack); err != nil {
			invalidParams.AddNested("Slack", err.(smithy.InvalidParamsError))
		}
	}
	if v.Trendmicro != nil {
		if err := validateTrendmicroSourceProperties(v.Trendmicro); err != nil {
			invalidParams.AddNested("Trendmicro", err.(smithy.InvalidParamsError))
		}
	}
	if v.Veeva != nil {
		if err := validateVeevaSourceProperties(v.Veeva); err != nil {
			invalidParams.AddNested("Veeva", err.(smithy.InvalidParamsError))
		}
	}
	if v.Zendesk != nil {
		if err := validateZendeskSourceProperties(v.Zendesk); err != nil {
			invalidParams.AddNested("Zendesk", err.(smithy.InvalidParamsError))
		}
	}
	if v.SAPOData != nil {
		if err := validateSAPODataSourceProperties(v.SAPOData); err != nil {
			invalidParams.AddNested("SAPOData", err.(smithy.InvalidParamsError))
		}
	}
	if v.CustomConnector != nil {
		if err := validateCustomConnectorSourceProperties(v.CustomConnector); err != nil {
			invalidParams.AddNested("CustomConnector", err.(smithy.InvalidParamsError))
		}
	}
	if v.Pardot != nil {
		if err := validatePardotSourceProperties(v.Pardot); err != nil {
			invalidParams.AddNested("Pardot", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceFlowConfig(v *types.SourceFlowConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceFlowConfig"}
	if len(v.ConnectorType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorType"))
	}
	if v.SourceConnectorProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceConnectorProperties"))
	} else if v.SourceConnectorProperties != nil {
		if err := validateSourceConnectorProperties(v.SourceConnectorProperties); err != nil {
			invalidParams.AddNested("SourceConnectorProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTask(v *types.Task) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Task"}
	if v.SourceFields == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceFields"))
	}
	if len(v.TaskType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TaskType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTasks(v []types.Task) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tasks"}
	for i := range v {
		if err := validateTask(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrendmicroConnectorProfileCredentials(v *types.TrendmicroConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TrendmicroConnectorProfileCredentials"}
	if v.ApiSecretKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiSecretKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrendmicroSourceProperties(v *types.TrendmicroSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TrendmicroSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTriggerConfig(v *types.TriggerConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TriggerConfig"}
	if len(v.TriggerType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TriggerType"))
	}
	if v.TriggerProperties != nil {
		if err := validateTriggerProperties(v.TriggerProperties); err != nil {
			invalidParams.AddNested("TriggerProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTriggerProperties(v *types.TriggerProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TriggerProperties"}
	if v.Scheduled != nil {
		if err := validateScheduledTriggerProperties(v.Scheduled); err != nil {
			invalidParams.AddNested("Scheduled", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpsolverDestinationProperties(v *types.UpsolverDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpsolverDestinationProperties"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.S3OutputFormatConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3OutputFormatConfig"))
	} else if v.S3OutputFormatConfig != nil {
		if err := validateUpsolverS3OutputFormatConfig(v.S3OutputFormatConfig); err != nil {
			invalidParams.AddNested("S3OutputFormatConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpsolverS3OutputFormatConfig(v *types.UpsolverS3OutputFormatConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpsolverS3OutputFormatConfig"}
	if v.PrefixConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrefixConfig"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVeevaConnectorProfileCredentials(v *types.VeevaConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VeevaConnectorProfileCredentials"}
	if v.Username == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Username"))
	}
	if v.Password == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Password"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVeevaConnectorProfileProperties(v *types.VeevaConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VeevaConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVeevaSourceProperties(v *types.VeevaSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VeevaSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateZendeskConnectorProfileCredentials(v *types.ZendeskConnectorProfileCredentials) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ZendeskConnectorProfileCredentials"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateZendeskConnectorProfileProperties(v *types.ZendeskConnectorProfileProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ZendeskConnectorProfileProperties"}
	if v.InstanceUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateZendeskDestinationProperties(v *types.ZendeskDestinationProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ZendeskDestinationProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateZendeskSourceProperties(v *types.ZendeskSourceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ZendeskSourceProperties"}
	if v.Object == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Object"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelFlowExecutionsInput(v *CancelFlowExecutionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelFlowExecutionsInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateConnectorProfileInput(v *CreateConnectorProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateConnectorProfileInput"}
	if v.ConnectorProfileName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileName"))
	}
	if len(v.ConnectorType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorType"))
	}
	if len(v.ConnectionMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionMode"))
	}
	if v.ConnectorProfileConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileConfig"))
	} else if v.ConnectorProfileConfig != nil {
		if err := validateConnectorProfileConfig(v.ConnectorProfileConfig); err != nil {
			invalidParams.AddNested("ConnectorProfileConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFlowInput(v *CreateFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if v.TriggerConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TriggerConfig"))
	} else if v.TriggerConfig != nil {
		if err := validateTriggerConfig(v.TriggerConfig); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceFlowConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceFlowConfig"))
	} else if v.SourceFlowConfig != nil {
		if err := validateSourceFlowConfig(v.SourceFlowConfig); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationFlowConfigList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationFlowConfigList"))
	} else if v.DestinationFlowConfigList != nil {
		if err := validateDestinationFlowConfigList(v.DestinationFlowConfigList); err != nil {
			invalidParams.AddNested("DestinationFlowConfigList", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tasks == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tasks"))
	} else if v.Tasks != nil {
		if err := validateTasks(v.Tasks); err != nil {
			invalidParams.AddNested("Tasks", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetadataCatalogConfig != nil {
		if err := validateMetadataCatalogConfig(v.MetadataCatalogConfig); err != nil {
			invalidParams.AddNested("MetadataCatalogConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConnectorProfileInput(v *DeleteConnectorProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConnectorProfileInput"}
	if v.ConnectorProfileName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFlowInput(v *DeleteFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeConnectorEntityInput(v *DescribeConnectorEntityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeConnectorEntityInput"}
	if v.ConnectorEntityName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorEntityName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeConnectorInput(v *DescribeConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeConnectorInput"}
	if len(v.ConnectorType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeFlowExecutionRecordsInput(v *DescribeFlowExecutionRecordsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeFlowExecutionRecordsInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeFlowInput(v *DescribeFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterConnectorInput(v *RegisterConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterConnectorInput"}
	if v.ConnectorProvisioningConfig != nil {
		if err := validateConnectorProvisioningConfig(v.ConnectorProvisioningConfig); err != nil {
			invalidParams.AddNested("ConnectorProvisioningConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartFlowInput(v *StartFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopFlowInput(v *StopFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUnregisterConnectorInput(v *UnregisterConnectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UnregisterConnectorInput"}
	if v.ConnectorLabel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorLabel"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConnectorProfileInput(v *UpdateConnectorProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConnectorProfileInput"}
	if v.ConnectorProfileName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileName"))
	}
	if len(v.ConnectionMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionMode"))
	}
	if v.ConnectorProfileConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorProfileConfig"))
	} else if v.ConnectorProfileConfig != nil {
		if err := validateConnectorProfileConfig(v.ConnectorProfileConfig); err != nil {
			invalidParams.AddNested("ConnectorProfileConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConnectorRegistrationInput(v *UpdateConnectorRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConnectorRegistrationInput"}
	if v.ConnectorLabel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectorLabel"))
	}
	if v.ConnectorProvisioningConfig != nil {
		if err := validateConnectorProvisioningConfig(v.ConnectorProvisioningConfig); err != nil {
			invalidParams.AddNested("ConnectorProvisioningConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFlowInput(v *UpdateFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFlowInput"}
	if v.FlowName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FlowName"))
	}
	if v.TriggerConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TriggerConfig"))
	} else if v.TriggerConfig != nil {
		if err := validateTriggerConfig(v.TriggerConfig); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceFlowConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceFlowConfig"))
	} else if v.SourceFlowConfig != nil {
		if err := validateSourceFlowConfig(v.SourceFlowConfig); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationFlowConfigList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationFlowConfigList"))
	} else if v.DestinationFlowConfigList != nil {
		if err := validateDestinationFlowConfigList(v.DestinationFlowConfigList); err != nil {
			invalidParams.AddNested("DestinationFlowConfigList", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tasks == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tasks"))
	} else if v.Tasks != nil {
		if err := validateTasks(v.Tasks); err != nil {
			invalidParams.AddNested("Tasks", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetadataCatalogConfig != nil {
		if err := validateMetadataCatalogConfig(v.MetadataCatalogConfig); err != nil {
			invalidParams.AddNested("MetadataCatalogConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
