package mail

import (
	//"fmt"
	"bytes"
	//"strings"
	"testing"
)

func TestWriter(t *testing.T) {
	testWriter(t, false)
}

func testWriter(t *testing.T, binary bool) {
	utf8 := "utf-8"
	tests := []struct {
		charset   string
		usedChars int
		in, want  string
	}{
		{utf8, 0, "", ""},
		{utf8, 0, "  ", ""},
		{utf8, 8, "", ""},
		{utf8, 0, "This is an English string. 0123456789", "This is an English string. 0123456789"},
		{utf8, 0, "日本語テキストです。", "=?UTF-8?Q?=E6=97=A5=E6=9C=AC=E8=AA=9E=E3=83=86=E3=82=AD=E3=82=B9=E3=83=88?=\r\n =?UTF-8?Q?=E3=81=A7=E3=81=99=E3=80=82?="},
		{utf8, 8, "日本語テキストです。", "=?UTF-8?Q?=E6=97=A5=E6=9C=AC=E8=AA=9E=E3=83=86=E3=82=AD=E3=82=B9?=\r\n =?UTF-8?Q?=E3=83=88=E3=81=A7=E3=81=99=E3=80=82?="},
		{utf8, 0, "漢字、カタカナ、ひらがなを含む、非常に長いタイトル行が一体全体どのようにしてEncodeされるのか？", "=?UTF-8?Q?=E6=BC=A2=E5=AD=97=E3=80=81=E3=82=AB=E3=82=BF=E3=82=AB=E3=83=8A?=\r\n =?UTF-8?Q?=E3=80=81=E3=81=B2=E3=82=89=E3=81=8C=E3=81=AA=E3=82=92=E5=90=AB?=\r\n =?UTF-8?Q?=E3=82=80=E3=80=81=E9=9D=9E=E5=B8=B8=E3=81=AB=E9=95=B7=E3=81=84?=\r\n =?UTF-8?Q?=E3=82=BF=E3=82=A4=E3=83=88=E3=83=AB=E8=A1=8C=E3=81=8C=E4=B8=80?=\r\n =?UTF-8?Q?=E4=BD=93=E5=85=A8=E4=BD=93=E3=81=A9=E3=81=AE=E3=82=88=E3=81=86?=\r\n =?UTF-8?Q?=E3=81=AB=E3=81=97=E3=81=A6Encode=E3=81=95=E3=82=8C=E3=82=8B?=\r\n =?UTF-8?Q?=E3=81=AE=E3=81=8B=EF=BC=9F?="},
		{utf8, 0, "dankogai@dan.co.jp (小飼=Kogai, 弾=Dan)", "=?UTF-8?Q?dankogai@dan.co.jp_(=E5=B0=8F=E9=A3=BC=3DKogai,_=E5=BC=BE=3DDan?=\r\n =?UTF-8?Q?)?="},
		{utf8, 0, "Αυτό είναι ελληνικό κείμενο. 0123456789.", "=?UTF-8?Q?=CE=91=CF=85=CF=84=CF=8C_=CE=B5=CE=AF=CE=BD=CE=B1=CE=B9_=CE=B5?=\r\n =?UTF-8?Q?=CE=BB=CE=BB=CE=B7=CE=BD=CE=B9=CE=BA=CF=8C_=CE=BA=CE=B5=CE=AF?=\r\n =?UTF-8?Q?=CE=BC=CE=B5=CE=BD=CE=BF._0123456789.?="},
		{utf8, 0, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 1, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 2, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 3, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 4, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 5, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 6, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 7, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 8, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 9, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 10, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 11, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 12, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 13, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 14, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 15, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra\r\n quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 16, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 17, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 18, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 19, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 20, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 21, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 22, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 23, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 24, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi ut\r\n pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper\r\n laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac\r\n suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis\r\n urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
		{utf8, 25, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi\r\n ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 26, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi\r\n ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 27, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed morbi\r\n ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 28, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 29, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 30, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 31, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 32, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 33, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer Sed\r\n morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque\r\n semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus\r\n faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 34, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer\r\n Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus\r\n pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae\r\n Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 35, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer\r\n Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus\r\n pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae\r\n Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 36, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer\r\n Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus\r\n pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae\r\n Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 37, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet consectetuer\r\n Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus\r\n pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae\r\n Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis\r\n tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo\r\n Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 38, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 39, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 40, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 41, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 42, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 43, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 44, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 45, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 46, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 47, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 48, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 49, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 50, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit amet\r\n consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus\r\n metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue\r\n vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis\r\n quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl\r\n leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 51, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit\r\n amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 52, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit\r\n amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 53, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit\r\n amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 54, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit\r\n amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 55, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor sit\r\n amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 56, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor\r\n sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 57, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor\r\n sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 58, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor\r\n sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 59, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum dolor\r\n sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh\r\n tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum\r\n augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla\r\n convallis quis tincidunt convallis urna adipiscing eros nunc porttitor.\r\n Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor."},
		{utf8, 60, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 61, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 62, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 63, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 64, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 65, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem ipsum\r\n dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 66, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 67, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 68, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 69, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 70, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 71, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "Lorem\r\n ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient\r\n tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed\r\n in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et\r\n fringilla convallis quis tincidunt convallis urna adipiscing eros nunc\r\n porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus\r\n tortor."},
		{utf8, 72, "Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis. Parturient tincidunt nibh tellus metus pellentesque semper laoreet In tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit accumsan gravida. Et fringilla convallis quis tincidunt convallis urna adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum Vestibulum nunc purus tortor.", "\r\n Lorem ipsum dolor sit amet consectetuer Sed morbi ut pharetra quis.\r\n Parturient tincidunt nibh tellus metus pellentesque semper laoreet In\r\n tempor sed. Sed in Vestibulum augue vitae Vivamus faucibus ac suscipit\r\n accumsan gravida. Et fringilla convallis quis tincidunt convallis urna\r\n adipiscing eros nunc porttitor. Ipsum id nisl leo Curabitur purus Cum\r\n Vestibulum nunc purus tortor."},
	}

	for _, test := range tests {
		//fmt.Println("Here! <---------------------------------------------------------------")
		buf := new(bytes.Buffer)
		w := newEncoder(buf, test.charset, test.usedChars)

		if _, err := w.encode([]byte(test.in)); err != nil {
			t.Errorf("Write(%q): %v", test.in, err)
			continue
		}

		if buf.String() != test.want {
			t.Errorf("Charset: %s Used Chars: %d Write(%q), \r\ngot:\r\n%q\r\nwant:\r\n%q", test.charset, test.usedChars, test.in, buf, test.want)
		}
	}
}
