// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/estimate_billing_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [EstimateBillingService.EstimateDataSize][google.cloud.discoveryengine.v1alpha.EstimateBillingService.EstimateDataSize]
// method
type EstimateDataSizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data source for which we are estimating its size.
	//
	// Types that are assignable to DataSource:
	//
	//	*EstimateDataSizeRequest_WebsiteDataSource_
	//	*EstimateDataSizeRequest_FileDataSource_
	DataSource isEstimateDataSizeRequest_DataSource `protobuf_oneof:"data_source"`
	// Required. Full resource name of the location, such as
	// `projects/{project}/locations/{location}`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *EstimateDataSizeRequest) Reset() {
	*x = EstimateDataSizeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeRequest) ProtoMessage() {}

func (x *EstimateDataSizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeRequest.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{0}
}

func (m *EstimateDataSizeRequest) GetDataSource() isEstimateDataSizeRequest_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *EstimateDataSizeRequest) GetWebsiteDataSource() *EstimateDataSizeRequest_WebsiteDataSource {
	if x, ok := x.GetDataSource().(*EstimateDataSizeRequest_WebsiteDataSource_); ok {
		return x.WebsiteDataSource
	}
	return nil
}

func (x *EstimateDataSizeRequest) GetFileDataSource() *EstimateDataSizeRequest_FileDataSource {
	if x, ok := x.GetDataSource().(*EstimateDataSizeRequest_FileDataSource_); ok {
		return x.FileDataSource
	}
	return nil
}

func (x *EstimateDataSizeRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type isEstimateDataSizeRequest_DataSource interface {
	isEstimateDataSizeRequest_DataSource()
}

type EstimateDataSizeRequest_WebsiteDataSource_ struct {
	// Website data.
	WebsiteDataSource *EstimateDataSizeRequest_WebsiteDataSource `protobuf:"bytes,2,opt,name=website_data_source,json=websiteDataSource,proto3,oneof"`
}

type EstimateDataSizeRequest_FileDataSource_ struct {
	// Structured or unstructured data.
	FileDataSource *EstimateDataSizeRequest_FileDataSource `protobuf:"bytes,3,opt,name=file_data_source,json=fileDataSource,proto3,oneof"`
}

func (*EstimateDataSizeRequest_WebsiteDataSource_) isEstimateDataSizeRequest_DataSource() {}

func (*EstimateDataSizeRequest_FileDataSource_) isEstimateDataSizeRequest_DataSource() {}

// Response of the EstimateDataSize request. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type EstimateDataSizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data size in terms of bytes.
	DataSizeBytes int64 `protobuf:"varint,1,opt,name=data_size_bytes,json=dataSizeBytes,proto3" json:"data_size_bytes,omitempty"`
	// Total number of documents.
	DocumentCount int64 `protobuf:"varint,2,opt,name=document_count,json=documentCount,proto3" json:"document_count,omitempty"`
}

func (x *EstimateDataSizeResponse) Reset() {
	*x = EstimateDataSizeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeResponse) ProtoMessage() {}

func (x *EstimateDataSizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeResponse.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{1}
}

func (x *EstimateDataSizeResponse) GetDataSizeBytes() int64 {
	if x != nil {
		return x.DataSizeBytes
	}
	return 0
}

func (x *EstimateDataSizeResponse) GetDocumentCount() int64 {
	if x != nil {
		return x.DocumentCount
	}
	return 0
}

// Metadata related to the progress of the EstimateDataSize operation. This is
// returned by the google.longrunning.Operation.metadata field.
type EstimateDataSizeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *EstimateDataSizeMetadata) Reset() {
	*x = EstimateDataSizeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeMetadata) ProtoMessage() {}

func (x *EstimateDataSizeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeMetadata.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{2}
}

func (x *EstimateDataSizeMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Data source is a set of website patterns that we crawl to get
// the total number of websites.
type EstimateDataSizeRequest_WebsiteDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI patterns to estimate the data sizes. At most 10
	// patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
	EstimatorUriPatterns []*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern `protobuf:"bytes,1,rep,name=estimator_uri_patterns,json=estimatorUriPatterns,proto3" json:"estimator_uri_patterns,omitempty"`
}

func (x *EstimateDataSizeRequest_WebsiteDataSource) Reset() {
	*x = EstimateDataSizeRequest_WebsiteDataSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeRequest_WebsiteDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeRequest_WebsiteDataSource) ProtoMessage() {}

func (x *EstimateDataSizeRequest_WebsiteDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeRequest_WebsiteDataSource.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeRequest_WebsiteDataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *EstimateDataSizeRequest_WebsiteDataSource) GetEstimatorUriPatterns() []*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern {
	if x != nil {
		return x.EstimatorUriPatterns
	}
	return nil
}

// Data source contains files either in Cloud Storage or BigQuery.
type EstimateDataSizeRequest_FileDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which source contains the files to be used.
	//
	// Types that are assignable to Source:
	//
	//	*EstimateDataSizeRequest_FileDataSource_GcsSource
	//	*EstimateDataSizeRequest_FileDataSource_BigquerySource
	Source isEstimateDataSizeRequest_FileDataSource_Source `protobuf_oneof:"source"`
}

func (x *EstimateDataSizeRequest_FileDataSource) Reset() {
	*x = EstimateDataSizeRequest_FileDataSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeRequest_FileDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeRequest_FileDataSource) ProtoMessage() {}

func (x *EstimateDataSizeRequest_FileDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeRequest_FileDataSource.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeRequest_FileDataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{0, 1}
}

func (m *EstimateDataSizeRequest_FileDataSource) GetSource() isEstimateDataSizeRequest_FileDataSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *EstimateDataSizeRequest_FileDataSource) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*EstimateDataSizeRequest_FileDataSource_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *EstimateDataSizeRequest_FileDataSource) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*EstimateDataSizeRequest_FileDataSource_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

type isEstimateDataSizeRequest_FileDataSource_Source interface {
	isEstimateDataSizeRequest_FileDataSource_Source()
}

type EstimateDataSizeRequest_FileDataSource_GcsSource struct {
	// Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type EstimateDataSizeRequest_FileDataSource_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,2,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*EstimateDataSizeRequest_FileDataSource_GcsSource) isEstimateDataSizeRequest_FileDataSource_Source() {
}

func (*EstimateDataSizeRequest_FileDataSource_BigquerySource) isEstimateDataSizeRequest_FileDataSource_Source() {
}

// URI patterns that we use to crawl.
type EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User provided URI pattern. For example, `foo.com/bar/*`.
	ProvidedUriPattern string `protobuf:"bytes,1,opt,name=provided_uri_pattern,json=providedUriPattern,proto3" json:"provided_uri_pattern,omitempty"`
	// Whether we infer the generated URI or use the exact provided one.
	ExactMatch bool `protobuf:"varint,2,opt,name=exact_match,json=exactMatch,proto3" json:"exact_match,omitempty"`
	// Whether the pattern is exclusive or not. If set to true, the pattern is
	// considered exclusive. If unset or set to false, the pattern is
	// considered inclusive by default.
	Exclusive bool `protobuf:"varint,3,opt,name=exclusive,proto3" json:"exclusive,omitempty"`
}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) Reset() {
	*x = EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) ProtoMessage() {}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern.ProtoReflect.Descriptor instead.
func (*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) GetProvidedUriPattern() string {
	if x != nil {
		return x.ProvidedUriPattern
	}
	return ""
}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) GetExactMatch() bool {
	if x != nil {
		return x.ExactMatch
	}
	return false
}

func (x *EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern) GetExclusive() bool {
	if x != nil {
		return x.Exclusive
	}
	return false
}

var File_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83,
	0x07, 0x0a, 0x17, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x77,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x77, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x78,
	0x0a, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xbd, 0x02, 0x0a, 0x11, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x16,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x63, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x72, 0x69, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f,
	0x72, 0x55, 0x72, 0x69, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x1a, 0x86, 0x01, 0x0a,
	0x13, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x72, 0x69, 0x50, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64,
	0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x55, 0x72, 0x69, 0x50,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x78, 0x61,
	0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x1a, 0xcd, 0x01, 0x0a, 0x0e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0x69, 0x0a, 0x18, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0x57, 0x0a, 0x18, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xa9, 0x03, 0x0a, 0x16, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xba, 0x02, 0x0a, 0x10, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x01, 0xca, 0x41, 0x7e, 0x0a, 0x3d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69,
	0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65,
	0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa7, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x1b, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59,
	0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_goTypes = []interface{}{
	(*EstimateDataSizeRequest)(nil),                                       // 0: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
	(*EstimateDataSizeResponse)(nil),                                      // 1: google.cloud.discoveryengine.v1alpha.EstimateDataSizeResponse
	(*EstimateDataSizeMetadata)(nil),                                      // 2: google.cloud.discoveryengine.v1alpha.EstimateDataSizeMetadata
	(*EstimateDataSizeRequest_WebsiteDataSource)(nil),                     // 3: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
	(*EstimateDataSizeRequest_FileDataSource)(nil),                        // 4: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
	(*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern)(nil), // 5: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern
	(*timestamppb.Timestamp)(nil),                                         // 6: google.protobuf.Timestamp
	(*GcsSource)(nil),                                                     // 7: google.cloud.discoveryengine.v1alpha.GcsSource
	(*BigQuerySource)(nil),                                                // 8: google.cloud.discoveryengine.v1alpha.BigQuerySource
	(*longrunningpb.Operation)(nil),                                       // 9: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_depIdxs = []int32{
	3, // 0: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.website_data_source:type_name -> google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
	4, // 1: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.file_data_source:type_name -> google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
	6, // 2: google.cloud.discoveryengine.v1alpha.EstimateDataSizeMetadata.create_time:type_name -> google.protobuf.Timestamp
	5, // 3: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.estimator_uri_patterns:type_name -> google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern
	7, // 4: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.gcs_source:type_name -> google.cloud.discoveryengine.v1alpha.GcsSource
	8, // 5: google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.bigquery_source:type_name -> google.cloud.discoveryengine.v1alpha.BigQuerySource
	0, // 6: google.cloud.discoveryengine.v1alpha.EstimateBillingService.EstimateDataSize:input_type -> google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
	9, // 7: google.cloud.discoveryengine.v1alpha.EstimateBillingService.EstimateDataSize:output_type -> google.longrunning.Operation
	7, // [7:8] is the sub-list for method output_type
	6, // [6:7] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeRequest_WebsiteDataSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeRequest_FileDataSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*EstimateDataSizeRequest_WebsiteDataSource_)(nil),
		(*EstimateDataSizeRequest_FileDataSource_)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*EstimateDataSizeRequest_FileDataSource_GcsSource)(nil),
		(*EstimateDataSizeRequest_FileDataSource_BigquerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_estimate_billing_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EstimateBillingServiceClient is the client API for EstimateBillingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EstimateBillingServiceClient interface {
	// Estimates the data size to be used by a customer.
	EstimateDataSize(ctx context.Context, in *EstimateDataSizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type estimateBillingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEstimateBillingServiceClient(cc grpc.ClientConnInterface) EstimateBillingServiceClient {
	return &estimateBillingServiceClient{cc}
}

func (c *estimateBillingServiceClient) EstimateDataSize(ctx context.Context, in *EstimateDataSizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.EstimateBillingService/EstimateDataSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EstimateBillingServiceServer is the server API for EstimateBillingService service.
type EstimateBillingServiceServer interface {
	// Estimates the data size to be used by a customer.
	EstimateDataSize(context.Context, *EstimateDataSizeRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEstimateBillingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEstimateBillingServiceServer struct {
}

func (*UnimplementedEstimateBillingServiceServer) EstimateDataSize(context.Context, *EstimateDataSizeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EstimateDataSize not implemented")
}

func RegisterEstimateBillingServiceServer(s *grpc.Server, srv EstimateBillingServiceServer) {
	s.RegisterService(&_EstimateBillingService_serviceDesc, srv)
}

func _EstimateBillingService_EstimateDataSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EstimateDataSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EstimateBillingServiceServer).EstimateDataSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.EstimateBillingService/EstimateDataSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EstimateBillingServiceServer).EstimateDataSize(ctx, req.(*EstimateDataSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EstimateBillingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1alpha.EstimateBillingService",
	HandlerType: (*EstimateBillingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EstimateDataSize",
			Handler:    _EstimateBillingService_EstimateDataSize_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1alpha/estimate_billing_service.proto",
}
