// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/osconfig/agentendpoint/v1/inventory.proto

package agentendpointpb

import (
	reflect "reflect"
	sync "sync"

	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The inventory details of a VM.
type Inventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Base level operating system information for the VM.
	OsInfo *Inventory_OsInfo `protobuf:"bytes,1,opt,name=os_info,json=osInfo,proto3" json:"os_info,omitempty"`
	// A list of installed packages currently on the VM.
	InstalledPackages []*Inventory_SoftwarePackage `protobuf:"bytes,2,rep,name=installed_packages,json=installedPackages,proto3" json:"installed_packages,omitempty"`
	// A list of software updates available for the VM as reported by the update
	// managers.
	AvailablePackages []*Inventory_SoftwarePackage `protobuf:"bytes,3,rep,name=available_packages,json=availablePackages,proto3" json:"available_packages,omitempty"`
}

func (x *Inventory) Reset() {
	*x = Inventory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory) ProtoMessage() {}

func (x *Inventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory.ProtoReflect.Descriptor instead.
func (*Inventory) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0}
}

func (x *Inventory) GetOsInfo() *Inventory_OsInfo {
	if x != nil {
		return x.OsInfo
	}
	return nil
}

func (x *Inventory) GetInstalledPackages() []*Inventory_SoftwarePackage {
	if x != nil {
		return x.InstalledPackages
	}
	return nil
}

func (x *Inventory) GetAvailablePackages() []*Inventory_SoftwarePackage {
	if x != nil {
		return x.AvailablePackages
	}
	return nil
}

// Operating system information for the VM.
type Inventory_OsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM hostname.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// The operating system long name.
	// For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
	// Datacenter'.
	LongName string `protobuf:"bytes,2,opt,name=long_name,json=longName,proto3" json:"long_name,omitempty"`
	// The operating system short name.
	// For example, 'windows' or 'debian'.
	ShortName string `protobuf:"bytes,3,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The version of the operating system.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// The system architecture of the operating system.
	Architecture string `protobuf:"bytes,5,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// The kernel version of the operating system.
	KernelVersion string `protobuf:"bytes,6,opt,name=kernel_version,json=kernelVersion,proto3" json:"kernel_version,omitempty"`
	// The kernel release of the operating system.
	KernelRelease string `protobuf:"bytes,7,opt,name=kernel_release,json=kernelRelease,proto3" json:"kernel_release,omitempty"`
	// The current version of the OS Config agent running on the VM.
	OsconfigAgentVersion string `protobuf:"bytes,8,opt,name=osconfig_agent_version,json=osconfigAgentVersion,proto3" json:"osconfig_agent_version,omitempty"`
}

func (x *Inventory_OsInfo) Reset() {
	*x = Inventory_OsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_OsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_OsInfo) ProtoMessage() {}

func (x *Inventory_OsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_OsInfo.ProtoReflect.Descriptor instead.
func (*Inventory_OsInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Inventory_OsInfo) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Inventory_OsInfo) GetLongName() string {
	if x != nil {
		return x.LongName
	}
	return ""
}

func (x *Inventory_OsInfo) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *Inventory_OsInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Inventory_OsInfo) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *Inventory_OsInfo) GetKernelVersion() string {
	if x != nil {
		return x.KernelVersion
	}
	return ""
}

func (x *Inventory_OsInfo) GetKernelRelease() string {
	if x != nil {
		return x.KernelRelease
	}
	return ""
}

func (x *Inventory_OsInfo) GetOsconfigAgentVersion() string {
	if x != nil {
		return x.OsconfigAgentVersion
	}
	return ""
}

// Software package information of the operating system.
type Inventory_SoftwarePackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the different types of software packages.
	//
	// Types that are assignable to Details:
	//
	//	*Inventory_SoftwarePackage_YumPackage
	//	*Inventory_SoftwarePackage_AptPackage
	//	*Inventory_SoftwarePackage_ZypperPackage
	//	*Inventory_SoftwarePackage_GoogetPackage
	//	*Inventory_SoftwarePackage_ZypperPatch
	//	*Inventory_SoftwarePackage_WuaPackage
	//	*Inventory_SoftwarePackage_QfePackage
	//	*Inventory_SoftwarePackage_CosPackage
	//	*Inventory_SoftwarePackage_WindowsApplication
	Details isInventory_SoftwarePackage_Details `protobuf_oneof:"details"`
}

func (x *Inventory_SoftwarePackage) Reset() {
	*x = Inventory_SoftwarePackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_SoftwarePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_SoftwarePackage) ProtoMessage() {}

func (x *Inventory_SoftwarePackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_SoftwarePackage.ProtoReflect.Descriptor instead.
func (*Inventory_SoftwarePackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 1}
}

func (m *Inventory_SoftwarePackage) GetDetails() isInventory_SoftwarePackage_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetYumPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_YumPackage); ok {
		return x.YumPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetAptPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_AptPackage); ok {
		return x.AptPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetZypperPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_ZypperPackage); ok {
		return x.ZypperPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetGoogetPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_GoogetPackage); ok {
		return x.GoogetPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetZypperPatch() *Inventory_ZypperPatch {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_ZypperPatch); ok {
		return x.ZypperPatch
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetWuaPackage() *Inventory_WindowsUpdatePackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_WuaPackage); ok {
		return x.WuaPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetQfePackage() *Inventory_WindowsQuickFixEngineeringPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_QfePackage); ok {
		return x.QfePackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetCosPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_CosPackage); ok {
		return x.CosPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetWindowsApplication() *Inventory_WindowsApplication {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_WindowsApplication); ok {
		return x.WindowsApplication
	}
	return nil
}

type isInventory_SoftwarePackage_Details interface {
	isInventory_SoftwarePackage_Details()
}

type Inventory_SoftwarePackage_YumPackage struct {
	// Yum package info.
	// For details about the yum package manager, see
	// https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
	YumPackage *Inventory_VersionedPackage `protobuf:"bytes,1,opt,name=yum_package,json=yumPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_AptPackage struct {
	// Details of an APT package.
	// For details about the apt package manager, see
	// https://wiki.debian.org/Apt.
	AptPackage *Inventory_VersionedPackage `protobuf:"bytes,2,opt,name=apt_package,json=aptPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_ZypperPackage struct {
	// Details of a Zypper package.
	// For details about the Zypper package manager, see
	// https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPackage *Inventory_VersionedPackage `protobuf:"bytes,3,opt,name=zypper_package,json=zypperPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_GoogetPackage struct {
	// Details of a Googet package.
	//
	//	For details about the googet package manager, see
	//	https://github.com/google/googet.
	GoogetPackage *Inventory_VersionedPackage `protobuf:"bytes,4,opt,name=googet_package,json=googetPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_ZypperPatch struct {
	// Details of a Zypper patch.
	// For details about the Zypper package manager, see
	// https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPatch *Inventory_ZypperPatch `protobuf:"bytes,5,opt,name=zypper_patch,json=zypperPatch,proto3,oneof"`
}

type Inventory_SoftwarePackage_WuaPackage struct {
	// Details of a Windows Update package.
	// See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
	// information about Windows Update.
	WuaPackage *Inventory_WindowsUpdatePackage `protobuf:"bytes,6,opt,name=wua_package,json=wuaPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_QfePackage struct {
	// Details of a Windows Quick Fix engineering package.
	// See
	// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
	// for info in Windows Quick Fix Engineering.
	QfePackage *Inventory_WindowsQuickFixEngineeringPackage `protobuf:"bytes,7,opt,name=qfe_package,json=qfePackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_CosPackage struct {
	// Details of a COS package.
	CosPackage *Inventory_VersionedPackage `protobuf:"bytes,8,opt,name=cos_package,json=cosPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_WindowsApplication struct {
	// Details of Windows Application.
	WindowsApplication *Inventory_WindowsApplication `protobuf:"bytes,9,opt,name=windows_application,json=windowsApplication,proto3,oneof"`
}

func (*Inventory_SoftwarePackage_YumPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_AptPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_ZypperPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_GoogetPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_ZypperPatch) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_WuaPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_QfePackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_CosPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_WindowsApplication) isInventory_SoftwarePackage_Details() {}

// Information related to the a standard versioned package.  This includes
// package info for APT, Yum, Zypper, and Googet package managers.
type Inventory_VersionedPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	PackageName string `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// The system architecture this package is intended for.
	Architecture string `protobuf:"bytes,2,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// The version of the package.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Inventory_VersionedPackage) Reset() {
	*x = Inventory_VersionedPackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_VersionedPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_VersionedPackage) ProtoMessage() {}

func (x *Inventory_VersionedPackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_VersionedPackage.ProtoReflect.Descriptor instead.
func (*Inventory_VersionedPackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Inventory_VersionedPackage) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *Inventory_VersionedPackage) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *Inventory_VersionedPackage) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Details related to a Zypper Patch.
type Inventory_ZypperPatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the patch.
	PatchName string `protobuf:"bytes,1,opt,name=patch_name,json=patchName,proto3" json:"patch_name,omitempty"`
	// The category of the patch.
	Category string `protobuf:"bytes,2,opt,name=category,proto3" json:"category,omitempty"`
	// The severity specified for this patch
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Any summary information provided about this patch.
	Summary string `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *Inventory_ZypperPatch) Reset() {
	*x = Inventory_ZypperPatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_ZypperPatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_ZypperPatch) ProtoMessage() {}

func (x *Inventory_ZypperPatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_ZypperPatch.ProtoReflect.Descriptor instead.
func (*Inventory_ZypperPatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Inventory_ZypperPatch) GetPatchName() string {
	if x != nil {
		return x.PatchName
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

// Details related to a Windows Update package.
// Field data and names are taken from Windows Update API IUpdate Interface:
// https://docs.microsoft.com/en-us/windows/win32/api/_wua/
// Descriptive fields like title, and description are localized based on
// the locale of the VM being updated.
type Inventory_WindowsUpdatePackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The localized title of the update package.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The localized description of the update package.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The categories that are associated with this update package.
	Categories []*Inventory_WindowsUpdatePackage_WindowsUpdateCategory `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// A collection of Microsoft Knowledge Base article IDs that are associated
	// with the update package.
	KbArticleIds []string `protobuf:"bytes,4,rep,name=kb_article_ids,json=kbArticleIds,proto3" json:"kb_article_ids,omitempty"`
	// A hyperlink to the language-specific support information for the update.
	SupportUrl string `protobuf:"bytes,5,opt,name=support_url,json=supportUrl,proto3" json:"support_url,omitempty"`
	// A collection of URLs that provide more information about the update
	// package.
	MoreInfoUrls []string `protobuf:"bytes,6,rep,name=more_info_urls,json=moreInfoUrls,proto3" json:"more_info_urls,omitempty"`
	// Gets the identifier of an update package.  Stays the same across
	// revisions.
	UpdateId string `protobuf:"bytes,7,opt,name=update_id,json=updateId,proto3" json:"update_id,omitempty"`
	// The revision number of this update package.
	RevisionNumber int32 `protobuf:"varint,8,opt,name=revision_number,json=revisionNumber,proto3" json:"revision_number,omitempty"`
	// The last published date of the update, in (UTC) date and time.
	LastDeploymentChangeTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_deployment_change_time,json=lastDeploymentChangeTime,proto3" json:"last_deployment_change_time,omitempty"`
}

func (x *Inventory_WindowsUpdatePackage) Reset() {
	*x = Inventory_WindowsUpdatePackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_WindowsUpdatePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsUpdatePackage) ProtoMessage() {}

func (x *Inventory_WindowsUpdatePackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsUpdatePackage.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsUpdatePackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Inventory_WindowsUpdatePackage) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetCategories() []*Inventory_WindowsUpdatePackage_WindowsUpdateCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetKbArticleIds() []string {
	if x != nil {
		return x.KbArticleIds
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetSupportUrl() string {
	if x != nil {
		return x.SupportUrl
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetMoreInfoUrls() []string {
	if x != nil {
		return x.MoreInfoUrls
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetUpdateId() string {
	if x != nil {
		return x.UpdateId
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetRevisionNumber() int32 {
	if x != nil {
		return x.RevisionNumber
	}
	return 0
}

func (x *Inventory_WindowsUpdatePackage) GetLastDeploymentChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDeploymentChangeTime
	}
	return nil
}

// Information related to a Quick Fix Engineering package.
// Fields are taken from Windows QuickFixEngineering Interface and match
// the source names:
// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
type Inventory_WindowsQuickFixEngineeringPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short textual description of the QFE update.
	Caption string `protobuf:"bytes,1,opt,name=caption,proto3" json:"caption,omitempty"`
	// A textual description of the QFE update.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Unique identifier associated with a particular QFE update.
	HotFixId string `protobuf:"bytes,3,opt,name=hot_fix_id,json=hotFixId,proto3" json:"hot_fix_id,omitempty"`
	// Date that the QFE update was installed.  Mapped from installed_on field.
	InstallTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=install_time,json=installTime,proto3" json:"install_time,omitempty"`
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) Reset() {
	*x = Inventory_WindowsQuickFixEngineeringPackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsQuickFixEngineeringPackage) ProtoMessage() {}

func (x *Inventory_WindowsQuickFixEngineeringPackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsQuickFixEngineeringPackage.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsQuickFixEngineeringPackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetCaption() string {
	if x != nil {
		return x.Caption
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetHotFixId() string {
	if x != nil {
		return x.HotFixId
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetInstallTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InstallTime
	}
	return nil
}

// Details about Windows Application - based on Windows Registry.
// All fields in this message are taken from:
// https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
type Inventory_WindowsApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DisplayName field from Windows Registry.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// DisplayVersion field from Windows Registry.
	DisplayVersion string `protobuf:"bytes,2,opt,name=display_version,json=displayVersion,proto3" json:"display_version,omitempty"`
	// Publisher field from Windows Registry.
	Publisher string `protobuf:"bytes,3,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Installation date field from Windows Registry.
	InstallDate *date.Date `protobuf:"bytes,4,opt,name=install_date,json=installDate,proto3" json:"install_date,omitempty"`
	// HelpLink field from Windows Registry.
	HelpLink string `protobuf:"bytes,5,opt,name=help_link,json=helpLink,proto3" json:"help_link,omitempty"`
}

func (x *Inventory_WindowsApplication) Reset() {
	*x = Inventory_WindowsApplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_WindowsApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsApplication) ProtoMessage() {}

func (x *Inventory_WindowsApplication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsApplication.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsApplication) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Inventory_WindowsApplication) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetDisplayVersion() string {
	if x != nil {
		return x.DisplayVersion
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetInstallDate() *date.Date {
	if x != nil {
		return x.InstallDate
	}
	return nil
}

func (x *Inventory_WindowsApplication) GetHelpLink() string {
	if x != nil {
		return x.HelpLink
	}
	return ""
}

// Categories specified by the Windows Update.
type Inventory_WindowsUpdatePackage_WindowsUpdateCategory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the windows update category.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the windows update category.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) Reset() {
	*x = Inventory_WindowsUpdatePackage_WindowsUpdateCategory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsUpdatePackage_WindowsUpdateCategory) ProtoMessage() {}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsUpdatePackage_WindowsUpdateCategory.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsUpdatePackage_WindowsUpdateCategory) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_osconfig_agentendpoint_v1_inventory_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x15, 0x0a, 0x09, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x51, 0x0a, 0x07, 0x6f, 0x73, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4f, 0x73, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x6f, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x70, 0x0a, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x12,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x11, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xa2,
	0x02, 0x0a, 0x06, 0x4f, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x34, 0x0a,
	0x16, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x1a, 0xeb, 0x07, 0x0a, 0x0f, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x65, 0x0a, 0x0b, 0x79, 0x75, 0x6d, 0x5f, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x0a, 0x79, 0x75, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x65,
	0x0a, 0x0b, 0x61, 0x70, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x70, 0x74, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x6b, 0x0a, 0x0e, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x48, 0x00, 0x52, 0x0d, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x12, 0x6b, 0x0a, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12,
	0x62, 0x0a, 0x0c, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x0b, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x69, 0x0a, 0x0b, 0x77, 0x75, 0x61, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x0a, 0x77, 0x75, 0x61, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x76,
	0x0a, 0x0b, 0x71, 0x66, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x51, 0x75,
	0x69, 0x63, 0x6b, 0x46, 0x69, 0x78, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x71, 0x66, 0x65, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x65, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48,
	0x00, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x77, 0x0a,
	0x13, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x12, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x1a, 0x73, 0x0a, 0x10, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x7e, 0x0a, 0x0b, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x74, 0x63, 0x68,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x1a, 0x97, 0x04, 0x0a, 0x14, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7c, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x6b, 0x62, 0x5f, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6b,
	0x62, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x24, 0x0a, 0x0e,
	0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x6f, 0x72, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x72,
	0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x1b, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x3b, 0x0a, 0x15, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x1a, 0xbc, 0x01, 0x0a, 0x21, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x51, 0x75, 0x69, 0x63,
	0x6b, 0x46, 0x69, 0x78, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x0a, 0x68, 0x6f, 0x74, 0x5f, 0x66, 0x69, 0x78, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x74, 0x46, 0x69, 0x78, 0x49, 0x64,
	0x12, 0x3d, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x1a,
	0xd1, 0x01, 0x0a, 0x12, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x12, 0x34, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x65, 0x6c, 0x70, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x65, 0x6c, 0x70, 0x4c,
	0x69, 0x6e, 0x6b, 0x42, 0x90, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x42, 0x0e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_goTypes = []interface{}{
	(*Inventory)(nil),                                            // 0: google.cloud.osconfig.agentendpoint.v1.Inventory
	(*Inventory_OsInfo)(nil),                                     // 1: google.cloud.osconfig.agentendpoint.v1.Inventory.OsInfo
	(*Inventory_SoftwarePackage)(nil),                            // 2: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage
	(*Inventory_VersionedPackage)(nil),                           // 3: google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	(*Inventory_ZypperPatch)(nil),                                // 4: google.cloud.osconfig.agentendpoint.v1.Inventory.ZypperPatch
	(*Inventory_WindowsUpdatePackage)(nil),                       // 5: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage
	(*Inventory_WindowsQuickFixEngineeringPackage)(nil),          // 6: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsQuickFixEngineeringPackage
	(*Inventory_WindowsApplication)(nil),                         // 7: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsApplication
	(*Inventory_WindowsUpdatePackage_WindowsUpdateCategory)(nil), // 8: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
	(*timestamppb.Timestamp)(nil),                                // 9: google.protobuf.Timestamp
	(*date.Date)(nil),                                            // 10: google.type.Date
}
var file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_depIdxs = []int32{
	1,  // 0: google.cloud.osconfig.agentendpoint.v1.Inventory.os_info:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.OsInfo
	2,  // 1: google.cloud.osconfig.agentendpoint.v1.Inventory.installed_packages:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage
	2,  // 2: google.cloud.osconfig.agentendpoint.v1.Inventory.available_packages:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage
	3,  // 3: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.yum_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	3,  // 4: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.apt_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	3,  // 5: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.zypper_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	3,  // 6: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.googet_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	4,  // 7: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.zypper_patch:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.ZypperPatch
	5,  // 8: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.wua_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage
	6,  // 9: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.qfe_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsQuickFixEngineeringPackage
	3,  // 10: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.cos_package:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.VersionedPackage
	7,  // 11: google.cloud.osconfig.agentendpoint.v1.Inventory.SoftwarePackage.windows_application:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsApplication
	8,  // 12: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage.categories:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
	9,  // 13: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsUpdatePackage.last_deployment_change_time:type_name -> google.protobuf.Timestamp
	9,  // 14: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsQuickFixEngineeringPackage.install_time:type_name -> google.protobuf.Timestamp
	10, // 15: google.cloud.osconfig.agentendpoint.v1.Inventory.WindowsApplication.install_date:type_name -> google.type.Date
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1_inventory_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_OsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_SoftwarePackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_VersionedPackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_ZypperPatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_WindowsUpdatePackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_WindowsQuickFixEngineeringPackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_WindowsApplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Inventory_WindowsUpdatePackage_WindowsUpdateCategory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Inventory_SoftwarePackage_YumPackage)(nil),
		(*Inventory_SoftwarePackage_AptPackage)(nil),
		(*Inventory_SoftwarePackage_ZypperPackage)(nil),
		(*Inventory_SoftwarePackage_GoogetPackage)(nil),
		(*Inventory_SoftwarePackage_ZypperPatch)(nil),
		(*Inventory_SoftwarePackage_WuaPackage)(nil),
		(*Inventory_SoftwarePackage_QfePackage)(nil),
		(*Inventory_SoftwarePackage_CosPackage)(nil),
		(*Inventory_SoftwarePackage_WindowsApplication)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_depIdxs,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1_inventory_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_depIdxs = nil
}
