<!---======================= begin_copyright_notice ============================

Copyright (C) 2020-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ==========================-->

 

## Opcode

  SAD2ADD = 0x6a

## Format

| | | | | | |
| --- | --- | --- | --- | --- | --- |
| 0x6a(SAD2ADD) | Exec_size | Pred | Dst | Src0 | Src1 | Src2 |


## Semantics




                    for (i = 0; < exec_size; i += 2){
                      if (ChEn[i]) {
                        dst[i] = abs( src0[i] - src1[i] ) + abs ( src0[i+1] - src1[i+1] ) + src2[i];
                        dst[i+1] = undefined;
                      }
                    }

## Description



    Performs a two-wide sum-of-absolute-difference operation on a 2-tuple basis of <src0> and <src1>, add that to src2, and store the scalar result to the first channel per 2-tuple in <dst>.

- **Exec_size(ub):** Execution size
 
  - Bit[2..0]: size of the region for source and destination operands
 
    - 0b000:  1 element (scalar) 
    - 0b001:  2 elements 
    - 0b010:  4 elements 
    - 0b011:  8 elements 
    - 0b100:  16 elements 
    - 0b101:  32 elements 
  - Bit[7..4]: execution mask (explicit control over the enabled channels)
 
    - 0b0000:  M1 
    - 0b0001:  M2 
    - 0b0010:  M3 
    - 0b0011:  M4 
    - 0b0100:  M5 
    - 0b0101:  M6 
    - 0b0110:  M7 
    - 0b0111:  M8 
    - 0b1000:  M1_NM 
    - 0b1001:  M2_NM 
    - 0b1010:  M3_NM 
    - 0b1011:  M4_NM 
    - 0b1100:  M5_NM 
    - 0b1101:  M6_NM 
    - 0b1110:  M7_NM 
    - 0b1111:  M8_NM
- **Pred(uw):** Predication control

- **Dst(vec_operand):** The destination operand. Must have type W,UW. Operand class: general,indirect

- **Src0(vec_operand):** The first source operand. Must have type B,UB. Operand class: general,indirect,immediate

- **Src1(vec_operand):** The second source operand. Must have type B,UB. Operand class: general,indirect,immediate

- **Src2(vec_operand):** The third source operand. Must have type W,UW. Operand class: general,indirect,immediate

#### Properties
- **Saturation:** Yes 


## Text
```
    

		[(<P>)] SAD2ADD[.sat] (<exec_size>) <dst> <src0> <src1> <src2>
```



## Notes


