# RUN: llvm-mc -triple thumbv7 -mattr=virtualization -show-encoding %s | FileCheck %s --check-prefix=CHECK-THUMB

    hvc    #1
    hvc    #7
    hvc    #257
    hvc    #65535
# CHECK-THUMB: [0xe0,0xf7,0x01,0x80]
# CHECK-THUMB: [0xe0,0xf7,0x07,0x80]
# CHECK-THUMB: [0xe0,0xf7,0x01,0x81]
# CHECK-THUMB: [0xef,0xf7,0xff,0x8f]

    hvc.w    #1
    hvc.w    #7
    hvc.w    #257
    hvc.w    #65535
# CHECK-THUMB: [0xe0,0xf7,0x01,0x80]
# CHECK-THUMB: [0xe0,0xf7,0x07,0x80]
# CHECK-THUMB: [0xe0,0xf7,0x01,0x81]
# CHECK-THUMB: [0xef,0xf7,0xff,0x8f]

    eret
    it eq; ereteq
    it ne; eretne
    it hs; ereths
    it lo; eretlo
    it mi; eretmi
    it pl; eretpl
    it vs; eretvs
    it vc; eretvc
    it hi; erethi
    it ls; eretls
    it ge; eretge
    it lt; eretlt
    it gt; eretgt
    it le; eretle
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]

# SUBS PC, LR, #0 should have the same encoding as ERET.
# The conditional forms can't be tested because the ARM assembler parser doesn't
# accept SUBS<cond> PC, LR, #<imm>, only the unconditonal form is allowed. This
# is due to the way that the custom parser handles optional operands; see the
# FIXME in ARM/AsmParser/ARMAsmParser.cpp.

    subs pc, lr, #0
# CHECK-THUMB: [0xde,0xf3,0x00,0x8f]
