// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: LogClient.cpp,v 1.5 2006/07/20 02:30:55 vlg Exp $
//------------------------------------------------------------------------------
//                            LogClient.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed May 21 18:26:28 2003
//
//------------------------------------------------------------------------------
#include <iostream>
#include <fstream>

#include "LogClient-main.h"
#include "LogClient.h"
#include "assa/CommonUtils.h"

enum { LC = ASSA::APP };

// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(LogClient);

LogClient::
LogClient () : 
	m_delay (0),
	m_message_size (0)
{
	add_opt (0, "input-file",   &m_input_file);
	add_opt (0, "delay",        &m_delay);
	add_opt (0, "message-size", &m_message_size);

    // ---Configuration---
    rm_opt ('f', "config-file"  );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );

    /*---
     * By default disable all debugging
     *---*/
    m_mask = LC;
    m_log_file = "log-client.log";
	m_with_log_server="yes";
}

void
LogClient::
init_service ()
{
    trace("LogClient::init_service");
}

void
LogClient::
process_events ()
{
    trace("LogClient::process_events");

    const int size = 256;
    char line [size];
	std::string buffer;
	std::ifstream in_file;
	int delta;

	in_file.open (m_input_file.c_str (), std::ios::in);
	if (!in_file) {
		std::cerr << "Failed to open input file \"" 
				  << m_input_file << "\"\n"
				  << "Option \"--input-file=NAME\" is required\n";
	}
	else {
		while (in_file && service_is_active ()) {
			in_file.getline (line, size, '\n');
			if (m_message_size != 0) {
				buffer += line;
				buffer += "\n";
//				DL((LC,"buffer so far \"%s\"\n", buffer.c_str ()));
//				DL((LC,"buffer.size () = %d, m_message_size = %d\n",
//					buffer.size (), m_message_size));
				if ((delta = buffer.size () - m_message_size) >= 0) {
//					DL((LC,"delta = %d\n", delta));
					if (delta > 0) {
						buffer.erase (m_message_size, delta);
					}
					DL((LC,"%s\n", buffer.c_str ()));
					if (delta > 0) {
//						DL((LC,"Line = \"%s\"\n", line));
//						DL((LC,"Piece that didn't fit: \"%s\"\n",
//							&line [strlen (line) - delta + 1]));
						buffer = &line [strlen (line) - delta + 1];
						buffer += "\n";
					}
					else {
						buffer = "";
					}
//					DL((LC,"buffer = \"%s\"\n", buffer.c_str ()));
				}
			}
			else {
				std::cout << "Sending \"" << line << "\"" << std::endl;
				DL((LC,"%s\n", line));
			}
			if (m_delay) {
				std::cout << m_delay << " sec(s) delay ... " << std::flush;
				ASSA::Utils::sleep_for_seconds (m_delay);
			}
		}
		in_file.close ();
	}
	
    // Shut the service down
    m_reactor.stopReactor ();
}


