package DistLib;

/* data translated from C using perl script translate.pl */
/* script version 0.00                               */


public class noncentral_f 
  { 
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double cumulative(double x, double n1, double n2, double ncp);
     *
     *  DESCRIPTION
     *
     *    The distribution function of the non-central F distribution.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  cumulative(double x, double n1, double n2, double ncp)
    {
        double y;
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(n1) || Double.isNaN(n2) || Double.isNaN(ncp))
    	return x + n2 + n1 + ncp;
    /*!* #endif /*4!*/
        if (n1 <= 0.0 || n2 <= 0.0 || ncp < 0) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        if (x <= 0.0)
    	return 0.0;
        y = (n1 / n2) * x;
        return noncentral_beta.cumulative(y/(1 + y), n1 / 2.0, n2 / 2.0, ncp);
    }
  }
