/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.RelativeDockablePosition;

public class DockableState
implements Comparable {
    private Dockable dockable;
    private Location location;
    private RelativeDockablePosition position;
    private DockingDesktop desktop;

    public DockableState() {
        this.position = new RelativeDockablePosition();
    }

    public DockableState(DockingDesktop desktop, Dockable dockable, Location location) {
        this.desktop = desktop;
        this.dockable = dockable;
        this.location = location;
        this.position = new RelativeDockablePosition();
    }

    public DockableState(DockingDesktop desktop, Dockable dockable, Location location, RelativeDockablePosition position) {
        this.desktop = desktop;
        this.dockable = dockable;
        this.location = location;
        this.position = position;
    }

    public DockableState(DockableState copy, RelativeDockablePosition position) {
        this.desktop = copy.desktop;
        this.dockable = copy.dockable;
        this.location = copy.location;
        this.position = position;
    }

    public int compareTo(Object object) {
        if (object instanceof DockableState) {
            return this.dockable.getDockKey().getName().compareTo(((DockableState)object).dockable.getDockKey().getName());
        }
        return -1;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public boolean isDocked() {
        return this.location == Location.DOCKED;
    }

    public boolean isHidden() {
        return this.location == Location.HIDDEN;
    }

    public boolean isClosed() {
        return this.location == Location.CLOSED;
    }

    public boolean isFloating() {
        return this.location == Location.FLOATING;
    }

    public boolean isMaximized() {
        return this.location == Location.MAXIMIZED;
    }

    public Location getLocation() {
        return this.location;
    }

    public RelativeDockablePosition getPosition() {
        return this.position;
    }

    public String toString() {
        return "DockableState [" + this.dockable.getDockKey() + ", state=" + this.location.name() + ", position=" + this.position;
    }

    public DockingDesktop getDesktop() {
        return this.desktop;
    }

    public void setDesktop(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public static Location getLocationFromInt(int state) {
        switch (state) {
            case 0: {
                return Location.CLOSED;
            }
            case 1: {
                return Location.DOCKED;
            }
            case 2: {
                return Location.HIDDEN;
            }
            case 3: {
                return Location.MAXIMIZED;
            }
            case 4: {
                return Location.FLOATING;
            }
        }
        return null;
    }

    public static enum Location {
        CLOSED,
        DOCKED,
        HIDDEN,
        MAXIMIZED,
        FLOATING;

    }
}

