/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.naming.NamingService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class TurbineNamingService
extends TurbineBaseService
implements NamingService {
    private static Hashtable contextPropsList = null;

    public void init() throws InitializationException {
        try {
            Iterator contextKeys = TurbineResources.getKeys("context.");
            contextPropsList = new Hashtable();
            while (contextKeys.hasNext()) {
                String key = (String)contextKeys.next();
                int start = key.indexOf(".") + 1;
                int end = key.indexOf(".", start);
                String contextName = key.substring(start, end);
                Properties contextProps = null;
                contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
                ((Hashtable)contextProps).put(key.substring(end + 1), TurbineResources.getString(key));
                contextPropsList.put(contextName, contextProps);
            }
            this.setInit(true);
        }
        catch (Exception e) {
            Log.error("Failed to initialize JDNI contexts!", e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    public void init(RunData data) throws InitializationException {
        try {
            if (contextPropsList == null) {
                this.init();
            }
            Enumeration contextPropsKeys = contextPropsList.keys();
            while (contextPropsKeys.hasMoreElements()) {
                String key = (String)contextPropsKeys.nextElement();
                Properties contextProps = (Properties)contextPropsList.get(key);
                InitialContext context = new InitialContext(contextProps);
                data.getJNDIContexts().put(key, context);
            }
        }
        catch (Exception e) {
            Log.error("Failed to initialize JDNI contexts!", e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    public Context getContext(String contextName) {
        Properties contextProps = null;
        contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
        try {
            return new InitialContext(contextProps);
        }
        catch (Exception e) {
            return null;
        }
    }
}

