/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Delivery;
import org.chefproject.core.component.RefreshDelivery;
import org.chefproject.service.generic.GenericCourierService;

public class BasicCourierService
extends TurbineBaseService
implements GenericCourierService {
    protected Map m_addresses = null;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_addresses = new Hashtable();
    }

    public void shutdown() {
        this.m_addresses = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public void deliver(String address, String elementId) {
        this.deliver(new RefreshDelivery(address, elementId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(Delivery delivery) {
        Object object;
        String address;
        Vector<Delivery> deliveries;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".deliver(): " + delivery);
        }
        if ((deliveries = (Vector<Delivery>)this.m_addresses.get(address = delivery.getAddress())) == null) {
            object = this.m_addresses;
            synchronized (object) {
                deliveries = (List)this.m_addresses.get(address);
                if (deliveries == null) {
                    deliveries = new Vector<Delivery>();
                    this.m_addresses.put(address, deliveries);
                }
            }
        }
        object = deliveries;
        synchronized (object) {
            if (!deliveries.contains(delivery)) {
                deliveries.add(delivery);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String address, String elementId) {
        List deliveries;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".clear(): " + address + ", " + elementId);
        }
        if ((deliveries = (List)this.m_addresses.get(address)) == null) {
            return;
        }
        List list = deliveries;
        synchronized (list) {
            Iterator it = deliveries.iterator();
            while (it.hasNext()) {
                Delivery delivery = (Delivery)it.next();
                if (!delivery.getElement().equals(elementId)) continue;
                it.remove();
            }
        }
        if (deliveries.isEmpty()) {
            Map map = this.m_addresses;
            synchronized (map) {
                this.m_addresses.remove(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String address) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".clear(): " + address);
        }
        Map map = this.m_addresses;
        synchronized (map) {
            this.m_addresses.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDeliveries(String address) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".getDeliveries(): " + address);
        }
        Vector deliveries = null;
        Map map = this.m_addresses;
        synchronized (map) {
            deliveries = (Vector)this.m_addresses.get(address);
            if (deliveries != null) {
                this.m_addresses.remove(address);
            }
        }
        if (deliveries == null) {
            deliveries = new Vector();
        }
        Iterator it = deliveries.iterator();
        while (it.hasNext()) {
            Delivery delivery = (Delivery)it.next();
            delivery.act();
        }
        return deliveries;
    }

    public boolean hasDeliveries(String address) {
        List deliveries;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".hasDeliveries(): " + address);
        }
        if ((deliveries = (List)this.m_addresses.get(address)) == null) {
            return false;
        }
        return !deliveries.isEmpty();
    }
}

