﻿#include "lang.h"

/* Based on BIP-39 (unchanged) */

POLYSEED_PRIVATE const polyseed_lang polyseed_lang_fr = {
    .name = u8"français",
    .name_en = "French",
    .separator = " ",
    .is_sorted = true,
    .has_prefix = true,
    .has_accents = true,
    .compose = true,
    .words = {
        u8"abaisser",
        u8"abandon",
        u8"abdiquer",
        u8"abeille",
        u8"abolir",
        u8"aborder",
        u8"aboutir",
        u8"aboyer",
        u8"abrasif",
        u8"abreuver",
        u8"abriter",
        u8"abroger",
        u8"abrupt",
        u8"absence",
        u8"absolu",
        u8"absurde",
        u8"abusif",
        u8"abyssal",
        u8"académie",
        u8"acajou",
        u8"acarien",
        u8"accabler",
        u8"accepter",
        u8"acclamer",
        u8"accolade",
        u8"accroche",
        u8"accuser",
        u8"acerbe",
        u8"achat",
        u8"acheter",
        u8"aciduler",
        u8"acier",
        u8"acompte",
        u8"acquérir",
        u8"acronyme",
        u8"acteur",
        u8"actif",
        u8"actuel",
        u8"adepte",
        u8"adéquat",
        u8"adhésif",
        u8"adjectif",
        u8"adjuger",
        u8"admettre",
        u8"admirer",
        u8"adopter",
        u8"adorer",
        u8"adoucir",
        u8"adresse",
        u8"adroit",
        u8"adulte",
        u8"adverbe",
        u8"aérer",
        u8"aéronef",
        u8"affaire",
        u8"affecter",
        u8"affiche",
        u8"affreux",
        u8"affubler",
        u8"agacer",
        u8"agencer",
        u8"agile",
        u8"agiter",
        u8"agrafer",
        u8"agréable",
        u8"agrume",
        u8"aider",
        u8"aiguille",
        u8"ailier",
        u8"aimable",
        u8"aisance",
        u8"ajouter",
        u8"ajuster",
        u8"alarmer",
        u8"alchimie",
        u8"alerte",
        u8"algèbre",
        u8"algue",
        u8"aliéner",
        u8"aliment",
        u8"alléger",
        u8"alliage",
        u8"allouer",
        u8"allumer",
        u8"alourdir",
        u8"alpaga",
        u8"altesse",
        u8"alvéole",
        u8"amateur",
        u8"ambigu",
        u8"ambre",
        u8"aménager",
        u8"amertume",
        u8"amidon",
        u8"amiral",
        u8"amorcer",
        u8"amour",
        u8"amovible",
        u8"amphibie",
        u8"ampleur",
        u8"amusant",
        u8"analyse",
        u8"anaphore",
        u8"anarchie",
        u8"anatomie",
        u8"ancien",
        u8"anéantir",
        u8"angle",
        u8"angoisse",
        u8"anguleux",
        u8"animal",
        u8"annexer",
        u8"annonce",
        u8"annuel",
        u8"anodin",
        u8"anomalie",
        u8"anonyme",
        u8"anormal",
        u8"antenne",
        u8"antidote",
        u8"anxieux",
        u8"apaiser",
        u8"apéritif",
        u8"aplanir",
        u8"apologie",
        u8"appareil",
        u8"appeler",
        u8"apporter",
        u8"appuyer",
        u8"aquarium",
        u8"aqueduc",
        u8"arbitre",
        u8"arbuste",
        u8"ardeur",
        u8"ardoise",
        u8"argent",
        u8"arlequin",
        u8"armature",
        u8"armement",
        u8"armoire",
        u8"armure",
        u8"arpenter",
        u8"arracher",
        u8"arriver",
        u8"arroser",
        u8"arsenic",
        u8"artériel",
        u8"article",
        u8"aspect",
        u8"asphalte",
        u8"aspirer",
        u8"assaut",
        u8"asservir",
        u8"assiette",
        u8"associer",
        u8"assurer",
        u8"asticot",
        u8"astre",
        u8"astuce",
        u8"atelier",
        u8"atome",
        u8"atrium",
        u8"atroce",
        u8"attaque",
        u8"attentif",
        u8"attirer",
        u8"attraper",
        u8"aubaine",
        u8"auberge",
        u8"audace",
        u8"audible",
        u8"augurer",
        u8"aurore",
        u8"automne",
        u8"autruche",
        u8"avaler",
        u8"avancer",
        u8"avarice",
        u8"avenir",
        u8"averse",
        u8"aveugle",
        u8"aviateur",
        u8"avide",
        u8"avion",
        u8"aviser",
        u8"avoine",
        u8"avouer",
        u8"avril",
        u8"axial",
        u8"axiome",
        u8"badge",
        u8"bafouer",
        u8"bagage",
        u8"baguette",
        u8"baignade",
        u8"balancer",
        u8"balcon",
        u8"baleine",
        u8"balisage",
        u8"bambin",
        u8"bancaire",
        u8"bandage",
        u8"banlieue",
        u8"bannière",
        u8"banquier",
        u8"barbier",
        u8"baril",
        u8"baron",
        u8"barque",
        u8"barrage",
        u8"bassin",
        u8"bastion",
        u8"bataille",
        u8"bateau",
        u8"batterie",
        u8"baudrier",
        u8"bavarder",
        u8"belette",
        u8"bélier",
        u8"belote",
        u8"bénéfice",
        u8"berceau",
        u8"berger",
        u8"berline",
        u8"bermuda",
        u8"besace",
        u8"besogne",
        u8"bétail",
        u8"beurre",
        u8"biberon",
        u8"bicycle",
        u8"bidule",
        u8"bijou",
        u8"bilan",
        u8"bilingue",
        u8"billard",
        u8"binaire",
        u8"biologie",
        u8"biopsie",
        u8"biotype",
        u8"biscuit",
        u8"bison",
        u8"bistouri",
        u8"bitume",
        u8"bizarre",
        u8"blafard",
        u8"blague",
        u8"blanchir",
        u8"blessant",
        u8"blinder",
        u8"blond",
        u8"bloquer",
        u8"blouson",
        u8"bobard",
        u8"bobine",
        u8"boire",
        u8"boiser",
        u8"bolide",
        u8"bonbon",
        u8"bondir",
        u8"bonheur",
        u8"bonifier",
        u8"bonus",
        u8"bordure",
        u8"borne",
        u8"botte",
        u8"boucle",
        u8"boueux",
        u8"bougie",
        u8"boulon",
        u8"bouquin",
        u8"bourse",
        u8"boussole",
        u8"boutique",
        u8"boxeur",
        u8"branche",
        u8"brasier",
        u8"brave",
        u8"brebis",
        u8"brèche",
        u8"breuvage",
        u8"bricoler",
        u8"brigade",
        u8"brillant",
        u8"brioche",
        u8"brique",
        u8"brochure",
        u8"broder",
        u8"bronzer",
        u8"brousse",
        u8"broyeur",
        u8"brume",
        u8"brusque",
        u8"brutal",
        u8"bruyant",
        u8"buffle",
        u8"buisson",
        u8"bulletin",
        u8"bureau",
        u8"burin",
        u8"bustier",
        u8"butiner",
        u8"butoir",
        u8"buvable",
        u8"buvette",
        u8"cabanon",
        u8"cabine",
        u8"cachette",
        u8"cadeau",
        u8"cadre",
        u8"caféine",
        u8"caillou",
        u8"caisson",
        u8"calculer",
        u8"calepin",
        u8"calibre",
        u8"calmer",
        u8"calomnie",
        u8"calvaire",
        u8"camarade",
        u8"caméra",
        u8"camion",
        u8"campagne",
        u8"canal",
        u8"caneton",
        u8"canon",
        u8"cantine",
        u8"canular",
        u8"capable",
        u8"caporal",
        u8"caprice",
        u8"capsule",
        u8"capter",
        u8"capuche",
        u8"carabine",
        u8"carbone",
        u8"caresser",
        u8"caribou",
        u8"carnage",
        u8"carotte",
        u8"carreau",
        u8"carton",
        u8"cascade",
        u8"casier",
        u8"casque",
        u8"cassure",
        u8"causer",
        u8"caution",
        u8"cavalier",
        u8"caverne",
        u8"caviar",
        u8"cédille",
        u8"ceinture",
        u8"céleste",
        u8"cellule",
        u8"cendrier",
        u8"censurer",
        u8"central",
        u8"cercle",
        u8"cérébral",
        u8"cerise",
        u8"cerner",
        u8"cerveau",
        u8"cesser",
        u8"chagrin",
        u8"chaise",
        u8"chaleur",
        u8"chambre",
        u8"chance",
        u8"chapitre",
        u8"charbon",
        u8"chasseur",
        u8"chaton",
        u8"chausson",
        u8"chavirer",
        u8"chemise",
        u8"chenille",
        u8"chéquier",
        u8"chercher",
        u8"cheval",
        u8"chien",
        u8"chiffre",
        u8"chignon",
        u8"chimère",
        u8"chiot",
        u8"chlorure",
        u8"chocolat",
        u8"choisir",
        u8"chose",
        u8"chouette",
        u8"chrome",
        u8"chute",
        u8"cigare",
        u8"cigogne",
        u8"cimenter",
        u8"cinéma",
        u8"cintrer",
        u8"circuler",
        u8"cirer",
        u8"cirque",
        u8"citerne",
        u8"citoyen",
        u8"citron",
        u8"civil",
        u8"clairon",
        u8"clameur",
        u8"claquer",
        u8"classe",
        u8"clavier",
        u8"client",
        u8"cligner",
        u8"climat",
        u8"clivage",
        u8"cloche",
        u8"clonage",
        u8"cloporte",
        u8"cobalt",
        u8"cobra",
        u8"cocasse",
        u8"cocotier",
        u8"coder",
        u8"codifier",
        u8"coffre",
        u8"cogner",
        u8"cohésion",
        u8"coiffer",
        u8"coincer",
        u8"colère",
        u8"colibri",
        u8"colline",
        u8"colmater",
        u8"colonel",
        u8"combat",
        u8"comédie",
        u8"commande",
        u8"compact",
        u8"concert",
        u8"conduire",
        u8"confier",
        u8"congeler",
        u8"connoter",
        u8"consonne",
        u8"contact",
        u8"convexe",
        u8"copain",
        u8"copie",
        u8"corail",
        u8"corbeau",
        u8"cordage",
        u8"corniche",
        u8"corpus",
        u8"correct",
        u8"cortège",
        u8"cosmique",
        u8"costume",
        u8"coton",
        u8"coude",
        u8"coupure",
        u8"courage",
        u8"couteau",
        u8"couvrir",
        u8"coyote",
        u8"crabe",
        u8"crainte",
        u8"cravate",
        u8"crayon",
        u8"créature",
        u8"créditer",
        u8"crémeux",
        u8"creuser",
        u8"crevette",
        u8"cribler",
        u8"crier",
        u8"cristal",
        u8"critère",
        u8"croire",
        u8"croquer",
        u8"crotale",
        u8"crucial",
        u8"cruel",
        u8"crypter",
        u8"cubique",
        u8"cueillir",
        u8"cuillère",
        u8"cuisine",
        u8"cuivre",
        u8"culminer",
        u8"cultiver",
        u8"cumuler",
        u8"cupide",
        u8"curatif",
        u8"curseur",
        u8"cyanure",
        u8"cycle",
        u8"cylindre",
        u8"cynique",
        u8"daigner",
        u8"damier",
        u8"danger",
        u8"danseur",
        u8"dauphin",
        u8"débattre",
        u8"débiter",
        u8"déborder",
        u8"débrider",
        u8"débutant",
        u8"décaler",
        u8"décembre",
        u8"déchirer",
        u8"décider",
        u8"déclarer",
        u8"décorer",
        u8"décrire",
        u8"décupler",
        u8"dédale",
        u8"déductif",
        u8"déesse",
        u8"défensif",
        u8"défiler",
        u8"défrayer",
        u8"dégager",
        u8"dégivrer",
        u8"déglutir",
        u8"dégrafer",
        u8"déjeuner",
        u8"délice",
        u8"déloger",
        u8"demander",
        u8"demeurer",
        u8"démolir",
        u8"dénicher",
        u8"dénouer",
        u8"dentelle",
        u8"dénuder",
        u8"départ",
        u8"dépenser",
        u8"déphaser",
        u8"déplacer",
        u8"déposer",
        u8"déranger",
        u8"dérober",
        u8"désastre",
        u8"descente",
        u8"désert",
        u8"désigner",
        u8"désobéir",
        u8"dessiner",
        u8"destrier",
        u8"détacher",
        u8"détester",
        u8"détourer",
        u8"détresse",
        u8"devancer",
        u8"devenir",
        u8"deviner",
        u8"devoir",
        u8"diable",
        u8"dialogue",
        u8"diamant",
        u8"dicter",
        u8"différer",
        u8"digérer",
        u8"digital",
        u8"digne",
        u8"diluer",
        u8"dimanche",
        u8"diminuer",
        u8"dioxyde",
        u8"directif",
        u8"diriger",
        u8"discuter",
        u8"disposer",
        u8"dissiper",
        u8"distance",
        u8"divertir",
        u8"diviser",
        u8"docile",
        u8"docteur",
        u8"dogme",
        u8"doigt",
        u8"domaine",
        u8"domicile",
        u8"dompter",
        u8"donateur",
        u8"donjon",
        u8"donner",
        u8"dopamine",
        u8"dortoir",
        u8"dorure",
        u8"dosage",
        u8"doseur",
        u8"dossier",
        u8"dotation",
        u8"douanier",
        u8"double",
        u8"douceur",
        u8"douter",
        u8"doyen",
        u8"dragon",
        u8"draper",
        u8"dresser",
        u8"dribbler",
        u8"droiture",
        u8"duperie",
        u8"duplexe",
        u8"durable",
        u8"durcir",
        u8"dynastie",
        u8"éblouir",
        u8"écarter",
        u8"écharpe",
        u8"échelle",
        u8"éclairer",
        u8"éclipse",
        u8"éclore",
        u8"écluse",
        u8"école",
        u8"économie",
        u8"écorce",
        u8"écouter",
        u8"écraser",
        u8"écrémer",
        u8"écrivain",
        u8"écrou",
        u8"écume",
        u8"écureuil",
        u8"édifier",
        u8"éduquer",
        u8"effacer",
        u8"effectif",
        u8"effigie",
        u8"effort",
        u8"effrayer",
        u8"effusion",
        u8"égaliser",
        u8"égarer",
        u8"éjecter",
        u8"élaborer",
        u8"élargir",
        u8"électron",
        u8"élégant",
        u8"éléphant",
        u8"élève",
        u8"éligible",
        u8"élitisme",
        u8"éloge",
        u8"élucider",
        u8"éluder",
        u8"emballer",
        u8"embellir",
        u8"embryon",
        u8"émeraude",
        u8"émission",
        u8"emmener",
        u8"émotion",
        u8"émouvoir",
        u8"empereur",
        u8"employer",
        u8"emporter",
        u8"emprise",
        u8"émulsion",
        u8"encadrer",
        u8"enchère",
        u8"enclave",
        u8"encoche",
        u8"endiguer",
        u8"endosser",
        u8"endroit",
        u8"enduire",
        u8"énergie",
        u8"enfance",
        u8"enfermer",
        u8"enfouir",
        u8"engager",
        u8"engin",
        u8"englober",
        u8"énigme",
        u8"enjamber",
        u8"enjeu",
        u8"enlever",
        u8"ennemi",
        u8"ennuyeux",
        u8"enrichir",
        u8"enrobage",
        u8"enseigne",
        u8"entasser",
        u8"entendre",
        u8"entier",
        u8"entourer",
        u8"entraver",
        u8"énumérer",
        u8"envahir",
        u8"enviable",
        u8"envoyer",
        u8"enzyme",
        u8"éolien",
        u8"épaissir",
        u8"épargne",
        u8"épatant",
        u8"épaule",
        u8"épicerie",
        u8"épidémie",
        u8"épier",
        u8"épilogue",
        u8"épine",
        u8"épisode",
        u8"épitaphe",
        u8"époque",
        u8"épreuve",
        u8"éprouver",
        u8"épuisant",
        u8"équerre",
        u8"équipe",
        u8"ériger",
        u8"érosion",
        u8"erreur",
        u8"éruption",
        u8"escalier",
        u8"espadon",
        u8"espèce",
        u8"espiègle",
        u8"espoir",
        u8"esprit",
        u8"esquiver",
        u8"essayer",
        u8"essence",
        u8"essieu",
        u8"essorer",
        u8"estime",
        u8"estomac",
        u8"estrade",
        u8"étagère",
        u8"étaler",
        u8"étanche",
        u8"étatique",
        u8"éteindre",
        u8"étendoir",
        u8"éternel",
        u8"éthanol",
        u8"éthique",
        u8"ethnie",
        u8"étirer",
        u8"étoffer",
        u8"étoile",
        u8"étonnant",
        u8"étourdir",
        u8"étrange",
        u8"étroit",
        u8"étude",
        u8"euphorie",
        u8"évaluer",
        u8"évasion",
        u8"éventail",
        u8"évidence",
        u8"éviter",
        u8"évolutif",
        u8"évoquer",
        u8"exact",
        u8"exagérer",
        u8"exaucer",
        u8"exceller",
        u8"excitant",
        u8"exclusif",
        u8"excuse",
        u8"exécuter",
        u8"exemple",
        u8"exercer",
        u8"exhaler",
        u8"exhorter",
        u8"exigence",
        u8"exiler",
        u8"exister",
        u8"exotique",
        u8"expédier",
        u8"explorer",
        u8"exposer",
        u8"exprimer",
        u8"exquis",
        u8"extensif",
        u8"extraire",
        u8"exulter",
        u8"fable",
        u8"fabuleux",
        u8"facette",
        u8"facile",
        u8"facture",
        u8"faiblir",
        u8"falaise",
        u8"fameux",
        u8"famille",
        u8"farceur",
        u8"farfelu",
        u8"farine",
        u8"farouche",
        u8"fasciner",
        u8"fatal",
        u8"fatigue",
        u8"faucon",
        u8"fautif",
        u8"faveur",
        u8"favori",
        u8"fébrile",
        u8"féconder",
        u8"fédérer",
        u8"félin",
        u8"femme",
        u8"fémur",
        u8"fendoir",
        u8"féodal",
        u8"fermer",
        u8"féroce",
        u8"ferveur",
        u8"festival",
        u8"feuille",
        u8"feutre",
        u8"février",
        u8"fiasco",
        u8"ficeler",
        u8"fictif",
        u8"fidèle",
        u8"figure",
        u8"filature",
        u8"filetage",
        u8"filière",
        u8"filleul",
        u8"filmer",
        u8"filou",
        u8"filtrer",
        u8"financer",
        u8"finir",
        u8"fiole",
        u8"firme",
        u8"fissure",
        u8"fixer",
        u8"flairer",
        u8"flamme",
        u8"flasque",
        u8"flatteur",
        u8"fléau",
        u8"flèche",
        u8"fleur",
        u8"flexion",
        u8"flocon",
        u8"flore",
        u8"fluctuer",
        u8"fluide",
        u8"fluvial",
        u8"folie",
        u8"fonderie",
        u8"fongible",
        u8"fontaine",
        u8"forcer",
        u8"forgeron",
        u8"formuler",
        u8"fortune",
        u8"fossile",
        u8"foudre",
        u8"fougère",
        u8"fouiller",
        u8"foulure",
        u8"fourmi",
        u8"fragile",
        u8"fraise",
        u8"franchir",
        u8"frapper",
        u8"frayeur",
        u8"frégate",
        u8"freiner",
        u8"frelon",
        u8"frémir",
        u8"frénésie",
        u8"frère",
        u8"friable",
        u8"friction",
        u8"frisson",
        u8"frivole",
        u8"froid",
        u8"fromage",
        u8"frontal",
        u8"frotter",
        u8"fruit",
        u8"fugitif",
        u8"fuite",
        u8"fureur",
        u8"furieux",
        u8"furtif",
        u8"fusion",
        u8"futur",
        u8"gagner",
        u8"galaxie",
        u8"galerie",
        u8"gambader",
        u8"garantir",
        u8"gardien",
        u8"garnir",
        u8"garrigue",
        u8"gazelle",
        u8"gazon",
        u8"géant",
        u8"gélatine",
        u8"gélule",
        u8"gendarme",
        u8"général",
        u8"génie",
        u8"genou",
        u8"gentil",
        u8"géologie",
        u8"géomètre",
        u8"géranium",
        u8"germe",
        u8"gestuel",
        u8"geyser",
        u8"gibier",
        u8"gicler",
        u8"girafe",
        u8"givre",
        u8"glace",
        u8"glaive",
        u8"glisser",
        u8"globe",
        u8"gloire",
        u8"glorieux",
        u8"golfeur",
        u8"gomme",
        u8"gonfler",
        u8"gorge",
        u8"gorille",
        u8"goudron",
        u8"gouffre",
        u8"goulot",
        u8"goupille",
        u8"gourmand",
        u8"goutte",
        u8"graduel",
        u8"graffiti",
        u8"graine",
        u8"grand",
        u8"grappin",
        u8"gratuit",
        u8"gravir",
        u8"grenat",
        u8"griffure",
        u8"griller",
        u8"grimper",
        u8"grogner",
        u8"gronder",
        u8"grotte",
        u8"groupe",
        u8"gruger",
        u8"grutier",
        u8"gruyère",
        u8"guépard",
        u8"guerrier",
        u8"guide",
        u8"guimauve",
        u8"guitare",
        u8"gustatif",
        u8"gymnaste",
        u8"gyrostat",
        u8"habitude",
        u8"hachoir",
        u8"halte",
        u8"hameau",
        u8"hangar",
        u8"hanneton",
        u8"haricot",
        u8"harmonie",
        u8"harpon",
        u8"hasard",
        u8"hélium",
        u8"hématome",
        u8"herbe",
        u8"hérisson",
        u8"hermine",
        u8"héron",
        u8"hésiter",
        u8"heureux",
        u8"hiberner",
        u8"hibou",
        u8"hilarant",
        u8"histoire",
        u8"hiver",
        u8"homard",
        u8"hommage",
        u8"homogène",
        u8"honneur",
        u8"honorer",
        u8"honteux",
        u8"horde",
        u8"horizon",
        u8"horloge",
        u8"hormone",
        u8"horrible",
        u8"houleux",
        u8"housse",
        u8"hublot",
        u8"huileux",
        u8"humain",
        u8"humble",
        u8"humide",
        u8"humour",
        u8"hurler",
        u8"hydromel",
        u8"hygiène",
        u8"hymne",
        u8"hypnose",
        u8"idylle",
        u8"ignorer",
        u8"iguane",
        u8"illicite",
        u8"illusion",
        u8"image",
        u8"imbiber",
        u8"imiter",
        u8"immense",
        u8"immobile",
        u8"immuable",
        u8"impact",
        u8"impérial",
        u8"implorer",
        u8"imposer",
        u8"imprimer",
        u8"imputer",
        u8"incarner",
        u8"incendie",
        u8"incident",
        u8"incliner",
        u8"incolore",
        u8"indexer",
        u8"indice",
        u8"inductif",
        u8"inédit",
        u8"ineptie",
        u8"inexact",
        u8"infini",
        u8"infliger",
        u8"informer",
        u8"infusion",
        u8"ingérer",
        u8"inhaler",
        u8"inhiber",
        u8"injecter",
        u8"injure",
        u8"innocent",
        u8"inoculer",
        u8"inonder",
        u8"inscrire",
        u8"insecte",
        u8"insigne",
        u8"insolite",
        u8"inspirer",
        u8"instinct",
        u8"insulter",
        u8"intact",
        u8"intense",
        u8"intime",
        u8"intrigue",
        u8"intuitif",
        u8"inutile",
        u8"invasion",
        u8"inventer",
        u8"inviter",
        u8"invoquer",
        u8"ironique",
        u8"irradier",
        u8"irréel",
        u8"irriter",
        u8"isoler",
        u8"ivoire",
        u8"ivresse",
        u8"jaguar",
        u8"jaillir",
        u8"jambe",
        u8"janvier",
        u8"jardin",
        u8"jauger",
        u8"jaune",
        u8"javelot",
        u8"jetable",
        u8"jeton",
        u8"jeudi",
        u8"jeunesse",
        u8"joindre",
        u8"joncher",
        u8"jongler",
        u8"joueur",
        u8"jouissif",
        u8"journal",
        u8"jovial",
        u8"joyau",
        u8"joyeux",
        u8"jubiler",
        u8"jugement",
        u8"junior",
        u8"jupon",
        u8"juriste",
        u8"justice",
        u8"juteux",
        u8"juvénile",
        u8"kayak",
        u8"kimono",
        u8"kiosque",
        u8"label",
        u8"labial",
        u8"labourer",
        u8"lacérer",
        u8"lactose",
        u8"lagune",
        u8"laine",
        u8"laisser",
        u8"laitier",
        u8"lambeau",
        u8"lamelle",
        u8"lampe",
        u8"lanceur",
        u8"langage",
        u8"lanterne",
        u8"lapin",
        u8"largeur",
        u8"larme",
        u8"laurier",
        u8"lavabo",
        u8"lavoir",
        u8"lecture",
        u8"légal",
        u8"léger",
        u8"légume",
        u8"lessive",
        u8"lettre",
        u8"levier",
        u8"lexique",
        u8"lézard",
        u8"liasse",
        u8"libérer",
        u8"libre",
        u8"licence",
        u8"licorne",
        u8"liège",
        u8"lièvre",
        u8"ligature",
        u8"ligoter",
        u8"ligue",
        u8"limer",
        u8"limite",
        u8"limonade",
        u8"limpide",
        u8"linéaire",
        u8"lingot",
        u8"lionceau",
        u8"liquide",
        u8"lisière",
        u8"lister",
        u8"lithium",
        u8"litige",
        u8"littoral",
        u8"livreur",
        u8"logique",
        u8"lointain",
        u8"loisir",
        u8"lombric",
        u8"loterie",
        u8"louer",
        u8"lourd",
        u8"loutre",
        u8"louve",
        u8"loyal",
        u8"lubie",
        u8"lucide",
        u8"lucratif",
        u8"lueur",
        u8"lugubre",
        u8"luisant",
        u8"lumière",
        u8"lunaire",
        u8"lundi",
        u8"luron",
        u8"lutter",
        u8"luxueux",
        u8"machine",
        u8"magasin",
        u8"magenta",
        u8"magique",
        u8"maigre",
        u8"maillon",
        u8"maintien",
        u8"mairie",
        u8"maison",
        u8"majorer",
        u8"malaxer",
        u8"maléfice",
        u8"malheur",
        u8"malice",
        u8"mallette",
        u8"mammouth",
        u8"mandater",
        u8"maniable",
        u8"manquant",
        u8"manteau",
        u8"manuel",
        u8"marathon",
        u8"marbre",
        u8"marchand",
        u8"mardi",
        u8"maritime",
        u8"marqueur",
        u8"marron",
        u8"marteler",
        u8"mascotte",
        u8"massif",
        u8"matériel",
        u8"matière",
        u8"matraque",
        u8"maudire",
        u8"maussade",
        u8"mauve",
        u8"maximal",
        u8"méchant",
        u8"méconnu",
        u8"médaille",
        u8"médecin",
        u8"méditer",
        u8"méduse",
        u8"meilleur",
        u8"mélange",
        u8"mélodie",
        u8"membre",
        u8"mémoire",
        u8"menacer",
        u8"mener",
        u8"menhir",
        u8"mensonge",
        u8"mentor",
        u8"mercredi",
        u8"mérite",
        u8"merle",
        u8"messager",
        u8"mesure",
        u8"métal",
        u8"météore",
        u8"méthode",
        u8"métier",
        u8"meuble",
        u8"miauler",
        u8"microbe",
        u8"miette",
        u8"mignon",
        u8"migrer",
        u8"milieu",
        u8"million",
        u8"mimique",
        u8"mince",
        u8"minéral",
        u8"minimal",
        u8"minorer",
        u8"minute",
        u8"miracle",
        u8"miroiter",
        u8"missile",
        u8"mixte",
        u8"mobile",
        u8"moderne",
        u8"moelleux",
        u8"mondial",
        u8"moniteur",
        u8"monnaie",
        u8"monotone",
        u8"monstre",
        u8"montagne",
        u8"monument",
        u8"moqueur",
        u8"morceau",
        u8"morsure",
        u8"mortier",
        u8"moteur",
        u8"motif",
        u8"mouche",
        u8"moufle",
        u8"moulin",
        u8"mousson",
        u8"mouton",
        u8"mouvant",
        u8"multiple",
        u8"munition",
        u8"muraille",
        u8"murène",
        u8"murmure",
        u8"muscle",
        u8"muséum",
        u8"musicien",
        u8"mutation",
        u8"muter",
        u8"mutuel",
        u8"myriade",
        u8"myrtille",
        u8"mystère",
        u8"mythique",
        u8"nageur",
        u8"nappe",
        u8"narquois",
        u8"narrer",
        u8"natation",
        u8"nation",
        u8"nature",
        u8"naufrage",
        u8"nautique",
        u8"navire",
        u8"nébuleux",
        u8"nectar",
        u8"néfaste",
        u8"négation",
        u8"négliger",
        u8"négocier",
        u8"neige",
        u8"nerveux",
        u8"nettoyer",
        u8"neurone",
        u8"neutron",
        u8"neveu",
        u8"niche",
        u8"nickel",
        u8"nitrate",
        u8"niveau",
        u8"noble",
        u8"nocif",
        u8"nocturne",
        u8"noirceur",
        u8"noisette",
        u8"nomade",
        u8"nombreux",
        u8"nommer",
        u8"normatif",
        u8"notable",
        u8"notifier",
        u8"notoire",
        u8"nourrir",
        u8"nouveau",
        u8"novateur",
        u8"novembre",
        u8"novice",
        u8"nuage",
        u8"nuancer",
        u8"nuire",
        u8"nuisible",
        u8"numéro",
        u8"nuptial",
        u8"nuque",
        u8"nutritif",
        u8"obéir",
        u8"objectif",
        u8"obliger",
        u8"obscur",
        u8"observer",
        u8"obstacle",
        u8"obtenir",
        u8"obturer",
        u8"occasion",
        u8"occuper",
        u8"océan",
        u8"octobre",
        u8"octroyer",
        u8"octupler",
        u8"oculaire",
        u8"odeur",
        u8"odorant",
        u8"offenser",
        u8"officier",
        u8"offrir",
        u8"ogive",
        u8"oiseau",
        u8"oisillon",
        u8"olfactif",
        u8"olivier",
        u8"ombrage",
        u8"omettre",
        u8"onctueux",
        u8"onduler",
        u8"onéreux",
        u8"onirique",
        u8"opale",
        u8"opaque",
        u8"opérer",
        u8"opinion",
        u8"opportun",
        u8"opprimer",
        u8"opter",
        u8"optique",
        u8"orageux",
        u8"orange",
        u8"orbite",
        u8"ordonner",
        u8"oreille",
        u8"organe",
        u8"orgueil",
        u8"orifice",
        u8"ornement",
        u8"orque",
        u8"ortie",
        u8"osciller",
        u8"osmose",
        u8"ossature",
        u8"otarie",
        u8"ouragan",
        u8"ourson",
        u8"outil",
        u8"outrager",
        u8"ouvrage",
        u8"ovation",
        u8"oxyde",
        u8"oxygène",
        u8"ozone",
        u8"paisible",
        u8"palace",
        u8"palmarès",
        u8"palourde",
        u8"palper",
        u8"panache",
        u8"panda",
        u8"pangolin",
        u8"paniquer",
        u8"panneau",
        u8"panorama",
        u8"pantalon",
        u8"papaye",
        u8"papier",
        u8"papoter",
        u8"papyrus",
        u8"paradoxe",
        u8"parcelle",
        u8"paresse",
        u8"parfumer",
        u8"parler",
        u8"parole",
        u8"parrain",
        u8"parsemer",
        u8"partager",
        u8"parure",
        u8"parvenir",
        u8"passion",
        u8"pastèque",
        u8"paternel",
        u8"patience",
        u8"patron",
        u8"pavillon",
        u8"pavoiser",
        u8"payer",
        u8"paysage",
        u8"peigne",
        u8"peintre",
        u8"pelage",
        u8"pélican",
        u8"pelle",
        u8"pelouse",
        u8"peluche",
        u8"pendule",
        u8"pénétrer",
        u8"pénible",
        u8"pensif",
        u8"pénurie",
        u8"pépite",
        u8"péplum",
        u8"perdrix",
        u8"perforer",
        u8"période",
        u8"permuter",
        u8"perplexe",
        u8"persil",
        u8"perte",
        u8"peser",
        u8"pétale",
        u8"petit",
        u8"pétrir",
        u8"peuple",
        u8"pharaon",
        u8"phobie",
        u8"phoque",
        u8"photon",
        u8"phrase",
        u8"physique",
        u8"piano",
        u8"pictural",
        u8"pièce",
        u8"pierre",
        u8"pieuvre",
        u8"pilote",
        u8"pinceau",
        u8"pipette",
        u8"piquer",
        u8"pirogue",
        u8"piscine",
        u8"piston",
        u8"pivoter",
        u8"pixel",
        u8"pizza",
        u8"placard",
        u8"plafond",
        u8"plaisir",
        u8"planer",
        u8"plaque",
        u8"plastron",
        u8"plateau",
        u8"pleurer",
        u8"plexus",
        u8"pliage",
        u8"plomb",
        u8"plonger",
        u8"pluie",
        u8"plumage",
        u8"pochette",
        u8"poésie",
        u8"poète",
        u8"pointe",
        u8"poirier",
        u8"poisson",
        u8"poivre",
        u8"polaire",
        u8"policier",
        u8"pollen",
        u8"polygone",
        u8"pommade",
        u8"pompier",
        u8"ponctuel",
        u8"pondérer",
        u8"poney",
        u8"portique",
        u8"position",
        u8"posséder",
        u8"posture",
        u8"potager",
        u8"poteau",
        u8"potion",
        u8"pouce",
        u8"poulain",
        u8"poumon",
        u8"pourpre",
        u8"poussin",
        u8"pouvoir",
        u8"prairie",
        u8"pratique",
        u8"précieux",
        u8"prédire",
        u8"préfixe",
        u8"prélude",
        u8"prénom",
        u8"présence",
        u8"prétexte",
        u8"prévoir",
        u8"primitif",
        u8"prince",
        u8"prison",
        u8"priver",
        u8"problème",
        u8"procéder",
        u8"prodige",
        u8"profond",
        u8"progrès",
        u8"proie",
        u8"projeter",
        u8"prologue",
        u8"promener",
        u8"propre",
        u8"prospère",
        u8"protéger",
        u8"prouesse",
        u8"proverbe",
        u8"prudence",
        u8"pruneau",
        u8"psychose",
        u8"public",
        u8"puceron",
        u8"puiser",
        u8"pulpe",
        u8"pulsar",
        u8"punaise",
        u8"punitif",
        u8"pupitre",
        u8"purifier",
        u8"puzzle",
        u8"pyramide",
        u8"quasar",
        u8"querelle",
        u8"question",
        u8"quiétude",
        u8"quitter",
        u8"quotient",
        u8"racine",
        u8"raconter",
        u8"radieux",
        u8"ragondin",
        u8"raideur",
        u8"raisin",
        u8"ralentir",
        u8"rallonge",
        u8"ramasser",
        u8"rapide",
        u8"rasage",
        u8"ratisser",
        u8"ravager",
        u8"ravin",
        u8"rayonner",
        u8"réactif",
        u8"réagir",
        u8"réaliser",
        u8"réanimer",
        u8"recevoir",
        u8"réciter",
        u8"réclamer",
        u8"récolter",
        u8"recruter",
        u8"reculer",
        u8"recycler",
        u8"rédiger",
        u8"redouter",
        u8"refaire",
        u8"réflexe",
        u8"réformer",
        u8"refrain",
        u8"refuge",
        u8"régalien",
        u8"région",
        u8"réglage",
        u8"régulier",
        u8"réitérer",
        u8"rejeter",
        u8"rejouer",
        u8"relatif",
        u8"relever",
        u8"relief",
        u8"remarque",
        u8"remède",
        u8"remise",
        u8"remonter",
        u8"remplir",
        u8"remuer",
        u8"renard",
        u8"renfort",
        u8"renifler",
        u8"renoncer",
        u8"rentrer",
        u8"renvoi",
        u8"replier",
        u8"reporter",
        u8"reprise",
        u8"reptile",
        u8"requin",
        u8"réserve",
        u8"résineux",
        u8"résoudre",
        u8"respect",
        u8"rester",
        u8"résultat",
        u8"rétablir",
        u8"retenir",
        u8"réticule",
        u8"retomber",
        u8"retracer",
        u8"réunion",
        u8"réussir",
        u8"revanche",
        u8"revivre",
        u8"révolte",
        u8"révulsif",
        u8"richesse",
        u8"rideau",
        u8"rieur",
        u8"rigide",
        u8"rigoler",
        u8"rincer",
        u8"riposter",
        u8"risible",
        u8"risque",
        u8"rituel",
        u8"rival",
        u8"rivière",
        u8"rocheux",
        u8"romance",
        u8"rompre",
        u8"ronce",
        u8"rondin",
        u8"roseau",
        u8"rosier",
        u8"rotatif",
        u8"rotor",
        u8"rotule",
        u8"rouge",
        u8"rouille",
        u8"rouleau",
        u8"routine",
        u8"royaume",
        u8"ruban",
        u8"rubis",
        u8"ruche",
        u8"ruelle",
        u8"rugueux",
        u8"ruiner",
        u8"ruisseau",
        u8"ruser",
        u8"rustique",
        u8"rythme",
        u8"sabler",
        u8"saboter",
        u8"sabre",
        u8"sacoche",
        u8"safari",
        u8"sagesse",
        u8"saisir",
        u8"salade",
        u8"salive",
        u8"salon",
        u8"saluer",
        u8"samedi",
        u8"sanction",
        u8"sanglier",
        u8"sarcasme",
        u8"sardine",
        u8"saturer",
        u8"saugrenu",
        u8"saumon",
        u8"sauter",
        u8"sauvage",
        u8"savant",
        u8"savonner",
        u8"scalpel",
        u8"scandale",
        u8"scélérat",
        u8"scénario",
        u8"sceptre",
        u8"schéma",
        u8"science",
        u8"scinder",
        u8"score",
        u8"scrutin",
        u8"sculpter",
        u8"séance",
        u8"sécable",
        u8"sécher",
        u8"secouer",
        u8"sécréter",
        u8"sédatif",
        u8"séduire",
        u8"seigneur",
        u8"séjour",
        u8"sélectif",
        u8"semaine",
        u8"sembler",
        u8"semence",
        u8"séminal",
        u8"sénateur",
        u8"sensible",
        u8"sentence",
        u8"séparer",
        u8"séquence",
        u8"serein",
        u8"sergent",
        u8"sérieux",
        u8"serrure",
        u8"sérum",
        u8"service",
        u8"sésame",
        u8"sévir",
        u8"sevrage",
        u8"sextuple",
        u8"sidéral",
        u8"siècle",
        u8"siéger",
        u8"siffler",
        u8"sigle",
        u8"signal",
        u8"silence",
        u8"silicium",
        u8"simple",
        u8"sincère",
        u8"sinistre",
        u8"siphon",
        u8"sirop",
        u8"sismique",
        u8"situer",
        u8"skier",
        u8"social",
        u8"socle",
        u8"sodium",
        u8"soigneux",
        u8"soldat",
        u8"soleil",
        u8"solitude",
        u8"soluble",
        u8"sombre",
        u8"sommeil",
        u8"somnoler",
        u8"sonde",
        u8"songeur",
        u8"sonnette",
        u8"sonore",
        u8"sorcier",
        u8"sortir",
        u8"sosie",
        u8"sottise",
        u8"soucieux",
        u8"soudure",
        u8"souffle",
        u8"soulever",
        u8"soupape",
        u8"source",
        u8"soutirer",
        u8"souvenir",
        u8"spacieux",
        u8"spatial",
        u8"spécial",
        u8"sphère",
        u8"spiral",
        u8"stable",
        u8"station",
        u8"sternum",
        u8"stimulus",
        u8"stipuler",
        u8"strict",
        u8"studieux",
        u8"stupeur",
        u8"styliste",
        u8"sublime",
        u8"substrat",
        u8"subtil",
        u8"subvenir",
        u8"succès",
        u8"sucre",
        u8"suffixe",
        u8"suggérer",
        u8"suiveur",
        u8"sulfate",
        u8"superbe",
        u8"supplier",
        u8"surface",
        u8"suricate",
        u8"surmener",
        u8"surprise",
        u8"sursaut",
        u8"survie",
        u8"suspect",
        u8"syllabe",
        u8"symbole",
        u8"symétrie",
        u8"synapse",
        u8"syntaxe",
        u8"système",
        u8"tabac",
        u8"tablier",
        u8"tactile",
        u8"tailler",
        u8"talent",
        u8"talisman",
        u8"talonner",
        u8"tambour",
        u8"tamiser",
        u8"tangible",
        u8"tapis",
        u8"taquiner",
        u8"tarder",
        u8"tarif",
        u8"tartine",
        u8"tasse",
        u8"tatami",
        u8"tatouage",
        u8"taupe",
        u8"taureau",
        u8"taxer",
        u8"témoin",
        u8"temporel",
        u8"tenaille",
        u8"tendre",
        u8"teneur",
        u8"tenir",
        u8"tension",
        u8"terminer",
        u8"terne",
        u8"terrible",
        u8"tétine",
        u8"texte",
        u8"thème",
        u8"théorie",
        u8"thérapie",
        u8"thorax",
        u8"tibia",
        u8"tiède",
        u8"timide",
        u8"tirelire",
        u8"tiroir",
        u8"tissu",
        u8"titane",
        u8"titre",
        u8"tituber",
        u8"toboggan",
        u8"tolérant",
        u8"tomate",
        u8"tonique",
        u8"tonneau",
        u8"toponyme",
        u8"torche",
        u8"tordre",
        u8"tornade",
        u8"torpille",
        u8"torrent",
        u8"torse",
        u8"tortue",
        u8"totem",
        u8"toucher",
        u8"tournage",
        u8"tousser",
        u8"toxine",
        u8"traction",
        u8"trafic",
        u8"tragique",
        u8"trahir",
        u8"train",
        u8"trancher",
        u8"travail",
        u8"trèfle",
        u8"tremper",
        u8"trésor",
        u8"treuil",
        u8"triage",
        u8"tribunal",
        u8"tricoter",
        u8"trilogie",
        u8"triomphe",
        u8"tripler",
        u8"triturer",
        u8"trivial",
        u8"trombone",
        u8"tronc",
        u8"tropical",
        u8"troupeau",
        u8"tuile",
        u8"tulipe",
        u8"tumulte",
        u8"tunnel",
        u8"turbine",
        u8"tuteur",
        u8"tutoyer",
        u8"tuyau",
        u8"tympan",
        u8"typhon",
        u8"typique",
        u8"tyran",
        u8"ubuesque",
        u8"ultime",
        u8"ultrason",
        u8"unanime",
        u8"unifier",
        u8"union",
        u8"unique",
        u8"unitaire",
        u8"univers",
        u8"uranium",
        u8"urbain",
        u8"urticant",
        u8"usage",
        u8"usine",
        u8"usuel",
        u8"usure",
        u8"utile",
        u8"utopie",
        u8"vacarme",
        u8"vaccin",
        u8"vagabond",
        u8"vague",
        u8"vaillant",
        u8"vaincre",
        u8"vaisseau",
        u8"valable",
        u8"valise",
        u8"vallon",
        u8"valve",
        u8"vampire",
        u8"vanille",
        u8"vapeur",
        u8"varier",
        u8"vaseux",
        u8"vassal",
        u8"vaste",
        u8"vecteur",
        u8"vedette",
        u8"végétal",
        u8"véhicule",
        u8"veinard",
        u8"véloce",
        u8"vendredi",
        u8"vénérer",
        u8"venger",
        u8"venimeux",
        u8"ventouse",
        u8"verdure",
        u8"vérin",
        u8"vernir",
        u8"verrou",
        u8"verser",
        u8"vertu",
        u8"veston",
        u8"vétéran",
        u8"vétuste",
        u8"vexant",
        u8"vexer",
        u8"viaduc",
        u8"viande",
        u8"victoire",
        u8"vidange",
        u8"vidéo",
        u8"vignette",
        u8"vigueur",
        u8"vilain",
        u8"village",
        u8"vinaigre",
        u8"violon",
        u8"vipère",
        u8"virement",
        u8"virtuose",
        u8"virus",
        u8"visage",
        u8"viseur",
        u8"vision",
        u8"visqueux",
        u8"visuel",
        u8"vital",
        u8"vitesse",
        u8"viticole",
        u8"vitrine",
        u8"vivace",
        u8"vivipare",
        u8"vocation",
        u8"voguer",
        u8"voile",
        u8"voisin",
        u8"voiture",
        u8"volaille",
        u8"volcan",
        u8"voltiger",
        u8"volume",
        u8"vorace",
        u8"vortex",
        u8"voter",
        u8"vouloir",
        u8"voyage",
        u8"voyelle",
        u8"wagon",
        u8"xénon",
        u8"yacht",
        u8"zèbre",
        u8"zénith",
        u8"zeste",
        u8"zoologie",
    }
};
