# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AdministratorName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ACTIVE_DIRECTORY = "ActiveDirectory"

class AdministratorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the sever administrator.
    """

    ACTIVE_DIRECTORY = "ActiveDirectory"

class AuthenticationName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class AuthenticationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The authentication type.
    """

    SQL = "SQL"
    AD_PASSWORD = "ADPassword"

class AutomaticTuningDisabledReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reason description if desired and actual state are different.
    """

    DEFAULT = "Default"
    DISABLED = "Disabled"
    AUTO_CONFIGURED = "AutoConfigured"
    INHERITED_FROM_SERVER = "InheritedFromServer"
    QUERY_STORE_OFF = "QueryStoreOff"
    QUERY_STORE_READ_ONLY = "QueryStoreReadOnly"
    NOT_SUPPORTED = "NotSupported"

class AutomaticTuningMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Automatic tuning desired state.
    """

    INHERIT = "Inherit"
    CUSTOM = "Custom"
    AUTO = "Auto"
    UNSPECIFIED = "Unspecified"

class AutomaticTuningOptionModeActual(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Automatic tuning option actual state.
    """

    OFF = "Off"
    ON = "On"

class AutomaticTuningOptionModeDesired(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Automatic tuning option desired state.
    """

    OFF = "Off"
    ON = "On"
    DEFAULT = "Default"

class AutomaticTuningServerMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Automatic tuning desired state.
    """

    CUSTOM = "Custom"
    AUTO = "Auto"
    UNSPECIFIED = "Unspecified"

class AutomaticTuningServerReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reason description if desired and actual state are different.
    """

    DEFAULT = "Default"
    DISABLED = "Disabled"
    AUTO_CONFIGURED = "AutoConfigured"

class BlobAuditingPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the state of the policy. If state is Enabled, storageEndpoint or
    isAzureMonitorTargetEnabled are required.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class CapabilityGroup(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SUPPORTED_EDITIONS = "supportedEditions"
    SUPPORTED_ELASTIC_POOL_EDITIONS = "supportedElasticPoolEditions"
    SUPPORTED_MANAGED_INSTANCE_VERSIONS = "supportedManagedInstanceVersions"
    SUPPORTED_INSTANCE_POOL_EDITIONS = "supportedInstancePoolEditions"
    SUPPORTED_MANAGED_INSTANCE_EDITIONS = "supportedManagedInstanceEditions"

class CapabilityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the capability.
    """

    VISIBLE = "Visible"
    AVAILABLE = "Available"
    DEFAULT = "Default"
    DISABLED = "Disabled"

class CatalogCollationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Collation of the metadata catalog.
    """

    DATABASE_DEFAULT = "DATABASE_DEFAULT"
    SQL_LATIN1_GENERAL_CP1_CI_AS = "SQL_Latin1_General_CP1_CI_AS"

class CheckNameAvailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reason code explaining why the name is unavailable. Will be undefined if the name is
    available.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class ConnectionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class CreateMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the mode of database creation.
    
    Default: regular database creation.
    
    Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
    as the resource ID of the source database.
    
    Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
    must be specified as the resource ID of the existing primary database.
    
    PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
    database. sourceDatabaseId must be specified as the resource ID of the existing database, and
    restorePointInTime must be specified.
    
    Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
    specified as the recoverable database resource ID to restore.
    
    Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
    be specified. If sourceDatabaseId is the database's original resource ID, then
    sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
    dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
    also be specified to restore from an earlier point in time.
    
    RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
    vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
    ID.
    
    Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
    edition.
    """

    DEFAULT = "Default"
    COPY = "Copy"
    SECONDARY = "Secondary"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RESTORE = "Restore"
    RECOVERY = "Recovery"
    RESTORE_EXTERNAL_BACKUP = "RestoreExternalBackup"
    RESTORE_EXTERNAL_BACKUP_SECONDARY = "RestoreExternalBackupSecondary"
    RESTORE_LONG_TERM_RETENTION_BACKUP = "RestoreLongTermRetentionBackup"
    ONLINE_SECONDARY = "OnlineSecondary"

class DatabaseEdition(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The edition for the database being created.
    
    The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU
    name, tier/edition, family, and capacity) that are available to your subscription in an Azure
    region, use the ``Capabilities_ListByLocation`` REST API or one of the following commands:
    
    .. code-block:: azurecli
    
       az sql db list-editions -l <location> -o table
       `
    
    .. code-block:: powershell
    
       Get-AzSqlServerServiceObjective -Location <location>
       `
    """

    WEB = "Web"
    BUSINESS = "Business"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PREMIUM_RS = "PremiumRS"
    FREE = "Free"
    STRETCH = "Stretch"
    DATA_WAREHOUSE = "DataWarehouse"
    SYSTEM = "System"
    SYSTEM2 = "System2"
    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"
    HYPERSCALE = "Hyperscale"

class DatabaseLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The license type to apply for this database. ``LicenseIncluded`` if you need a license, or
    ``BasePrice`` if you have a license and are eligible for the Azure Hybrid Benefit.
    """

    LICENSE_INCLUDED = "LicenseIncluded"
    BASE_PRICE = "BasePrice"

class DatabaseReadScale(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If enabled, connections that have application intent set to readonly in their connection string
    may be routed to a readonly secondary replica. This property is only settable for Premium and
    Business Critical databases.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class DatabaseState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALL = "All"
    LIVE = "Live"
    DELETED = "Deleted"

class DatabaseStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the database.
    """

    ONLINE = "Online"
    RESTORING = "Restoring"
    RECOVERY_PENDING = "RecoveryPending"
    RECOVERING = "Recovering"
    SUSPECT = "Suspect"
    OFFLINE = "Offline"
    STANDBY = "Standby"
    SHUTDOWN = "Shutdown"
    EMERGENCY_MODE = "EmergencyMode"
    AUTO_CLOSED = "AutoClosed"
    COPYING = "Copying"
    CREATING = "Creating"
    INACCESSIBLE = "Inaccessible"
    OFFLINE_SECONDARY = "OfflineSecondary"
    PAUSING = "Pausing"
    PAUSED = "Paused"
    RESUMING = "Resuming"
    SCALING = "Scaling"
    OFFLINE_CHANGING_DW_PERFORMANCE_TIERS = "OfflineChangingDwPerformanceTiers"
    ONLINE_CHANGING_DW_PERFORMANCE_TIERS = "OnlineChangingDwPerformanceTiers"
    DISABLED = "Disabled"

class DataMaskingFunction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The masking function that is used for the data masking rule.
    """

    DEFAULT = "Default"
    CCN = "CCN"
    EMAIL = "Email"
    NUMBER = "Number"
    SSN = "SSN"
    TEXT = "Text"

class DataMaskingRuleState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName,
    tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule
    doesn't already exist, the rule will be created with ruleState set to enabled, regardless of
    the provided value of ruleState.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DataMaskingState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the data masking policy.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DiffBackupIntervalInHours(with_metaclass(_CaseInsensitiveEnumMeta, int, Enum)):
    """The differential backup interval in hours. This is how many interval hours between each
    differential backup will be supported. This is only applicable to live databases but not
    dropped databases.
    """

    TWELVE = 12
    TWENTY_FOUR = 24

class ElasticPoolEdition(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The edition of the recommended elastic pool. The ElasticPoolEdition enumeration contains all
    the valid editions.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"

class ElasticPoolLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The license type to apply for this elastic pool.
    """

    LICENSE_INCLUDED = "LicenseIncluded"
    BASE_PRICE = "BasePrice"

class ElasticPoolState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the elastic pool.
    """

    CREATING = "Creating"
    READY = "Ready"
    DISABLED = "Disabled"

class EncryptionProtectorName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"

class Enum65(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALL = "All"
    ERROR = "Error"
    WARNING = "Warning"
    SUCCESS = "Success"

class ExtensionName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    IMPORT_ENUM = "import"

class FailoverGroupReplicationRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Local replication role of the failover group instance.
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class GeoBackupPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class GeoBackupPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the geo backup policy.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class IdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an
    Azure Active Directory principal for the resource.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"

class InstanceFailoverGroupReplicationRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Local replication role of the failover group instance.
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class InstancePoolLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and
    'BasePrice' (without SQL license price).
    """

    LICENSE_INCLUDED = "LicenseIncluded"
    BASE_PRICE = "BasePrice"

class JobAgentState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the job agent.
    """

    CREATING = "Creating"
    READY = "Ready"
    UPDATING = "Updating"
    DELETING = "Deleting"
    DISABLED = "Disabled"

class JobExecutionLifecycle(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The detailed state of the job execution.
    """

    CREATED = "Created"
    IN_PROGRESS = "InProgress"
    WAITING_FOR_CHILD_JOB_EXECUTIONS = "WaitingForChildJobExecutions"
    WAITING_FOR_RETRY = "WaitingForRetry"
    SUCCEEDED = "Succeeded"
    SUCCEEDED_WITH_SKIPPED = "SucceededWithSkipped"
    FAILED = "Failed"
    TIMED_OUT = "TimedOut"
    CANCELED = "Canceled"
    SKIPPED = "Skipped"

class JobScheduleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Schedule interval type
    """

    ONCE = "Once"
    RECURRING = "Recurring"

class JobStepActionSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The source of the action to execute.
    """

    INLINE = "Inline"

class JobStepActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of action being executed by the job step.
    """

    T_SQL = "TSql"

class JobStepOutputType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The output destination type.
    """

    SQL_DATABASE = "SqlDatabase"

class JobTargetGroupMembershipType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether the target is included or excluded from the group.
    """

    INCLUDE = "Include"
    EXCLUDE = "Exclude"

class JobTargetType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the target.
    """

    TARGET_GROUP = "TargetGroup"
    SQL_DATABASE = "SqlDatabase"
    SQL_ELASTIC_POOL = "SqlElasticPool"
    SQL_SHARD_MAP = "SqlShardMap"
    SQL_SERVER = "SqlServer"

class LogSizeUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The units that the limit is expressed in.
    """

    MEGABYTES = "Megabytes"
    GIGABYTES = "Gigabytes"
    TERABYTES = "Terabytes"
    PETABYTES = "Petabytes"
    PERCENT = "Percent"

class LongTermRetentionDatabaseState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALL = "All"
    LIVE = "Live"
    DELETED = "Deleted"

class LongTermRetentionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class ManagedDatabaseCreateMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Managed database create mode. PointInTimeRestore: Create a database by restoring a point in
    time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and
    PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from
    external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be
    specified. Recovery: Creates a database by restoring a geo-replicated backup.
    RecoverableDatabaseId must be specified as the recoverable database resource ID to restore.
    RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention
    backup (longTermRetentionBackupResourceId required).
    """

    DEFAULT = "Default"
    RESTORE_EXTERNAL_BACKUP = "RestoreExternalBackup"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RECOVERY = "Recovery"
    RESTORE_LONG_TERM_RETENTION_BACKUP = "RestoreLongTermRetentionBackup"

class ManagedDatabaseStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the database.
    """

    ONLINE = "Online"
    OFFLINE = "Offline"
    SHUTDOWN = "Shutdown"
    CREATING = "Creating"
    INACCESSIBLE = "Inaccessible"
    RESTORING = "Restoring"
    UPDATING = "Updating"

class ManagedInstanceAdministratorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the managed instance administrator.
    """

    ACTIVE_DIRECTORY = "ActiveDirectory"

class ManagedInstanceLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL
    license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
    """

    LICENSE_INCLUDED = "LicenseIncluded"
    BASE_PRICE = "BasePrice"

class ManagedInstanceLongTermRetentionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class ManagedInstancePropertiesProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CREATING = "Creating"
    DELETING = "Deleting"
    UPDATING = "Updating"
    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class ManagedInstanceProxyOverride(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Connection type used for connecting to the instance.
    """

    PROXY = "Proxy"
    REDIRECT = "Redirect"
    DEFAULT = "Default"

class ManagedServerCreateMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the mode of database creation.
    
    Default: Regular instance creation.
    
    Restore: Creates an instance by restoring a set of backups to specific point in time.
    RestorePointInTime and SourceManagedInstanceId must be specified.
    """

    DEFAULT = "Default"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"

class ManagedShortTermRetentionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class ManagementOperationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The operation state.
    """

    PENDING = "Pending"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCEL_IN_PROGRESS = "CancelInProgress"
    CANCELLED = "Cancelled"

class MaxSizeUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The units that the limit is expressed in.
    """

    MEGABYTES = "Megabytes"
    GIGABYTES = "Gigabytes"
    TERABYTES = "Terabytes"
    PETABYTES = "Petabytes"

class OperationOrigin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation.
    """

    USER = "user"
    SYSTEM = "system"

class PauseDelayTimeUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Unit of time that delay is expressed in
    """

    MINUTES = "Minutes"

class PerformanceLevelUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Unit type used to measure performance level.
    """

    DTU = "DTU"
    V_CORES = "VCores"

class PrimaryAggregationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The primary aggregation type defining how metric values are displayed.
    """

    NONE = "None"
    AVERAGE = "Average"
    COUNT = "Count"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"

class PrivateEndpointProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of the private endpoint connection.
    """

    APPROVING = "Approving"
    READY = "Ready"
    DROPPING = "Dropping"
    FAILED = "Failed"
    REJECTING = "Rejecting"

class PrivateLinkServiceConnectionStateActionsRequire(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The actions required for private link service connection.
    """

    NONE = "None"

class PrivateLinkServiceConnectionStateStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The private link service connection status.
    """

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The ARM provisioning state of the job execution.
    """

    CREATED = "Created"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class ReadOnlyEndpointFailoverPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Failover policy of the read-only endpoint for the failover group.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class ReadWriteEndpointFailoverPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Failover policy of the read-write endpoint for the failover group. If failoverPolicy is
    Automatic then failoverWithDataLossGracePeriodMinutes is required.
    """

    MANUAL = "Manual"
    AUTOMATIC = "Automatic"

class RecommendedIndexAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The proposed index action. You can create a missing index, drop an unused index, or rebuild an
    existing index to improve its performance.
    """

    CREATE = "Create"
    DROP = "Drop"
    REBUILD = "Rebuild"

class RecommendedIndexState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current recommendation state.
    """

    ACTIVE = "Active"
    PENDING = "Pending"
    EXECUTING = "Executing"
    VERIFYING = "Verifying"
    PENDING_REVERT = "Pending Revert"
    REVERTING = "Reverting"
    REVERTED = "Reverted"
    IGNORED = "Ignored"
    EXPIRED = "Expired"
    BLOCKED = "Blocked"
    SUCCESS = "Success"

class RecommendedIndexType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE)
    """

    CLUSTERED = "CLUSTERED"
    NONCLUSTERED = "NONCLUSTERED"
    COLUMNSTORE = "COLUMNSTORE"
    CLUSTERED_COLUMNSTORE = "CLUSTERED COLUMNSTORE"

class ReplicationRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The role of the database in the replication link.
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    NON_READABLE_SECONDARY = "NonReadableSecondary"
    SOURCE = "Source"
    COPY = "Copy"

class ReplicationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The replication state for the replication link.
    """

    PENDING = "PENDING"
    SEEDING = "SEEDING"
    CATCH_UP = "CATCH_UP"
    SUSPENDED = "SUSPENDED"

class ReplicaType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PRIMARY = "Primary"
    READABLE_SECONDARY = "ReadableSecondary"

class RestoreDetailsName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class RestorePointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of restore point
    """

    CONTINUOUS = "CONTINUOUS"
    DISCRETE = "DISCRETE"

class SampleName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the sample schema to apply when creating this database.
    """

    ADVENTURE_WORKS_LT = "AdventureWorksLT"
    WIDE_WORLD_IMPORTERS_STD = "WideWorldImportersStd"
    WIDE_WORLD_IMPORTERS_FULL = "WideWorldImportersFull"

class SecurityAlertPolicyEmailAccountAdmins(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies that the alert is sent to the account administrators.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SecurityAlertPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class SecurityAlertPolicyNameAutoGenerated(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class SecurityAlertPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the state of the policy. If state is Enabled, storageEndpoint and
    storageAccountAccessKey are required.
    """

    NEW = "New"
    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SecurityAlertPolicyUseServerDefault(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies whether to use the default server policy.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SensitivityLabelRank(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
    CRITICAL = "Critical"

class SensitivityLabelSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"
    RECOMMENDED = "recommended"

class ServerConnectionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The server connection type.
    """

    DEFAULT = "Default"
    PROXY = "Proxy"
    REDIRECT = "Redirect"

class ServerKeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
    """

    SERVICE_MANAGED = "ServiceManaged"
    AZURE_KEY_VAULT = "AzureKeyVault"

class ServerPublicNetworkAccess(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether or not public endpoint access is allowed for this server.  Value is optional but if
    passed in, must be 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ServiceObjectiveName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the service objective to assign to the database.
    """

    SYSTEM = "System"
    SYSTEM0 = "System0"
    SYSTEM1 = "System1"
    SYSTEM2 = "System2"
    SYSTEM3 = "System3"
    SYSTEM4 = "System4"
    SYSTEM2_L = "System2L"
    SYSTEM3_L = "System3L"
    SYSTEM4_L = "System4L"
    FREE = "Free"
    BASIC = "Basic"
    S0 = "S0"
    S1 = "S1"
    S2 = "S2"
    S3 = "S3"
    S4 = "S4"
    S6 = "S6"
    S7 = "S7"
    S9 = "S9"
    S12 = "S12"
    P1 = "P1"
    P2 = "P2"
    P3 = "P3"
    P4 = "P4"
    P6 = "P6"
    P11 = "P11"
    P15 = "P15"
    PRS1 = "PRS1"
    PRS2 = "PRS2"
    PRS4 = "PRS4"
    PRS6 = "PRS6"
    DW100 = "DW100"
    DW200 = "DW200"
    DW300 = "DW300"
    DW400 = "DW400"
    DW500 = "DW500"
    DW600 = "DW600"
    DW1000 = "DW1000"
    DW1200 = "DW1200"
    DW1000_C = "DW1000c"
    DW1500 = "DW1500"
    DW1500_C = "DW1500c"
    DW2000 = "DW2000"
    DW2000_C = "DW2000c"
    DW3000 = "DW3000"
    DW2500_C = "DW2500c"
    DW3000_C = "DW3000c"
    DW6000 = "DW6000"
    DW5000_C = "DW5000c"
    DW6000_C = "DW6000c"
    DW7500_C = "DW7500c"
    DW10000_C = "DW10000c"
    DW15000_C = "DW15000c"
    DW30000_C = "DW30000c"
    DS100 = "DS100"
    DS200 = "DS200"
    DS300 = "DS300"
    DS400 = "DS400"
    DS500 = "DS500"
    DS600 = "DS600"
    DS1000 = "DS1000"
    DS1200 = "DS1200"
    DS1500 = "DS1500"
    DS2000 = "DS2000"
    ELASTIC_POOL = "ElasticPool"

class ShortTermRetentionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class StorageAccountType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The storage account type used to store backups for this instance. The options are LRS
    (LocallyRedundantStorage), ZRS (ZoneRedundantStorage) and GRS (GeoRedundantStorage)
    """

    GRS = "GRS"
    LRS = "LRS"
    ZRS = "ZRS"

class StorageCapabilityStorageAccountType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The storage account type for the database's backups.
    """

    GRS = "GRS"
    LRS = "LRS"
    ZRS = "ZRS"

class StorageKeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the storage key to use.
    """

    STORAGE_ACCESS_KEY = "StorageAccessKey"
    SHARED_ACCESS_KEY = "SharedAccessKey"

class SyncAgentState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of the sync agent.
    """

    ONLINE = "Online"
    OFFLINE = "Offline"
    NEVER_CONNECTED = "NeverConnected"

class SyncConflictResolutionPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Conflict resolution policy of the sync group.
    """

    HUB_WIN = "HubWin"
    MEMBER_WIN = "MemberWin"

class SyncDirection(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sync direction of the sync member.
    """

    BIDIRECTIONAL = "Bidirectional"
    ONE_WAY_MEMBER_TO_HUB = "OneWayMemberToHub"
    ONE_WAY_HUB_TO_MEMBER = "OneWayHubToMember"

class SyncGroupLogType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the sync group log.
    """

    ALL = "All"
    ERROR = "Error"
    WARNING = "Warning"
    SUCCESS = "Success"

class SyncGroupState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sync state of the sync group.
    """

    NOT_READY = "NotReady"
    ERROR = "Error"
    WARNING = "Warning"
    PROGRESSING = "Progressing"
    GOOD = "Good"

class SyncMemberDbType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the sync agent linked database.
    """

    AZURE_SQL_DATABASE = "AzureSqlDatabase"
    SQL_SERVER_DATABASE = "SqlServerDatabase"

class SyncMemberState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sync state of the sync member.
    """

    SYNC_IN_PROGRESS = "SyncInProgress"
    SYNC_SUCCEEDED = "SyncSucceeded"
    SYNC_FAILED = "SyncFailed"
    DISABLED_TOMBSTONE_CLEANUP = "DisabledTombstoneCleanup"
    DISABLED_BACKUP_RESTORE = "DisabledBackupRestore"
    SYNC_SUCCEEDED_WITH_WARNINGS = "SyncSucceededWithWarnings"
    SYNC_CANCELLING = "SyncCancelling"
    SYNC_CANCELLED = "SyncCancelled"
    UN_PROVISIONED = "UnProvisioned"
    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    PROVISION_FAILED = "ProvisionFailed"
    DE_PROVISIONING = "DeProvisioning"
    DE_PROVISIONED = "DeProvisioned"
    DE_PROVISION_FAILED = "DeProvisionFailed"
    REPROVISIONING = "Reprovisioning"
    REPROVISION_FAILED = "ReprovisionFailed"
    UN_REPROVISIONED = "UnReprovisioned"

class TransparentDataEncryptionActivityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the database.
    """

    ENCRYPTING = "Encrypting"
    DECRYPTING = "Decrypting"

class TransparentDataEncryptionName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"

class TransparentDataEncryptionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the database transparent data encryption.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class UnitDefinitionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The unit of the metric.
    """

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNT_PER_SECOND = "CountPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"

class UnitType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The unit of the metric.
    """

    COUNT = "count"
    BYTES = "bytes"
    SECONDS = "seconds"
    PERCENT = "percent"
    COUNT_PER_SECOND = "countPerSecond"
    BYTES_PER_SECOND = "bytesPerSecond"

class UpsertManagedServerOperationStepStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    SLOWED_DOWN = "SlowedDown"
    COMPLETED = "Completed"
    FAILED = "Failed"
    CANCELED = "Canceled"

class VirtualNetworkRuleState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Virtual Network Rule State
    """

    INITIALIZING = "Initializing"
    IN_PROGRESS = "InProgress"
    READY = "Ready"
    DELETING = "Deleting"
    UNKNOWN = "Unknown"

class VulnerabilityAssessmentName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class VulnerabilityAssessmentPolicyBaselineName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MASTER = "master"
    DEFAULT = "default"

class VulnerabilityAssessmentScanState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scan status.
    """

    PASSED = "Passed"
    FAILED = "Failed"
    FAILED_TO_RUN = "FailedToRun"
    IN_PROGRESS = "InProgress"

class VulnerabilityAssessmentScanTriggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scan trigger type.
    """

    ON_DEMAND = "OnDemand"
    RECURRING = "Recurring"
