# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BackupRequest(Model):
    """Backup request.

    :param azure_file_share: Azure File Share.
    :type azure_file_share: str
    """

    _attribute_map = {
        'azure_file_share': {'key': 'azureFileShare', 'type': 'str'},
    }

    def __init__(self, *, azure_file_share: str=None, **kwargs) -> None:
        super(BackupRequest, self).__init__(**kwargs)
        self.azure_file_share = azure_file_share


class CheckNameAvailabilityParameters(Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name to check for availability
    :type name: str
    :ivar type: Required. The resource type. Must be set to
     Microsoft.StorageSync/storageSyncServices. Default value:
     "Microsoft.StorageSync/storageSyncServices" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.StorageSync/storageSyncServices"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name
     is available for you to use. If true, the name is available. If false, the
     name has already been taken or invalid and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Storage Sync Service name could not
     be used. The Reason element is only returned if NameAvailable is false.
     Possible values include: 'Invalid', 'AlreadyExists'
    :vartype reason: str or
     ~azure.mgmt.storagesync.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more
     detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'NameAvailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class CloudEndpoint(ProxyResource):
    """Cloud Endpoint object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param storage_account_resource_id: Storage Account Resource Id
    :type storage_account_resource_id: str
    :param azure_file_share_name: Azure file share name
    :type azure_file_share_name: str
    :param storage_account_tenant_id: Storage Account Tenant Id
    :type storage_account_tenant_id: str
    :param partnership_id: Partnership Id
    :type partnership_id: str
    :param friendly_name: Friendly Name
    :type friendly_name: str
    :ivar backup_enabled: Backup Enabled
    :vartype backup_enabled: str
    :param provisioning_state: CloudEndpoint Provisioning State
    :type provisioning_state: str
    :param last_workflow_id: CloudEndpoint lastWorkflowId
    :type last_workflow_id: str
    :param last_operation_name: Resource Last Operation Name
    :type last_operation_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'azure_file_share_name': {'key': 'properties.azureFileShareName', 'type': 'str'},
        'storage_account_tenant_id': {'key': 'properties.storageAccountTenantId', 'type': 'str'},
        'partnership_id': {'key': 'properties.partnershipId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'backup_enabled': {'key': 'properties.backupEnabled', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
    }

    def __init__(self, *, storage_account_resource_id: str=None, azure_file_share_name: str=None, storage_account_tenant_id: str=None, partnership_id: str=None, friendly_name: str=None, provisioning_state: str=None, last_workflow_id: str=None, last_operation_name: str=None, **kwargs) -> None:
        super(CloudEndpoint, self).__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.azure_file_share_name = azure_file_share_name
        self.storage_account_tenant_id = storage_account_tenant_id
        self.partnership_id = partnership_id
        self.friendly_name = friendly_name
        self.backup_enabled = None
        self.provisioning_state = provisioning_state
        self.last_workflow_id = last_workflow_id
        self.last_operation_name = last_operation_name


class CloudEndpointCreateParameters(ProxyResource):
    """The parameters used when creating a cloud endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param storage_account_resource_id: Storage Account Resource Id
    :type storage_account_resource_id: str
    :param azure_file_share_name: Azure file share name
    :type azure_file_share_name: str
    :param storage_account_tenant_id: Storage Account Tenant Id
    :type storage_account_tenant_id: str
    :param friendly_name: Friendly Name
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'azure_file_share_name': {'key': 'properties.azureFileShareName', 'type': 'str'},
        'storage_account_tenant_id': {'key': 'properties.storageAccountTenantId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(self, *, storage_account_resource_id: str=None, azure_file_share_name: str=None, storage_account_tenant_id: str=None, friendly_name: str=None, **kwargs) -> None:
        super(CloudEndpointCreateParameters, self).__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.azure_file_share_name = azure_file_share_name
        self.storage_account_tenant_id = storage_account_tenant_id
        self.friendly_name = friendly_name


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class OperationDisplayInfo(Model):
    """The operation supported by storage sync.

    :param description: The description of the operation.
    :type description: str
    :param operation: The action that users can perform, based on their
     permission level.
    :type operation: str
    :param provider: Service provider: Microsoft StorageSync.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(self, *, description: str=None, operation: str=None, provider: str=None, resource: str=None, **kwargs) -> None:
        super(OperationDisplayInfo, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationDisplayResource(Model):
    """Operation Display Resource object.

    :param provider: Operation Display Resource Provider.
    :type provider: str
    :param resource: Operation Display Resource.
    :type resource: str
    :param operation: Operation Display Resource Operation.
    :type operation: str
    :param description: Operation Display Resource Description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplayResource, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationEntity(Model):
    """The operation supported by storage sync.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The operation supported by storage sync.
    :type display: ~azure.mgmt.storagesync.models.OperationDisplayInfo
    :param origin: The origin.
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, **kwargs) -> None:
        super(OperationEntity, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationStatus(Model):
    """Operation status object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation Id
    :vartype name: str
    :ivar status: Operation status
    :vartype status: str
    :ivar start_time: Start time of the operation
    :vartype start_time: datetime
    :ivar end_time: End time of the operation
    :vartype end_time: datetime
    :ivar error: Error details.
    :vartype error: ~azure.mgmt.storagesync.models.StorageSyncApiError
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'StorageSyncApiError'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationStatus, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None


class PostBackupResponse(Model):
    """Post Backup Response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar cloud_endpoint_name: cloud endpoint Name.
    :vartype cloud_endpoint_name: str
    """

    _validation = {
        'cloud_endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'cloud_endpoint_name': {'key': 'backupMetadata.cloudEndpointName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PostBackupResponse, self).__init__(**kwargs)
        self.cloud_endpoint_name = None


class PostRestoreRequest(Model):
    """Post Restore Request.

    :param partition: Post Restore partition.
    :type partition: str
    :param replica_group: Post Restore replica group.
    :type replica_group: str
    :param request_id: Post Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Post Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Post Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Post Restore Azure source azure file
     share uri.
    :type source_azure_file_share_uri: str
    :param failed_file_list: Post Restore Azure failed file list.
    :type failed_file_list: str
    :param restore_file_spec: Post Restore restore file spec array.
    :type restore_file_spec:
     list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'failed_file_list': {'key': 'failedFileList', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
    }

    def __init__(self, *, partition: str=None, replica_group: str=None, request_id: str=None, azure_file_share_uri: str=None, status: str=None, source_azure_file_share_uri: str=None, failed_file_list: str=None, restore_file_spec=None, **kwargs) -> None:
        super(PostRestoreRequest, self).__init__(**kwargs)
        self.partition = partition
        self.replica_group = replica_group
        self.request_id = request_id
        self.azure_file_share_uri = azure_file_share_uri
        self.status = status
        self.source_azure_file_share_uri = source_azure_file_share_uri
        self.failed_file_list = failed_file_list
        self.restore_file_spec = restore_file_spec


class PreRestoreRequest(Model):
    """Pre Restore request object.

    :param partition: Pre Restore partition.
    :type partition: str
    :param replica_group: Pre Restore replica group.
    :type replica_group: str
    :param request_id: Pre Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Pre Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Pre Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Pre Restore Azure source azure file
     share uri.
    :type source_azure_file_share_uri: str
    :param backup_metadata_property_bag: Pre Restore backup metadata property
     bag.
    :type backup_metadata_property_bag: str
    :param restore_file_spec: Pre Restore restore file spec array.
    :type restore_file_spec:
     list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    :param pause_wait_for_sync_drain_time_period_in_seconds: Pre Restore pause
     wait for sync drain time period in seconds.
    :type pause_wait_for_sync_drain_time_period_in_seconds: int
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'backup_metadata_property_bag': {'key': 'backupMetadataPropertyBag', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
        'pause_wait_for_sync_drain_time_period_in_seconds': {'key': 'pauseWaitForSyncDrainTimePeriodInSeconds', 'type': 'int'},
    }

    def __init__(self, *, partition: str=None, replica_group: str=None, request_id: str=None, azure_file_share_uri: str=None, status: str=None, source_azure_file_share_uri: str=None, backup_metadata_property_bag: str=None, restore_file_spec=None, pause_wait_for_sync_drain_time_period_in_seconds: int=None, **kwargs) -> None:
        super(PreRestoreRequest, self).__init__(**kwargs)
        self.partition = partition
        self.replica_group = replica_group
        self.request_id = request_id
        self.azure_file_share_uri = azure_file_share_uri
        self.status = status
        self.source_azure_file_share_uri = source_azure_file_share_uri
        self.backup_metadata_property_bag = backup_metadata_property_bag
        self.restore_file_spec = restore_file_spec
        self.pause_wait_for_sync_drain_time_period_in_seconds = pause_wait_for_sync_drain_time_period_in_seconds


class RecallActionParameters(Model):
    """The parameters used when calling recall action on server endpoint.

    :param pattern: Pattern of the files.
    :type pattern: str
    :param recall_path: Recall path.
    :type recall_path: str
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'recall_path': {'key': 'recallPath', 'type': 'str'},
    }

    def __init__(self, *, pattern: str=None, recall_path: str=None, **kwargs) -> None:
        super(RecallActionParameters, self).__init__(**kwargs)
        self.pattern = pattern
        self.recall_path = recall_path


class RegisteredServer(ProxyResource):
    """Registered Server resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_certificate: Registered Server Certificate
    :type server_certificate: str
    :param agent_version: Registered Server Agent Version
    :type agent_version: str
    :param server_os_version: Registered Server OS Version
    :type server_os_version: str
    :param server_management_error_code: Registered Server Management Error
     Code
    :type server_management_error_code: int
    :param last_heart_beat: Registered Server last heart beat
    :type last_heart_beat: str
    :param provisioning_state: Registered Server Provisioning State
    :type provisioning_state: str
    :param server_role: Registered Server serverRole
    :type server_role: str
    :param cluster_id: Registered Server clusterId
    :type cluster_id: str
    :param cluster_name: Registered Server clusterName
    :type cluster_name: str
    :param server_id: Registered Server serverId
    :type server_id: str
    :param storage_sync_service_uid: Registered Server storageSyncServiceUid
    :type storage_sync_service_uid: str
    :param last_workflow_id: Registered Server lastWorkflowId
    :type last_workflow_id: str
    :param last_operation_name: Resource Last Operation Name
    :type last_operation_name: str
    :param discovery_endpoint_uri: Resource discoveryEndpointUri
    :type discovery_endpoint_uri: str
    :param resource_location: Resource Location
    :type resource_location: str
    :param service_location: Service Location
    :type service_location: str
    :param friendly_name: Friendly Name
    :type friendly_name: str
    :param management_endpoint_uri: Management Endpoint Uri
    :type management_endpoint_uri: str
    :param monitoring_configuration: Monitoring Configuration
    :type monitoring_configuration: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_certificate': {'key': 'properties.serverCertificate', 'type': 'str'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'server_os_version': {'key': 'properties.serverOSVersion', 'type': 'str'},
        'server_management_error_code': {'key': 'properties.serverManagementErrorCode', 'type': 'int'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_name': {'key': 'properties.clusterName', 'type': 'str'},
        'server_id': {'key': 'properties.serverId', 'type': 'str'},
        'storage_sync_service_uid': {'key': 'properties.storageSyncServiceUid', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
        'discovery_endpoint_uri': {'key': 'properties.discoveryEndpointUri', 'type': 'str'},
        'resource_location': {'key': 'properties.resourceLocation', 'type': 'str'},
        'service_location': {'key': 'properties.serviceLocation', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'management_endpoint_uri': {'key': 'properties.managementEndpointUri', 'type': 'str'},
        'monitoring_configuration': {'key': 'properties.monitoringConfiguration', 'type': 'str'},
    }

    def __init__(self, *, server_certificate: str=None, agent_version: str=None, server_os_version: str=None, server_management_error_code: int=None, last_heart_beat: str=None, provisioning_state: str=None, server_role: str=None, cluster_id: str=None, cluster_name: str=None, server_id: str=None, storage_sync_service_uid: str=None, last_workflow_id: str=None, last_operation_name: str=None, discovery_endpoint_uri: str=None, resource_location: str=None, service_location: str=None, friendly_name: str=None, management_endpoint_uri: str=None, monitoring_configuration: str=None, **kwargs) -> None:
        super(RegisteredServer, self).__init__(**kwargs)
        self.server_certificate = server_certificate
        self.agent_version = agent_version
        self.server_os_version = server_os_version
        self.server_management_error_code = server_management_error_code
        self.last_heart_beat = last_heart_beat
        self.provisioning_state = provisioning_state
        self.server_role = server_role
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.server_id = server_id
        self.storage_sync_service_uid = storage_sync_service_uid
        self.last_workflow_id = last_workflow_id
        self.last_operation_name = last_operation_name
        self.discovery_endpoint_uri = discovery_endpoint_uri
        self.resource_location = resource_location
        self.service_location = service_location
        self.friendly_name = friendly_name
        self.management_endpoint_uri = management_endpoint_uri
        self.monitoring_configuration = monitoring_configuration


class RegisteredServerCreateParameters(ProxyResource):
    """The parameters used when creating a registered server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_certificate: Registered Server Certificate
    :type server_certificate: str
    :param agent_version: Registered Server Agent Version
    :type agent_version: str
    :param server_os_version: Registered Server OS Version
    :type server_os_version: str
    :param last_heart_beat: Registered Server last heart beat
    :type last_heart_beat: str
    :param server_role: Registered Server serverRole
    :type server_role: str
    :param cluster_id: Registered Server clusterId
    :type cluster_id: str
    :param cluster_name: Registered Server clusterName
    :type cluster_name: str
    :param server_id: Registered Server serverId
    :type server_id: str
    :param friendly_name: Friendly Name
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_certificate': {'key': 'properties.serverCertificate', 'type': 'str'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'server_os_version': {'key': 'properties.serverOSVersion', 'type': 'str'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_name': {'key': 'properties.clusterName', 'type': 'str'},
        'server_id': {'key': 'properties.serverId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(self, *, server_certificate: str=None, agent_version: str=None, server_os_version: str=None, last_heart_beat: str=None, server_role: str=None, cluster_id: str=None, cluster_name: str=None, server_id: str=None, friendly_name: str=None, **kwargs) -> None:
        super(RegisteredServerCreateParameters, self).__init__(**kwargs)
        self.server_certificate = server_certificate
        self.agent_version = agent_version
        self.server_os_version = server_os_version
        self.last_heart_beat = last_heart_beat
        self.server_role = server_role
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.server_id = server_id
        self.friendly_name = friendly_name


class ResourcesMoveInfo(Model):
    """Resource Move Info.

    :param target_resource_group: Target resource group.
    :type target_resource_group: str
    :param resources: Collection of Resources.
    :type resources: list[str]
    """

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(self, *, target_resource_group: str=None, resources=None, **kwargs) -> None:
        super(ResourcesMoveInfo, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class RestoreFileSpec(Model):
    """Restore file spec.

    :param path: Restore file spec path
    :type path: str
    :param isdir: Restore file spec isdir
    :type isdir: bool
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'isdir': {'key': 'isdir', 'type': 'bool'},
    }

    def __init__(self, *, path: str=None, isdir: bool=None, **kwargs) -> None:
        super(RestoreFileSpec, self).__init__(**kwargs)
        self.path = path
        self.isdir = isdir


class ServerEndpoint(ProxyResource):
    """Server Endpoint object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_local_path: Server Local path.
    :type server_local_path: str
    :param cloud_tiering: Cloud Tiering. Possible values include: 'on', 'off'
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.enum
    :param volume_free_space_percent: Level of free space to be maintained by
     Cloud Tiering if it is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param friendly_name: Friendly Name
    :type friendly_name: str
    :param server_resource_id: Server Resource Id.
    :type server_resource_id: str
    :ivar provisioning_state: ServerEndpoint Provisioning State
    :vartype provisioning_state: str
    :ivar last_workflow_id: ServerEndpoint lastWorkflowId
    :vartype last_workflow_id: str
    :ivar last_operation_name: Resource Last Operation Name
    :vartype last_operation_name: str
    :ivar sync_status: Server Endpoint sync status
    :vartype sync_status:
     ~azure.mgmt.storagesync.models.ServerEndpointSyncStatus
    :param offline_data_transfer: Offline data transfer. Possible values
     include: 'on', 'off'
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.enum
    :ivar offline_data_transfer_storage_account_resource_id: Offline data
     transfer storage account resource ID
    :vartype offline_data_transfer_storage_account_resource_id: str
    :ivar offline_data_transfer_storage_account_tenant_id: Offline data
     transfer storage account tenant ID
    :vartype offline_data_transfer_storage_account_tenant_id: str
    :param offline_data_transfer_share_name: Offline data transfer share name
    :type offline_data_transfer_share_name: str
    :ivar cloud_tiering_status: Cloud tiering status. Only populated if cloud
     tiering is enabled.
    :vartype cloud_tiering_status:
     ~azure.mgmt.storagesync.models.ServerEndpointCloudTieringStatus
    :ivar recall_status: Recall status. Only populated if cloud tiering is
     enabled.
    :vartype recall_status:
     ~azure.mgmt.storagesync.models.ServerEndpointRecallStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'last_workflow_id': {'readonly': True},
        'last_operation_name': {'readonly': True},
        'sync_status': {'readonly': True},
        'offline_data_transfer_storage_account_resource_id': {'readonly': True},
        'offline_data_transfer_storage_account_tenant_id': {'readonly': True},
        'cloud_tiering_status': {'readonly': True},
        'recall_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_local_path': {'key': 'properties.serverLocalPath', 'type': 'str'},
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'server_resource_id': {'key': 'properties.serverResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
        'sync_status': {'key': 'properties.syncStatus', 'type': 'ServerEndpointSyncStatus'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_storage_account_resource_id': {'key': 'properties.offlineDataTransferStorageAccountResourceId', 'type': 'str'},
        'offline_data_transfer_storage_account_tenant_id': {'key': 'properties.offlineDataTransferStorageAccountTenantId', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
        'cloud_tiering_status': {'key': 'properties.cloudTieringStatus', 'type': 'ServerEndpointCloudTieringStatus'},
        'recall_status': {'key': 'properties.recallStatus', 'type': 'ServerEndpointRecallStatus'},
    }

    def __init__(self, *, server_local_path: str=None, cloud_tiering=None, volume_free_space_percent: int=None, tier_files_older_than_days: int=None, friendly_name: str=None, server_resource_id: str=None, offline_data_transfer=None, offline_data_transfer_share_name: str=None, **kwargs) -> None:
        super(ServerEndpoint, self).__init__(**kwargs)
        self.server_local_path = server_local_path
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.friendly_name = friendly_name
        self.server_resource_id = server_resource_id
        self.provisioning_state = None
        self.last_workflow_id = None
        self.last_operation_name = None
        self.sync_status = None
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_storage_account_resource_id = None
        self.offline_data_transfer_storage_account_tenant_id = None
        self.offline_data_transfer_share_name = offline_data_transfer_share_name
        self.cloud_tiering_status = None
        self.recall_status = None


class ServerEndpointCloudTieringStatus(Model):
    """Server endpoint cloud tiering status object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar health: Cloud tiering health state. Possible values include:
     'Healthy', 'Error'
    :vartype health: str or ~azure.mgmt.storagesync.models.enum
    :ivar last_updated_timestamp: Last updated timestamp
    :vartype last_updated_timestamp: datetime
    :ivar last_cloud_tiering_result: Last cloud tiering result (HResult)
    :vartype last_cloud_tiering_result: int
    :ivar last_success_timestamp: Last cloud tiering success timestamp
    :vartype last_success_timestamp: datetime
    """

    _validation = {
        'health': {'readonly': True},
        'last_updated_timestamp': {'readonly': True},
        'last_cloud_tiering_result': {'readonly': True},
        'last_success_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'health': {'key': 'health', 'type': 'str'},
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'last_cloud_tiering_result': {'key': 'lastCloudTieringResult', 'type': 'int'},
        'last_success_timestamp': {'key': 'lastSuccessTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointCloudTieringStatus, self).__init__(**kwargs)
        self.health = None
        self.last_updated_timestamp = None
        self.last_cloud_tiering_result = None
        self.last_success_timestamp = None


class ServerEndpointCreateParameters(ProxyResource):
    """The parameters used when creating a server endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param server_local_path: Server Local path.
    :type server_local_path: str
    :param cloud_tiering: Cloud Tiering. Possible values include: 'on', 'off'
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.enum
    :param volume_free_space_percent: Level of free space to be maintained by
     Cloud Tiering if it is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param friendly_name: Friendly Name
    :type friendly_name: str
    :param server_resource_id: Server Resource Id.
    :type server_resource_id: str
    :param offline_data_transfer: Offline data transfer. Possible values
     include: 'on', 'off'
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.enum
    :param offline_data_transfer_share_name: Offline data transfer share name
    :type offline_data_transfer_share_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_local_path': {'key': 'properties.serverLocalPath', 'type': 'str'},
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'server_resource_id': {'key': 'properties.serverResourceId', 'type': 'str'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
    }

    def __init__(self, *, server_local_path: str=None, cloud_tiering=None, volume_free_space_percent: int=None, tier_files_older_than_days: int=None, friendly_name: str=None, server_resource_id: str=None, offline_data_transfer=None, offline_data_transfer_share_name: str=None, **kwargs) -> None:
        super(ServerEndpointCreateParameters, self).__init__(**kwargs)
        self.server_local_path = server_local_path
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.friendly_name = friendly_name
        self.server_resource_id = server_resource_id
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_share_name = offline_data_transfer_share_name


class ServerEndpointFilesNotSyncingError(Model):
    """Files not syncing error object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_code: Error code (HResult)
    :vartype error_code: int
    :ivar persistent_count: Count of persistent files not syncing with the
     specified error code
    :vartype persistent_count: long
    :ivar transient_count: Count of transient files not syncing with the
     specified error code
    :vartype transient_count: long
    """

    _validation = {
        'error_code': {'readonly': True},
        'persistent_count': {'readonly': True, 'minimum': 0},
        'transient_count': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'persistent_count': {'key': 'persistentCount', 'type': 'long'},
        'transient_count': {'key': 'transientCount', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointFilesNotSyncingError, self).__init__(**kwargs)
        self.error_code = None
        self.persistent_count = None
        self.transient_count = None


class ServerEndpointRecallError(Model):
    """Server endpoint recall error object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error_code: Error code (HResult)
    :vartype error_code: int
    :ivar count: Count of occurences of the error
    :vartype count: long
    """

    _validation = {
        'error_code': {'readonly': True},
        'count': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointRecallError, self).__init__(**kwargs)
        self.error_code = None
        self.count = None


class ServerEndpointRecallStatus(Model):
    """Server endpoint recall status object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar last_updated_timestamp: Last updated timestamp
    :vartype last_updated_timestamp: datetime
    :ivar total_recall_errors_count: Total count of recall errors.
    :vartype total_recall_errors_count: long
    :ivar recall_errors: Array of recall errors
    :vartype recall_errors:
     list[~azure.mgmt.storagesync.models.ServerEndpointRecallError]
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'total_recall_errors_count': {'readonly': True, 'minimum': 0},
        'recall_errors': {'readonly': True},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'total_recall_errors_count': {'key': 'totalRecallErrorsCount', 'type': 'long'},
        'recall_errors': {'key': 'recallErrors', 'type': '[ServerEndpointRecallError]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointRecallStatus, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.total_recall_errors_count = None
        self.recall_errors = None


class ServerEndpointSyncActivityStatus(Model):
    """Sync Session status object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar timestamp: Timestamp when properties were updated
    :vartype timestamp: datetime
    :ivar per_item_error_count: Per item error count
    :vartype per_item_error_count: long
    :ivar applied_item_count: Applied item count.
    :vartype applied_item_count: long
    :ivar total_item_count: Total item count (if available)
    :vartype total_item_count: long
    :ivar applied_bytes: Applied bytes
    :vartype applied_bytes: long
    :ivar total_bytes: Total bytes (if available)
    :vartype total_bytes: long
    """

    _validation = {
        'timestamp': {'readonly': True},
        'per_item_error_count': {'readonly': True, 'minimum': 0},
        'applied_item_count': {'readonly': True, 'minimum': 0},
        'total_item_count': {'readonly': True, 'minimum': 0},
        'applied_bytes': {'readonly': True, 'minimum': 0},
        'total_bytes': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'per_item_error_count': {'key': 'perItemErrorCount', 'type': 'long'},
        'applied_item_count': {'key': 'appliedItemCount', 'type': 'long'},
        'total_item_count': {'key': 'totalItemCount', 'type': 'long'},
        'applied_bytes': {'key': 'appliedBytes', 'type': 'long'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointSyncActivityStatus, self).__init__(**kwargs)
        self.timestamp = None
        self.per_item_error_count = None
        self.applied_item_count = None
        self.total_item_count = None
        self.applied_bytes = None
        self.total_bytes = None


class ServerEndpointSyncSessionStatus(Model):
    """Sync Session status object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar last_sync_result: Last sync result (HResult)
    :vartype last_sync_result: int
    :ivar last_sync_timestamp: Last sync timestamp
    :vartype last_sync_timestamp: datetime
    :ivar last_sync_success_timestamp: Last sync success timestamp
    :vartype last_sync_success_timestamp: datetime
    :ivar last_sync_per_item_error_count: Last sync per item error count.
    :vartype last_sync_per_item_error_count: long
    :ivar persistent_files_not_syncing_count: Count of persistent files not
     syncing.
    :vartype persistent_files_not_syncing_count: long
    :ivar transient_files_not_syncing_count: Count of transient files not
     syncing.
    :vartype transient_files_not_syncing_count: long
    :ivar files_not_syncing_errors: Array of per-item errors coming from the
     last sync session.
    :vartype files_not_syncing_errors:
     list[~azure.mgmt.storagesync.models.ServerEndpointFilesNotSyncingError]
    """

    _validation = {
        'last_sync_result': {'readonly': True},
        'last_sync_timestamp': {'readonly': True},
        'last_sync_success_timestamp': {'readonly': True},
        'last_sync_per_item_error_count': {'readonly': True, 'minimum': 0},
        'persistent_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'transient_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'files_not_syncing_errors': {'readonly': True},
    }

    _attribute_map = {
        'last_sync_result': {'key': 'lastSyncResult', 'type': 'int'},
        'last_sync_timestamp': {'key': 'lastSyncTimestamp', 'type': 'iso-8601'},
        'last_sync_success_timestamp': {'key': 'lastSyncSuccessTimestamp', 'type': 'iso-8601'},
        'last_sync_per_item_error_count': {'key': 'lastSyncPerItemErrorCount', 'type': 'long'},
        'persistent_files_not_syncing_count': {'key': 'persistentFilesNotSyncingCount', 'type': 'long'},
        'transient_files_not_syncing_count': {'key': 'transientFilesNotSyncingCount', 'type': 'long'},
        'files_not_syncing_errors': {'key': 'filesNotSyncingErrors', 'type': '[ServerEndpointFilesNotSyncingError]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointSyncSessionStatus, self).__init__(**kwargs)
        self.last_sync_result = None
        self.last_sync_timestamp = None
        self.last_sync_success_timestamp = None
        self.last_sync_per_item_error_count = None
        self.persistent_files_not_syncing_count = None
        self.transient_files_not_syncing_count = None
        self.files_not_syncing_errors = None


class ServerEndpointSyncStatus(Model):
    """Server Endpoint sync status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar download_health: Download Health Status. Possible values include:
     'Healthy', 'Error', 'SyncBlockedForRestore',
     'SyncBlockedForChangeDetectionPostRestore', 'NoActivity'
    :vartype download_health: str or ~azure.mgmt.storagesync.models.enum
    :ivar upload_health: Upload Health Status. Possible values include:
     'Healthy', 'Error', 'SyncBlockedForRestore',
     'SyncBlockedForChangeDetectionPostRestore', 'NoActivity'
    :vartype upload_health: str or ~azure.mgmt.storagesync.models.enum
    :ivar combined_health: Combined Health Status. Possible values include:
     'Healthy', 'Error', 'SyncBlockedForRestore',
     'SyncBlockedForChangeDetectionPostRestore', 'NoActivity'
    :vartype combined_health: str or ~azure.mgmt.storagesync.models.enum
    :ivar sync_activity: Sync activity. Possible values include: 'Upload',
     'Download', 'UploadAndDownload'
    :vartype sync_activity: str or ~azure.mgmt.storagesync.models.enum
    :ivar total_persistent_files_not_syncing_count: Total count of persistent
     files not syncing (combined upload + download).
    :vartype total_persistent_files_not_syncing_count: long
    :ivar last_updated_timestamp: Last Updated Timestamp
    :vartype last_updated_timestamp: datetime
    :ivar upload_status: Upload Status
    :vartype upload_status:
     ~azure.mgmt.storagesync.models.ServerEndpointSyncSessionStatus
    :ivar download_status: Download Status
    :vartype download_status:
     ~azure.mgmt.storagesync.models.ServerEndpointSyncSessionStatus
    :ivar upload_activity: Upload sync activity
    :vartype upload_activity:
     ~azure.mgmt.storagesync.models.ServerEndpointSyncActivityStatus
    :ivar download_activity: Download sync activity
    :vartype download_activity:
     ~azure.mgmt.storagesync.models.ServerEndpointSyncActivityStatus
    :ivar offline_data_transfer_status: Offline Data Transfer State. Possible
     values include: 'InProgress', 'Stopping', 'NotRunning', 'Complete'
    :vartype offline_data_transfer_status: str or
     ~azure.mgmt.storagesync.models.enum
    """

    _validation = {
        'download_health': {'readonly': True},
        'upload_health': {'readonly': True},
        'combined_health': {'readonly': True},
        'sync_activity': {'readonly': True},
        'total_persistent_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'last_updated_timestamp': {'readonly': True},
        'upload_status': {'readonly': True},
        'download_status': {'readonly': True},
        'upload_activity': {'readonly': True},
        'download_activity': {'readonly': True},
        'offline_data_transfer_status': {'readonly': True},
    }

    _attribute_map = {
        'download_health': {'key': 'downloadHealth', 'type': 'str'},
        'upload_health': {'key': 'uploadHealth', 'type': 'str'},
        'combined_health': {'key': 'combinedHealth', 'type': 'str'},
        'sync_activity': {'key': 'syncActivity', 'type': 'str'},
        'total_persistent_files_not_syncing_count': {'key': 'totalPersistentFilesNotSyncingCount', 'type': 'long'},
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'upload_status': {'key': 'uploadStatus', 'type': 'ServerEndpointSyncSessionStatus'},
        'download_status': {'key': 'downloadStatus', 'type': 'ServerEndpointSyncSessionStatus'},
        'upload_activity': {'key': 'uploadActivity', 'type': 'ServerEndpointSyncActivityStatus'},
        'download_activity': {'key': 'downloadActivity', 'type': 'ServerEndpointSyncActivityStatus'},
        'offline_data_transfer_status': {'key': 'offlineDataTransferStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerEndpointSyncStatus, self).__init__(**kwargs)
        self.download_health = None
        self.upload_health = None
        self.combined_health = None
        self.sync_activity = None
        self.total_persistent_files_not_syncing_count = None
        self.last_updated_timestamp = None
        self.upload_status = None
        self.download_status = None
        self.upload_activity = None
        self.download_activity = None
        self.offline_data_transfer_status = None


class ServerEndpointUpdateParameters(Model):
    """Parameters for updating an Server Endpoint.

    :param cloud_tiering: Cloud Tiering. Possible values include: 'on', 'off'
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.enum
    :param volume_free_space_percent: Level of free space to be maintained by
     Cloud Tiering if it is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param offline_data_transfer: Offline data transfer. Possible values
     include: 'on', 'off'
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.enum
    :param offline_data_transfer_share_name: Offline data transfer share name
    :type offline_data_transfer_share_name: str
    """

    _validation = {
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
    }

    def __init__(self, *, cloud_tiering=None, volume_free_space_percent: int=None, tier_files_older_than_days: int=None, offline_data_transfer=None, offline_data_transfer_share_name: str=None, **kwargs) -> None:
        super(ServerEndpointUpdateParameters, self).__init__(**kwargs)
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_share_name = offline_data_transfer_share_name


class StorageSyncApiError(Model):
    """Error type.

    :param code: Error code of the given entry.
    :type code: str
    :param message: Error message of the given entry.
    :type message: str
    :param target: Target of the given error entry.
    :type target: str
    :param details: Error details of the given entry.
    :type details: ~azure.mgmt.storagesync.models.StorageSyncErrorDetails
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': 'StorageSyncErrorDetails'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(StorageSyncApiError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class StorageSyncError(Model):
    """Error type.

    :param error: Error details of the given entry.
    :type error: ~azure.mgmt.storagesync.models.StorageSyncApiError
    :param innererror: Error details of the given entry.
    :type innererror: ~azure.mgmt.storagesync.models.StorageSyncApiError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'StorageSyncApiError'},
        'innererror': {'key': 'innererror', 'type': 'StorageSyncApiError'},
    }

    def __init__(self, *, error=None, innererror=None, **kwargs) -> None:
        super(StorageSyncError, self).__init__(**kwargs)
        self.error = error
        self.innererror = innererror


class StorageSyncErrorException(HttpOperationError):
    """Server responsed with exception of type: 'StorageSyncError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(StorageSyncErrorException, self).__init__(deserialize, response, 'StorageSyncError', *args)


class StorageSyncErrorDetails(Model):
    """Error Details object.

    :param code: Error code of the given entry.
    :type code: str
    :param message: Error message of the given entry.
    :type message: str
    :param target: Target of the given entry.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, **kwargs) -> None:
        super(StorageSyncErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageSyncService(TrackedResource):
    """Storage Sync Service object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :ivar storage_sync_service_status: Storage Sync service status.
    :vartype storage_sync_service_status: int
    :ivar storage_sync_service_uid: Storage Sync service Uid
    :vartype storage_sync_service_uid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'storage_sync_service_status': {'readonly': True},
        'storage_sync_service_uid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'storage_sync_service_status': {'key': 'properties.storageSyncServiceStatus', 'type': 'int'},
        'storage_sync_service_uid': {'key': 'properties.storageSyncServiceUid', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(StorageSyncService, self).__init__(tags=tags, location=location, **kwargs)
        self.storage_sync_service_status = None
        self.storage_sync_service_uid = None


class StorageSyncServiceCreateParameters(Model):
    """The parameters used when creating a storage sync service.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Required. Gets or sets the location of the
     resource. This will be one of the supported and registered Azure Geo
     Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a
     resource cannot be changed once it is created, but if an identical geo
     region is specified on update, the request will succeed.
    :type location: str
    :param tags: Gets or sets a list of key value pairs that describe the
     resource. These tags can be used for viewing and grouping this resource
     (across resource groups). A maximum of 15 tags can be provided for a
     resource. Each tag must have a key with a length no greater than 128
     characters and a value with a length no greater than 256 characters.
    :type tags: dict[str, str]
    :param properties:
    :type properties: object
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, location: str, tags=None, properties=None, **kwargs) -> None:
        super(StorageSyncServiceCreateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class StorageSyncServiceUpdateParameters(Model):
    """Parameters for updating an Storage sync service.

    :param tags: The user-specified tags associated with the storage sync
     service.
    :type tags: dict[str, str]
    :param properties: The properties of the storage sync service.
    :type properties: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, tags=None, properties=None, **kwargs) -> None:
        super(StorageSyncServiceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SubscriptionState(Model):
    """Subscription State object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param state: State of Azure Subscription. Possible values include:
     'Registered', 'Unregistered', 'Warned', 'Suspended', 'Deleted'
    :type state: str or ~azure.mgmt.storagesync.models.Reason
    :ivar istransitioning: Is Transitioning
    :vartype istransitioning: bool
    :param properties: Subscription state properties.
    :type properties: object
    """

    _validation = {
        'istransitioning': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'istransitioning': {'key': 'istransitioning', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, state=None, properties=None, **kwargs) -> None:
        super(SubscriptionState, self).__init__(**kwargs)
        self.state = state
        self.istransitioning = None
        self.properties = properties


class SyncGroup(ProxyResource):
    """Sync Group object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar unique_id: Unique Id
    :vartype unique_id: str
    :ivar sync_group_status: Sync group status
    :vartype sync_group_status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unique_id': {'readonly': True},
        'sync_group_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'sync_group_status': {'key': 'properties.syncGroupStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SyncGroup, self).__init__(**kwargs)
        self.unique_id = None
        self.sync_group_status = None


class SyncGroupCreateParameters(ProxyResource):
    """The parameters used when creating a sync group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param properties: The parameters used to create the sync group
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(SyncGroupCreateParameters, self).__init__(**kwargs)
        self.properties = properties


class TriggerChangeDetectionParameters(Model):
    """The parameters used when calling trigger change detection action on cloud
    endpoint.

    :param directory_path: Relative path to a directory Azure File share for
     which change detection is to be performed.
    :type directory_path: str
    :param change_detection_mode: Change Detection Mode. Applies to a
     directory specified in directoryPath parameter. Possible values include:
     'Default', 'Recursive'
    :type change_detection_mode: str or
     ~azure.mgmt.storagesync.models.ChangeDetectionMode
    :param paths: Array of relative paths on the Azure File share to be
     included in the change detection. Can be files and directories.
    :type paths: list[str]
    """

    _attribute_map = {
        'directory_path': {'key': 'directoryPath', 'type': 'str'},
        'change_detection_mode': {'key': 'changeDetectionMode', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[str]'},
    }

    def __init__(self, *, directory_path: str=None, change_detection_mode=None, paths=None, **kwargs) -> None:
        super(TriggerChangeDetectionParameters, self).__init__(**kwargs)
        self.directory_path = directory_path
        self.change_detection_mode = change_detection_mode
        self.paths = paths


class TriggerRolloverRequest(Model):
    """Trigger Rollover Request.

    :param server_certificate: Certificate Data
    :type server_certificate: str
    """

    _attribute_map = {
        'server_certificate': {'key': 'serverCertificate', 'type': 'str'},
    }

    def __init__(self, *, server_certificate: str=None, **kwargs) -> None:
        super(TriggerRolloverRequest, self).__init__(**kwargs)
        self.server_certificate = server_certificate


class Workflow(ProxyResource):
    """Workflow resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param last_step_name: last step name
    :type last_step_name: str
    :param status: workflow status. Possible values include: 'active',
     'expired', 'succeeded', 'aborted', 'failed'
    :type status: str or ~azure.mgmt.storagesync.models.enum
    :param operation: operation direction. Possible values include: 'do',
     'undo', 'cancel'
    :type operation: str or ~azure.mgmt.storagesync.models.enum
    :param steps: workflow steps
    :type steps: str
    :param last_operation_id: workflow last operation identifier.
    :type last_operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_step_name': {'key': 'properties.lastStepName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'steps': {'key': 'properties.steps', 'type': 'str'},
        'last_operation_id': {'key': 'properties.lastOperationId', 'type': 'str'},
    }

    def __init__(self, *, last_step_name: str=None, status=None, operation=None, steps: str=None, last_operation_id: str=None, **kwargs) -> None:
        super(Workflow, self).__init__(**kwargs)
        self.last_step_name = last_step_name
        self.status = status
        self.operation = operation
        self.steps = steps
        self.last_operation_id = last_operation_id
