% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{symdiff}
\alias{symdiff}
\title{Symmetric set complement}
\usage{
symdiff(x, y)
}
\arguments{
\item{x}{a vector}

\item{y}{a vector}
}
\value{
\code{union(setdiff(x,y), setdiff(y,x))}
}
\description{
Symmetric set complement
}
\note{
that \code{symdiff(x,y)} is not \code{\link{identical}} 
as \code{symdiff(y,x)} without applying \code{\link{sort}} to the result
}
\examples{
symdiff(c(1L,2L,2L), c(2L,3L))
symdiff(c(2L,3L), c(1L,2L,2L))
}
\seealso{
\code{\link{merge_symdiff}} and \code{\link{xor}}
}
