% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_local}
\alias{map_local}
\alias{map_local_lgl}
\alias{map_local_chr}
\alias{map_local_int}
\alias{map_local_dbl}
\title{Map a function over a graph representing the neighborhood of each node}
\usage{
map_local(order = 1, mode = "all", mindist = 0, .f, ...)

map_local_lgl(order = 1, mode = "all", mindist = 0, .f, ...)

map_local_chr(order = 1, mode = "all", mindist = 0, .f, ...)

map_local_int(order = 1, mode = "all", mindist = 0, .f, ...)

map_local_dbl(order = 1, mode = "all", mindist = 0, .f, ...)
}
\arguments{
\item{order}{Integer giving the order of the neighborhood.}

\item{mode}{Character constant, it specifies how to use the direction of
the edges if a directed graph is analyzed. For \sQuote{out} only the
outgoing edges are followed, so all vertices reachable from the source
vertex in at most \code{order} steps are counted. For \sQuote{"in"} all
vertices from which the source vertex is reachable in at most \code{order}
steps are counted. \sQuote{"all"} ignores the direction of the edges. This
argument is ignored for undirected graphs.}

\item{mindist}{The minimum distance to include the vertex in the result.}

\item{.f}{A function to map over all nodes. See Details}

\item{...}{Additional parameters to pass to \code{.f}}
}
\value{
\code{map_local()} returns a list of the same length as the number of
nodes in the graph, in the order matching the node order in the graph.
\verb{map_local_*()} tries to coerce its result into a vector of the classes
\code{logical} (\code{map_local_lgl}), \code{character} (\code{map_local_chr}), \code{integer}
(\code{map_local_int}), or \code{double} (\code{map_local_dbl}). These functions will throw
an error if they are unsuccesful, so they are type safe.
}
\description{
This function extracts the neighborhood of each node as a graph and maps over
each of these neighborhood graphs. Conceptually it is similar to
\code{\link[igraph:local_scan]{igraph::local_scan()}}, but it borrows the type safe versions available in
\code{\link[=map_bfs]{map_bfs()}} and \code{\link[=map_dfs]{map_dfs()}}.
}
\details{
The function provided to \code{.f} will be called with the following arguments in
addition to those supplied through \code{...}:
\itemize{
\item \code{neighborhood}: The neighborhood graph of the node
\item \code{graph}: The full \code{tbl_graph} object
\item \code{node}: The index of the node currently mapped over
}

The \code{neighborhood} graph will contain an extra node attribute called
\code{.central_node}, which will be \code{TRUE} for the node that the neighborhood is
expanded from and \code{FALSE} for everything else.
}
\examples{
# Smooth out values over a neighborhood
create_notable('meredith') \%>\%
  mutate(value = rpois(graph_order(), 5)) \%>\%
  mutate(value_smooth = map_local_dbl(order = 2, .f = function(neighborhood, ...) {
    mean(as_tibble(neighborhood, active = 'nodes')$value)
  }))
}
