#ifndef xcontrol_shared_fd_h_
#define xcontrol_shared_fd_h_ 1

#include <unistd.h>

class shared_fd
{
public:
	inline explicit shared_fd(int = -1);
	inline shared_fd(shared_fd const &);
	inline ~shared_fd(void) throw();

	inline void reset(int = -1) throw();

	operator int(void) const throw()
	{
		return fd;
	}

	shared_fd &operator=(shared_fd const &);

	static shared_fd const devtty;
	static shared_fd const devnull;

private:
	int fd;
	mutable shared_fd const *next;
	mutable shared_fd const *prev;
};

inline shared_fd::shared_fd(int fd) :
	fd(fd),
	next(0),
	prev(0)
{
	return;
}

inline shared_fd::shared_fd(shared_fd const &fd) :
	fd(fd)
{
	prev = &fd;
	next = fd.next;
	fd.next = this;
	if(next)
		next->prev = this;
}

inline shared_fd::~shared_fd(void) throw()
{
	reset();
	return;
}

inline void shared_fd::reset(int newfd) throw()
{
	if(fd == newfd)
		return;
	if(prev)
		prev->next = next;
	if(next)
		next->prev = prev;
	if(!next && !prev && (fd != -1))
		::close(fd);
	fd = newfd;
	next = 0;
	prev = 0;
	return;
}

#endif
