@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-file-move: Move or Rename ECaccess Files
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = ( version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $sourceECaccessFile = $ARGV[0];
my $targetECaccessFile = $ARGV[1];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No source-ecaccess-file specified!\n" ) if not($sourceECaccessFile);
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No target-ecaccess-file specified!\n" ) if not($targetECaccessFile);

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# Delete the file
$controlChannel->moveFile( $token, $sourceECaccessFile, $targetECaccessFile );

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-file-move - Move or Rename ECaccess Files

=head1 SYNOPSIS

B<ecaccess-file-move -version|-help|-manual>

B<ecaccess-file-move [-debug]> I<source-ecaccess-file> I<target-ecaccess-file>

=head1 DESCRIPTION

Allow moving an ECaccess File. When the move occurs within the same ECaccess File System then it is a rename. When the
move occurs across two different ECaccess File Systems then first a copy is done and then a delete of the original file
is done (e.g. similar to ecaccess-file-copy ... -erase).

The I<source-ecaccess-file> and I<target-ecaccess-file> are in the form [domain:][/user-id/]path. Please read the
"Shell commands -> File Management" section of the "ecaccess" guide for more information on the ECaccess File System.

=head1 ARGUMENTS

=over 8

=item I<source-ecaccess-file>

The source ECaccess File name.

=item I<target-ecaccess-file>

The target ECaccess File name.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-file-move> I<ec:test1.txt> I<ec:test2.txt>

Rename the I<test1.txt> file in the ECFS directory of the authenticated user in I<test2.txt>.

B<ecaccess-file-move> I<ec:test1.txt> I<home:test2.txt>

Copy the I<test1.txt> file from the ECFS directory of the authenticated user to the I<test2.txt> file in the $HOME
directory of the authenticated user, then delete the I<test1.txt> file from ECFS.

=head1 SEE ALSO

B<ecaccess-file-delete>, B<ecaccess-file-get>, B<ecaccess-file-mget>, B<ecaccess-file-modtime>, B<ecaccess-file-mput>,
B<ecaccess-file-rmdir>, B<ecaccess-file-copy>, B<ecaccess-file-dir>, B<ecaccess-file-mdelete>, B<ecaccess-file-mkdir>,
B<ecaccess-file-chmod>, B<ecaccess-file-put>, B<ecaccess-file-size> and B<ecaccess>.

=cut

__END__
:endofperl
