/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2012 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include "support.h"


int combo_selection(GtkWidget *combo)
{
    GList *selected = NULL;
    GtkWidget* item = NULL;
    gint row_index  = 0;

    selected = GTK_LIST(GTK_COMBO(combo)->list)->selection;
    if( selected ) 
    {
        item = GTK_WIDGET(selected->data);
        row_index = gtk_list_child_position(GTK_LIST(GTK_COMBO(combo)->list), item);
        return row_index;
    }

    /* Return the first combo choice */    
    return 0;
}

static GList *pixmap_directories = NULL;

/* Use this function to set the directories containing installed pixmaps. */
void add_pixmap_directory(const gchar *directory)
{
    pixmap_directories = g_list_prepend(pixmap_directories,
                                         g_strdup(directory));
}


/* Function for finding pixmap files. */
static gchar *find_pixmap_file(const gchar *filename)
{
    GList *elem;

    /* Step through each of the pixmap directories to find it. */
    elem = pixmap_directories;
    while( elem )
    {
        gchar *pathname = g_strdup_printf("%s%s%s", (gchar*)elem->data,
                                            G_DIR_SEPARATOR_S, filename);
        if( g_file_test(pathname, G_FILE_TEST_EXISTS) )
            return pathname;
        g_free(pathname);
        elem = elem->next;
    }
    return NULL;
}

/* A function for creating pixbufs. */
GdkPixbuf *create_pixbuf(const gchar *filename)
{
      gchar *pathname = NULL;
      GdkPixbuf *pixbuf;
      GError *error = NULL;

      if( ! filename || ! filename[0] )
          return NULL;

      pathname = find_pixmap_file(filename);

      if( ! pathname )
      {
          g_warning(_("Couldn't find pixmap file: %s"), filename);
          return NULL;
      }

      pixbuf = gdk_pixbuf_new_from_file(pathname, &error);
      if( ! pixbuf )
      {
          fprintf(stderr, "Failed to load pixbuf file: %s: %s\n",
                                         pathname, error->message);
          g_error_free(error);
      }
      g_free(pathname);
      return pixbuf;
}
