# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class FunctionSecrets(ProxyOnlyResource):
    """Function secrets.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key: Secret key.
    :type key: str
    :param trigger_url: Trigger URL.
    :type trigger_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
        'trigger_url': {'key': 'properties.trigger_url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FunctionSecrets, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.trigger_url = kwargs.get('trigger_url', None)
