/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dnd_security.h"

#include <wmjack/dtk_wmjack.h>

#include <signal.h>
#include <wayland-client.h>

void sighandle(int sig)
{
    printf("capture signal %d", sig);

    DestoryDtkDisplay();
    // release
    exit(0);
}

int handle_security_verify(void *data, int types, int client, int target)
{
    // do somthting  client target
    // success return Permission::PermissionAllow
    // failed return Permission::PermissionDeny

    return PermissionDeny;
}

int main(int argc, char **argv)
{
    putenv("XDG_SESSION_TYPE=wayland");
    signal(2, sighandle);

    InitDtkDisplay();

    DoSecurityVerifyCallback(NULL, handle_security_verify);

    int window_id = 0;
    int session_id = GetSecuritySession(SecClipboardCopy);

    struct dtk_array* arrays = NULL; //GetAllWindowStates();
    if (arrays && arrays->size > 0) {
        WindowState *p;
        dtk_array_for_each(p, arrays, sizeof(WindowState)) {
            window_id = p->windowId;
            printf("=======pid = %d, windowid = %d, resourceName = %s=======", p->pid, p->windowId, p->resourceName);
        }
    }

    if (window_id != 0) {
        // get window info
        //GetWindowPid(window_id);
        //GetWindowState(window_id);
    }


    struct dtk_array* pids = GetSecurityClients();
    if (pids && pids->size > 0) {
        uint32_t *p;
        dtk_array_for_each(p, pids, sizeof(uint32_t)) {
            printf("=======pid = %d=======", *p);
        }

        dtk_array_release(pids);
    }

//    DestroySecuritySession(session_id);

    while (1) {
        sleep(2);
    }

    return 0;
}
