/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QTimer>

namespace Ui {
class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT

public:
    explicit Widget(QWidget *parent = nullptr);
    ~Widget();

private slots:
    void onGetCompositorSwitchStatus();

    void onToggleMultitaskView();

    void onMinimizeWindow();

    void onMaximizeWindow();

    void onGetWindowText();

    void onGetWindowSize();

    void onGetWindowPosition();

    void onGetActiveWindowID();

    void onGetDesktopWindowID();

    void onGetChildWindowIDs();

    void onGetPointerPosition();

    void onGetWindowPid();

    void onGetWindowFromPoint();

    void onShowSplitMenu();

    void onHideSplitMenu();

    void onGetDevicePerformanceLevel();

    void timerSlot();

    void timerSlot1();

    void timerSlot2();

private:
    Ui::Widget *ui;
    QTimer m_timer;
    QTimer m_timer1;
    QTimer m_timer2;
};

#endif // WIDGET_H
