#pragma once

#include <atomic>
#include <functional>
#include <pthread.h>

class Timer
{
public:
    Timer(int msec, bool single, void *parent);
    ~Timer();

    bool start(std::function<void(void *)> function, unsigned int count = 1);
    void setCount(unsigned int count);
    void stop();
    bool isStop();
    bool isActive();
    void run();

private:
    std::atomic<int> m_interval{100};
    std::atomic<unsigned int> m_count{1};
    std::atomic<bool> m_single{true};
    std::atomic<bool> m_active{false};
    std::atomic<bool> m_stop{true};
    pthread_t m_threadId{0};
    void *m_parent = nullptr;
    std::function<void(void *)> m_function = nullptr;
};
