#pragma once

#include <vector>
#include <string>

#include <xcb/xcb.h>

class XwlUtils
{
public:
    static xcb_atom_t getAtom(const char *str, xcb_connection_t *xcbConn);
    static std::string atomName(xcb_atom_t atom, xcb_connection_t *xcbConn);
    static std::vector<std::string> atomToMimeTypes(xcb_atom_t atom, xcb_connection_t *xcbConn);
    static xcb_atom_t mimeTypeToAtom(const std::string &mimeType, xcb_connection_t *xcbConn);
    static xcb_atom_t mimeTypeToAtomLiteral(const std::string &mimeType, xcb_connection_t *xcbConn);
    static xcb_window_t getSelectionOwner(xcb_connection_t *xcbConn);

private:
    XwlUtils() {}
    ~XwlUtils() {}
};
