// SPDX-FileCopyrightText: 2011 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef CLIPBOARDDATAPROCESS_H
#define CLIPBOARDDATAPROCESS_H

#include <string>
#include <map>
#include <vector>

using namespace std;

const int WindowWidth = 300;
const int WindowMargin = 10; // 边距
const int WindowTitleHeight = 56;
const int ItemTitleHeight = 36;     // Item标题栏高度
const int ItemStatusBarHeight = 30; // Item状态栏高度
const int ItemWidth = WindowWidth - 2 * WindowMargin;
const int ItemHeight = 200;
const int ItemMargin = 10;
const int PixmapWidth = 180;  // 图像最大显示宽度
const int PixmapHeight = 100; // 图像最大显示高度
const int FileIconWidth = PixmapWidth;
const int FileIconHeight = PixmapHeight;
const int PixmapxStep = 15;
const int PixmapyStep = 5;
const int ContentMargin = 21;
const int TextContentTopMargin = 20;
const int AnimationTime = 300; // ms

const int TextSmalllen = 300; // 长度

const string TextUriListLiteral = ("text/uri-list");
const string TextHtmlLiteral = ("text/html");
const string TextPlainLiteral = ("text/plain");
const string ApplicationXColorLiteral = ("application/x-color");
const string ApplicationXQtImageLiteral = ("application/x-qt-image");

const string cachedataDir = "/clipboard/Data";            // 数据缓存目录名
const string cachePropertyDir = "/clipboard/Property";    // 属性缓存目录名
const int MAX_BETYARRAY_SIZE = 10 * 1024 * 1024; // 最大支持的文本大小

// 定义文件头结构体
struct datafile_header {
    int magic; // 魔数，用于标识文件类型
    int version; // 版本号，用于标识文件的格式或内容
    int width;
    int height;
    uint32_t size; // 文件大小，不包括文件头
};

struct ClipboardDataRecord;
struct ClipboardDataProperty;
class ClipDataRecord;
class ClipDataProperty;
class ClipData;
class ClipboardDataProcess
{
public:
    static long long getCurrentTime();
    static vector<string> getMapKeys(map<string, string> &formatMap);

    static bool isContains(const vector<string> &liststr, const string str);

    static bool isExists(const vector<string> &liststr, const string str);

    static bool isFileContains(const vector<string> &liststr, const string str);

    static string sha256(const std::string &file);

    static bool compareFiles(const std::string &file1, const std::string &file2);

    static vector<char> readImage(const char *filename);

    static vector<char> readText(const char *filename);

    static vector<char> getData(const char *filename);
    static vector<char> getLenData(const char *filename, const int len);

    static uint32_t getDataLength(const char *filename);
    static datafile_header getDataHead(const char *filename);

    static bool scaleImage(const std::vector<char> &original, std::vector<char> &scaled, int scaledWidth, int scaledHeight);

    static FILE *create_file_header(const char *filename, int version);
    static void write_file_data(FILE *fp, char *data, int length);
    static void update_file_size(FILE *fp, int size);
    static void update_file_img_size(FILE *fp, int w, int h);
    static void close_file(FILE *fp);
    static FILE *read_file_header(const char *filename, datafile_header *header);
    static void read_file_data(FILE *fp, char *data, int length);
    static int verify_file_header(datafile_header *header, int version);
    static void update_file_img_size(const char *filename, int w, int h);

    static int convertClipRecordData(ClipDataRecord *vClipRecordData, ClipboardDataRecord *vOut);
    static int convertClipPropertyData(ClipDataProperty *vClipPropertyData, ClipboardDataProperty *vOut, string name);

    static string getClipboardDir(const string &str);
    static string getClipboardDataFileName();

    static bool create_multi_dir(const char *dir);
    static int isDirExist(const char *dir);
    static void delete_directory(const char *dir);
    static int delete_file(const char *dir);

    static vector<string> splitString(const vector<char> &vData, const string &vStr);
    static void delete_non_list_files(const std::string &indir, const std::vector<std::string> &liststr);

    static ClipData *compareData(ClipData *vClipPtr);

private:
    ClipboardDataProcess();
};

#endif // CLIPBOARDLOADER_H
