// SPDX-FileCopyrightText: 2019 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef IMAGEDATAPROCESS_H
#define IMAGEDATAPROCESS_H

#include <QImage>
#include <QVariant>
#include <vector>

using namespace std;

class ImageDataProcess
{
public:
    static QVariant toVariant(const QImage &pixmap);
    static QImage toImage(const QVariant &variant);

    static vector<char> scaleImage(const vector<char> &vData, const string type, int &w, int &h, int &rw, int &rh);

    static QImage toImage(const vector<char> &vData, const string type);

private:
    ImageDataProcess();
};

#endif
