/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fannj;

import com.googlecode.fannj.Fann;
import com.googlecode.fannj.TrainingAlgorithm;
import com.googlecode.fannj.WindowsFunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.Map;

public class Trainer {
    Fann fann;

    public Trainer(Fann fann) {
        this.fann = fann;
    }

    public float train(String trainingFile, int maxEpochs, int epochsBetweenReports, float desiredError) {
        Trainer.fann_train_on_file(this.fann.ann, trainingFile, maxEpochs, epochsBetweenReports, desiredError);
        return Trainer.fann_get_MSE(this.fann.ann);
    }

    public float cascadeTrain(String dataFile, int maxNeurons, int neuronsBetweenReports, float desiredError) {
        this.setTrainingAlgorithm(TrainingAlgorithm.FANN_TRAIN_RPROP);
        Trainer.fann_cascadetrain_on_file(this.fann.ann, dataFile, maxNeurons, neuronsBetweenReports, desiredError);
        return Trainer.fann_get_MSE(this.fann.ann);
    }

    public void setTrainingAlgorithm(TrainingAlgorithm algorithm) {
        Trainer.fann_set_training_algorithm(this.fann.ann, algorithm.ordinal());
    }

    public float test(String testingFile) {
        Trainer.fann_reset_MSE(this.fann.ann);
        Pointer testingData = Trainer.fann_read_train_from_file(testingFile);
        Trainer.fann_test_data(this.fann.ann, testingData);
        Trainer.fann_destroy_train(testingData);
        return Trainer.fann_get_MSE(this.fann.ann);
    }

    protected static native void fann_train_on_file(Pointer var0, String var1, int var2, int var3, float var4);

    protected static native void fann_cascadetrain_on_file(Pointer var0, String var1, int var2, int var3, float var4);

    protected static native void fann_set_training_algorithm(Pointer var0, int var1);

    protected static native int fann_get_training_algorithm(Pointer var0);

    protected static native void fann_reset_MSE(Pointer var0);

    protected static native float fann_get_MSE(Pointer var0);

    protected static native float fann_test_data(Pointer var0, Pointer var1);

    protected static native Pointer fann_read_train_from_file(String var0);

    protected static native void fann_destroy_train(Pointer var0);

    static {
        NativeLibrary fann;
        if (Platform.isWindows()) {
            fann = NativeLibrary.getInstance((String)"fannfloat");
            Map options = fann.getOptions();
            options.put("calling-convention", 1);
            options.put("function-mapper", new WindowsFunctionMapper());
        } else {
            fann = NativeLibrary.getInstance((String)"fann");
        }
        Native.register((NativeLibrary)fann);
    }
}

