/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var tape = require( 'tape' );
var proxyquire = require( 'proxyquire' );
var PATH_DELIMITER_POSIX = require( './../../../path/delimiter-posix' );
var PATH_DELIMITER_WIN32 = require( './../../../path/delimiter-win32' );
var PATH_DELIMITER = require( './../lib' );


// TESTS //

tape( 'main export is a string', function test( t ) {
	t.ok( true, __filename );
	t.equal( typeof PATH_DELIMITER, 'string', 'main export is a string' );
	t.end();
});

tape( 'if platform is POSIX, export is the POSIX path delimiter', function test( t ) {
	var PATH_DELIMITER = proxyquire( './../lib', {
		'@stdlib/assert/is-windows': false
	});
	t.equal( PATH_DELIMITER, PATH_DELIMITER_POSIX, 'equals POSIX delimiter' );
	t.end();
});

tape( 'if platform is Windows, export is the Windows path delimiter', function test( t ) {
	var PATH_DELIMITER = proxyquire( './../lib', {
		'@stdlib/assert/is-windows': true
	});
	t.equal( PATH_DELIMITER, PATH_DELIMITER_WIN32, 'equals Windows delimiter' );
	t.end();
});
