.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_QUOTE" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_quote \- escapes a string for inclusion into SQL statements

.SH SYNOPSIS

.nf
pg_quote [-null] [\fIconnection\fR] \fIstring\fR
.fi
.SH "DESCRIPTION"
.PP
\fBpg_quote\fR quotes a string and escapes single
quotes and backslashes within the string, making it safe for inclusion
into SQL statements.
.PP
If a \fIconnection\fR is provided, the connection is used to
customize the quoting process for the database referenced by the connection.
.PP
If the [-null] option is provided, then if the text matches
the null string (either the empty string, or the null string specified in the
\fIconnection\fR) then the SQL keyword NULL is returned, rather than
a quoted string.
.PP
If you're doing something like

.nf
    pg_exec $conn "insert into foo values ('$name');" 
.fi
and name contains text includeng an unescaped single
quote, such as Bob's House, at best the insert will fail, and
at worst your software will be exploited via an SQL injection attack.
Passing value strings through \fBpg_quote\fR
will properly quote them for insertion into SQL commands.

.nf
    pg_exec $conn "insert into foo values ([pg_quote $name]);" 
.fi
\&...will make sure that any special characters that occur in name, such as
single quote or backslash, will be properly quoted.
.SH "ARGUMENTS"
.TP
\fB\fIstring\fB\fR
The string to be escaped.
.SH "RETURN VALUE"
.PP
Returns the string, escaped for inclusion into SQL queries.  Note that
it adds a set of single quotes around the outside of the string as well.
.SH "SEE ALSO"
.PP
In most cases, with recent versions of SQL, it is better to use the native parameter insertion capabilities
of the SQL server and protocol. If you are using a version of PostgreSQL more recent then 7.4, consider the
optional parameter arguments to pg_exec and pg_sendquery, and the paramarray option to pg_exec, pg_sendquery, and
pg_select.
