/*
* Copyright (C) 2019 ~ 2021 Uniontech Software Technology Co.,Ltd.
*
* Author:     xiepengfei <xiepengfei@uniontech.com>
*
* Maintainer: xiepengfei <xiepengfei@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "quicklystartwidget.h"

#include <QVBoxLayout>
#include <DLabel>
#include <DFontSizeManager>

#define SIZE 160, 108

QuicklyStartWidget::QuicklyStartWidget(QPixmap pixmap, QString text, QWidget *parent)
    :DFrame (parent),
     m_text(text),
     m_pixmap(pixmap)
{
    setFixedSize(SIZE);
    setLineWidth(0);
    m_hover = false;
    QPalette pa = this->palette();
    pa.setColor(QPalette::Base, Qt::white);
    setPalette(pa);
    DFontSizeManager::instance()->bind(this, DFontSizeManager::T8, QFont::DemiBold);

//    QVBoxLayout *layout = new QVBoxLayout;
//    layout->setSpacing(0);
//    layout->setContentsMargins(0, 0, 0, 0);
//    setLayout(layout);

//    DLabel *image = new DLabel;
//    QSize size(158, 108);
//    size = size * devicePixelRatioF();
//    QPixmap load = pixmap.scaled(size, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
//    image->setPixmap(load);

//    layout->addWidget(image);
//    layout->addStretch();
    show();
}

void QuicklyStartWidget::paintEvent(QPaintEvent *event)
{
    QPainter painter(this);
    painter.setPen(QPen(QColor(0, 0, 0, 0.8 * 255)));
    painter.setRenderHint(QPainter::SmoothPixmapTransform);
    QFontMetrics fm(painter.font());
    int textwidth = fm.horizontalAdvance(m_text);

    QSize size(158, 108);
    size = size * devicePixelRatioF();
    QPixmap load = m_pixmap.scaled(size, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
    painter.drawPixmap(rect(), load);

    painter.setPen(QColor(255, 255, 255, 0.9*255));
    painter.drawText(QRect((width() - textwidth) / 2, 82, textwidth, fm.height()), Qt::AlignCenter, m_text);
    if (m_hover) {
        painter.setPen(Qt::NoPen);
        painter.setBrush(QBrush(QColor(0, 0, 0, 0.05*255)));
        painter.drawRoundedRect(rect(), 12, 20);
    }
}

void QuicklyStartWidget::enterEvent(EnterEvent *event)
{
    m_hover = true;
    update();
    DFrame::enterEvent(event);
}

void QuicklyStartWidget::leaveEvent(QEvent *event)
{
    m_hover = false;
    update();
    DFrame::leaveEvent(event);
}

void QuicklyStartWidget::mouseReleaseEvent(QMouseEvent *event)
{
    emit clicked();
    DFrame::mouseReleaseEvent(event);
}
