// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef MODELREPO_H
#define MODELREPO_H

#include "global_header.h"

#include <QObject>

GLOBAL_BEGIN_NAMESPACE

typedef QPair<QString, QString> ModelProperty;

class ModelInfo;
class ModelRepoPrivate;
class ModelRepo : public QObject
{
    Q_OBJECT
    friend class ModelRepoPrivate;
public:
    explicit ModelRepo(QObject *parent = nullptr);
    void setRepoPath(const QStringList &path);
    QStringList list() const;
    QList<ModelProperty> show(const QString &model) const;
    QSharedPointer<ModelInfo> modelInfo(const QString &model) const;
signals:

public slots:
private:
    ModelRepoPrivate *d;
};

GLOBAL_END_NAMESPACE

#endif // MODELREPO_H
