// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef OVMODELCONFIG_H
#define OVMODELCONFIG_H

#include "global_header.h"

#include <QVariantHash>

GLOBAL_BEGIN_NAMESPACE

class OVModelConfig
{
public:
    explicit OVModelConfig(const QString &file);
    inline QString model() const {
        return read("model");
    }
    inline QString tokenizer() const {
        return read("tokenizer");
    }
    QStringList architectures() const;
protected:
    QString read(const QString &key) const {
        return configs.value(key, QString()).toString();
    }
private:
    QVariantHash configs;
};

GLOBAL_END_NAMESPACE

#endif // OVMODELCONFIG_H
