/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@StatelessCheck
public final class MissingOverrideCheck
extends AbstractCheck {
    public static final String MSG_KEY_TAG_NOT_VALID_ON = "tag.not.valid.on";
    public static final String MSG_KEY_ANNOTATION_MISSING_OVERRIDE = "annotation.missing.override";
    private static final Pattern MATCH_INHERIT_DOC = CommonUtil.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private boolean javaFiveCompatibility;

    public void setJavaFiveCompatibility(boolean compatibility) {
        this.javaFiveCompatibility = compatibility;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean containsTag = MissingOverrideCheck.containsInheritDocTag(ast);
        if (containsTag && !JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
            this.log(ast, MSG_KEY_TAG_NOT_VALID_ON, JavadocTagInfo.INHERIT_DOC.getText());
        } else {
            DetailAST defOrNew;
            boolean check = true;
            if (this.javaFiveCompatibility && ((defOrNew = ast.getParent().getParent()).findFirstToken(18) != null || defOrNew.findFirstToken(19) != null || defOrNew.getType() == 136)) {
                check = false;
            }
            if (check && containsTag && !AnnotationUtil.hasOverrideAnnotation(ast)) {
                this.log(ast, MSG_KEY_ANNOTATION_MISSING_OVERRIDE, new Object[0]);
            }
        }
    }

    private static boolean containsInheritDocTag(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST startNode = modifiers.hasChildren() ? Optional.ofNullable(ast.getFirstChild().findFirstToken(159)).orElse(modifiers) : ast.findFirstToken(13);
        Optional<String> javadoc = Stream.iterate(startNode.getLastChild(), Objects::nonNull, DetailAST::getPreviousSibling).filter(node -> node.getType() == 145).map(DetailAST::getFirstChild).map(DetailAST::getText).filter(JavadocUtil::isJavadocComment).findFirst();
        return javadoc.isPresent() && MATCH_INHERIT_DOC.matcher(javadoc.get()).find();
    }
}

