/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.sort.LFUCacheEntryWithCounter;

public class LFUCache<K, V> {
    private final boolean concurrent;
    private int targetSize;
    private int retentionThreshold = 1;
    private Map<K, LFUCacheEntryWithCounter<V>> map;

    public LFUCache(int cacheSize) {
        this(cacheSize, false);
        this.targetSize = cacheSize;
    }

    public LFUCache(int cacheSize, boolean concurrent) {
        this.concurrent = concurrent;
        this.targetSize = cacheSize;
        this.map = this.makeMap(cacheSize);
    }

    private Map<K, LFUCacheEntryWithCounter<V>> makeMap(int cacheSize) {
        if (this.concurrent) {
            return new ConcurrentHashMap(cacheSize);
        }
        return new HashMap(cacheSize);
    }

    public V get(K key) {
        LFUCacheEntryWithCounter<V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        ++entry.counter;
        return (V)entry.value;
    }

    public boolean containsKey(K key) {
        LFUCacheEntryWithCounter<V> entry = this.map.get(key);
        if (entry == null) {
            return false;
        }
        ++entry.counter;
        return true;
    }

    public void put(K key, V value) {
        this.map.put(key, new LFUCacheEntryWithCounter<V>(value));
        if (this.map.size() > 3 * this.targetSize) {
            this.rebuild();
        }
    }

    private void rebuild() {
        Map m22 = this.makeMap(this.targetSize);
        int retained = 0;
        for (Map.Entry<K, LFUCacheEntryWithCounter<V>> entry : this.map.entrySet()) {
            if (entry.getValue().counter <= this.retentionThreshold) continue;
            m22.put(entry.getKey(), new LFUCacheEntryWithCounter(entry.getValue().value));
            ++retained;
        }
        if ((double)retained > 1.5 * (double)this.targetSize) {
            ++this.retentionThreshold;
        } else if (this.retentionThreshold > 0 && retained < this.targetSize) {
            --this.retentionThreshold;
        }
        this.map = m22;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }
}

