/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.analysis;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import org.netbeans.modules.analysis.spi.Analyzer.MissingPlugin;
import org.openide.util.ImageUtilities;

/**
 *
 * @author lahvac
 */
public class RequiredPluginsPanel extends javax.swing.JPanel {

    private Set<MissingPlugin> plugins = new HashSet<MissingPlugin>();

    public RequiredPluginsPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        warning = new javax.swing.JLabel();
        install = new javax.swing.JButton();

        warning.setText(org.openide.util.NbBundle.getMessage(RequiredPluginsPanel.class, "RequiredPluginsPanel.warning.text")); // NOI18N

        install.setText(org.openide.util.NbBundle.getMessage(RequiredPluginsPanel.class, "RequiredPluginsPanel.install.text")); // NOI18N
        install.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                installActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(warning)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(install))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(warning)
                .addComponent(install))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void installActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installActionPerformed
        Utils.installMissingPlugins(this.plugins);
    }//GEN-LAST:event_installActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton install;
    private javax.swing.JLabel warning;
    // End of variables declaration//GEN-END:variables

    public void setRequiredPlugins(Set<MissingPlugin> plugins, boolean critical) {
        this.plugins = plugins;
        
        if (critical) {
            //copied from DialogDisplayer
            Color nbErrorForeground = UIManager.getColor("nb.errorForeground"); //NOI18N
            if (nbErrorForeground == null) {
                //nbErrorForeground = new Color(89, 79, 191); // RGB suggested by Bruce in #28466
                nbErrorForeground = new Color(255, 0, 0); // RGB suggested by jdinga in #65358
            }

            warning.setForeground(nbErrorForeground);
            warning.setIcon(ImageUtilities.loadImageIcon("org/netbeans/modules/dialogs/error.gif", false));
        } else {
            //copied from DialogDisplayer
            Color nbWarningForeground = UIManager.getColor("nb.warningForeground"); //NOI18N
            if (nbWarningForeground == null) {
                nbWarningForeground = new Color(51, 51, 51); // Label.foreground
            }

            warning.setForeground(nbWarningForeground);
            warning.setIcon(ImageUtilities.loadImageIcon("org/netbeans/modules/dialogs/warning.gif", false));
        }
    }
}
