var toDate = function(date) {
	if (!date) return new Date();
	if (typeof date === 'string') return new Date(date);
	return date;
};

var Stat = function(opts) {
	this.uid = opts.uid || 0;
	this.gid = opts.gid || 0;
	this.mode = opts.mode || 0;
	this.size = opts.size || 0;
	this.mtime = toDate(opts.mtime);
	this.atime = toDate(opts.atime);
	this.ctime = toDate(opts.ctime);
	this.type = opts.type;
	this.target = opts.target;
	this.link = opts.link;
	this.blob = opts.blob;
};

Stat.prototype.isDirectory = function() {
	return this.type === 'directory';
};

Stat.prototype.isFile = function() {
	return this.type === 'file';
};

Stat.prototype.isBlockDevice = function() {
	return false;
};

Stat.prototype.isCharacterDevice = function() {
	return false;
};

Stat.prototype.isSymbolicLink = function() {
	return this.type === 'symlink';
};

Stat.prototype.isFIFO = function() {
	return false;
};

Stat.prototype.isSocket = function() {
	return false;
};

module.exports = function(opts) {
	return new Stat(opts);
};