/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"
#include "compiler.h"

/* ==================== RUNTIME_RM ==================== */
#if defined(RUNTIME_RM)

CODE16;

#include "ptrace.h"
#include "entry.h"
#include "video.h"

uint8_t
putchar(uint8_t _c)
{
	uint8_t c = (uint8_t) _c;
	

	if (c == '\n') {
		putchar('\r');
	}

	/* AH = function code (print character) */
	/* AL = character code */
	/* BH = page number */
	/* BL = foreground color (graphics modes only) */
	asm volatile (
		"\tint $0x10\n"
		: /* No output. */
		: "a" ((uint16_t)((0x0e << 8) | c)),
		  "b" ((uint16_t)((0x00 << 8) | 0x00))
	);

#if 0
	if (var_get(console_type) & SERIAL_CONSOLE) {
		if (c == '\n') {
			serial_write('\r', 0);
		}
		serial_write(c, 0);
	}
#endif

	return c;
}


#endif /* RUNTIME_RM */
/* ==================== REAL-MODE INIT ==================== */
#if defined(INIT_RM)

#include "video.h"
#include "ptrace.h"
#include "entry.h"

CODE16;

void
savexy(uint8_t *xp, uint8_t *yp, uint8_t page)
{
	uint16_t ax, bx, cx, dx;

	asm volatile (
		"\tint $0x10\n"
		: "=a" (ax), "=b" (bx), "=c" (cx), "=d" (dx)
		: "0" ((uint16_t)0x0300),	/* Get Cursor Position */
		  "1" ((uint16_t)(0x00 << 8))	/* Page # */
	);

	*xp = (dx >> 0) & 0xff;
	*yp = (dx >> 8) & 0xff;
}

void
gotoxy(uint8_t x, uint8_t y, uint8_t page)
{
	uint16_t ax, bx, cx, dx;

	asm volatile (
		"\tint $0x10\n"
		: "=a" (ax), "=b" (bx), "=c" (cx), "=d" (dx)
		: "0" ((uint16_t)0x0200),	/* Set Cursor Position */
		  "1" ((uint16_t)(0x00 << 8)),	/* Page # */
		  "3" ((uint16_t)((y << 8) | x))	/* Row/Column */
	);
#if 0
	if (var_get(console_type) & SERIAL_CONSOLE) {
		serial_gotoxy(x, y);
	}
#endif
}

void
cls(void)
{
	uint16_t ax, bx, cx, dx;

	asm volatile (
		"\tint $0x10\n"
		: "=a" (ax), "=b" (bx), "=c" (cx), "=d" (dx)
		: "0" ((uint16_t)0x0600),	/* Clear Screen */
		  "1" ((uint16_t)(0x07 << 8)),	/* Attribute */
		  "2" ((uint16_t)((0 << 8) | 0)),	/* Top Left Corner */
		  "3" ((uint16_t)((24 << 8) | 79))	/* Bottom Right Corner */
	);
}

#endif /* INIT_RM */
